/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;

public final class FormulaRecordAggregate
extends RecordAggregate
implements CellValueRecordInterface {
    private final FormulaRecord _formulaRecord;
    private SharedValueManager _sharedValueManager;
    private StringRecord _stringRecord;

    public FormulaRecordAggregate(FormulaRecord formulaRec, StringRecord stringRec, SharedValueManager svm) {
        boolean hasCachedStringFlag;
        if (svm == null) {
            throw new IllegalArgumentException("sfm must not be null");
        }
        boolean hasStringRec = stringRec != null;
        if (hasStringRec != (hasCachedStringFlag = formulaRec.hasCachedResultString())) {
            throw new RecordFormatException("String record was " + (hasStringRec ? "" : "not ") + " supplied but formula record flag is " + (hasCachedStringFlag ? "" : "not ") + " set");
        }
        if (formulaRec.isSharedFormula()) {
            svm.convertSharedFormulaRecord(formulaRec);
        }
        this._formulaRecord = formulaRec;
        this._sharedValueManager = svm;
        this._stringRecord = stringRec;
    }

    public FormulaRecord getFormulaRecord() {
        return this._formulaRecord;
    }

    public StringRecord getStringRecord() {
        return this._stringRecord;
    }

    public short getXFIndex() {
        return this._formulaRecord.getXFIndex();
    }

    public void setXFIndex(short xf) {
        this._formulaRecord.setXFIndex(xf);
    }

    public void setColumn(short col) {
        this._formulaRecord.setColumn(col);
    }

    public void setRow(int row) {
        this._formulaRecord.setRow(row);
    }

    public short getColumn() {
        return this._formulaRecord.getColumn();
    }

    public int getRow() {
        return this._formulaRecord.getRow();
    }

    public String toString() {
        return this._formulaRecord.toString();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        rv.visitRecord(this._formulaRecord);
        SharedValueRecordBase sharedFormulaRecord = this._sharedValueManager.getRecordForFirstCell(this._formulaRecord);
        if (sharedFormulaRecord != null) {
            rv.visitRecord(sharedFormulaRecord);
        }
        if (this._stringRecord != null) {
            rv.visitRecord(this._stringRecord);
        }
    }

    public String getStringValue() {
        if (this._stringRecord == null) {
            return null;
        }
        return this._stringRecord.getString();
    }

    public void setCachedStringResult(String value) {
        if (this._stringRecord == null) {
            this._stringRecord = new StringRecord();
        }
        this._stringRecord.setString(value);
        if (value.length() < 1) {
            this._formulaRecord.setCachedResultTypeEmptyString();
        } else {
            this._formulaRecord.setCachedResultTypeString();
        }
    }

    public void setCachedBooleanResult(boolean value) {
        this._stringRecord = null;
        this._formulaRecord.setCachedResultBoolean(value);
    }

    public void setCachedErrorResult(int errorCode) {
        this._stringRecord = null;
        this._formulaRecord.setCachedResultErrorCode(errorCode);
    }
}

