/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.util.LittleEndian;

public final class AreaErrPtg
extends OperandPtg {
    public static final byte sid = 43;
    private final int unused1;
    private final int unused2;

    public AreaErrPtg() {
        this.unused1 = 0;
        this.unused2 = 0;
    }

    public AreaErrPtg(RecordInputStream in) {
        this.unused1 = in.readInt();
        this.unused2 = in.readInt();
    }

    public void writeBytes(byte[] array, int offset) {
        LittleEndian.putByte(array, offset + 0, 43 + this.getPtgClass());
        LittleEndian.putInt(array, offset + 1, this.unused1);
        LittleEndian.putInt(array, offset + 5, this.unused2);
    }

    public String toFormulaString() {
        return HSSFErrorConstants.getText(23);
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public int getSize() {
        return 9;
    }
}

