/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.IStartAut;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.autagent.monitoring.MonitoringUtil;
import org.eclipse.jubula.communication.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.utils.ZipUtil;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartToolkitAut
implements IStartAut {
    private static Logger log = LoggerFactory.getLogger(AbstractStartToolkitAut.class);
    private StartAUTServerStateMessage m_errorMessage;
    private boolean m_isAgentSet = false;

    @Override
    public StartAUTServerStateMessage startAut(Map parameters) throws IOException {
        StartAUTServerStateMessage envCheckMsg = this.validateEnvironment();
        if (envCheckMsg == null) {
            if (!MonitoringUtil.checkForDuplicateAutID(String.valueOf(parameters.get("AUT_ID")))) {
                MonitoringDataStore cm = MonitoringDataStore.getInstance();
                cm.putConfigMap((String)parameters.get("AUT_ID"), parameters);
            }
            File workingDir = this.getWorkingDir(parameters);
            String java = this.createBaseCmd(parameters);
            String[] cmdArray = this.createCmdArray(java, parameters);
            String[] envArray = this.createEnvArray(parameters, this.m_isAgentSet);
            if (envArray == null && log.isInfoEnabled()) {
                log.info("envArray: NULL");
            }
            if (log.isInfoEnabled()) {
                StringBuffer logMessage = new StringBuffer();
                int i = 0;
                while (i < cmdArray.length) {
                    logMessage.append(String.valueOf(cmdArray[i]) + " ");
                    ++i;
                }
                log.info("starting AUT with command: " + logMessage.toString());
            }
            return this.executeCommand(cmdArray, envArray, workingDir);
        }
        return envCheckMsg;
    }

    protected StartAUTServerStateMessage validateEnvironment() {
        return null;
    }

    protected File getWorkingDir(Map parameters) {
        File workingDir;
        String autWorkDir = (String)parameters.get("WORKING_DIR");
        if (autWorkDir == null) {
            autWorkDir = "";
        }
        if (!(workingDir = new File(autWorkDir)).isDirectory() || !workingDir.exists()) {
            if (log.isInfoEnabled()) {
                log.info("Working dir: invalid");
            }
            workingDir = null;
        }
        return workingDir;
    }

    protected String[] createEnvArray(Map parameters, boolean isAgentSet) {
        this.m_isAgentSet = isAgentSet;
        String environment = (String)parameters.get("ENVIRONMENT");
        boolean generate = (Boolean)parameters.get("NAME_TECHNICAL_COMPONENTS");
        Properties oldProp = EnvironmentUtils.getProcessEnvironment();
        String[] newEnvArray = null;
        if (generate) {
            Properties generateProperty = new Properties();
            generateProperty.setProperty("GD_GENERATE_NAMES_PROPERTY", String.valueOf(generate));
            oldProp = EnvironmentUtils.setEnvironment((Properties)oldProp, (Properties)generateProperty);
            newEnvArray = EnvironmentUtils.propToStrArray((Properties)oldProp, (String)"=");
        }
        if (environment != null && environment.trim().length() != 0) {
            String[] envArray = EnvironmentUtils.strToStrArray((String)environment, (String)"\r\n");
            Properties newProp = EnvironmentUtils.strArrayToProp((String[])envArray, (String)"=");
            newProp = EnvironmentUtils.setEnvironment((Properties)oldProp, (Properties)newProp);
            newEnvArray = EnvironmentUtils.propToStrArray((Properties)newProp, (String)"=");
        }
        return newEnvArray;
    }

    protected abstract String createBaseCmd(Map var1) throws IOException;

    protected abstract String[] createCmdArray(String var1, Map var2);

    protected StartAUTServerStateMessage executeCommand(String[] cmdArray, String[] envArray, File workingDir) throws IOException {
        AutStarter autStarter = AutStarter.getInstance();
        Process process = Runtime.getRuntime().exec(cmdArray, envArray, workingDir);
        if (this.isErrorMessage()) {
            System.out.println("AbstractStartToolkitAut - executeCommand: " + this.getErrorMessage());
            return this.getErrorMessage();
        }
        if (!autStarter.watchAutServer(process, this.m_isAgentSet)) {
            process.destroy();
            return this.createBusyMessage();
        }
        return new StartAUTServerStateMessage(0);
    }

    protected void setErrorMessage(StartAUTServerStateMessage errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    protected StartAUTServerStateMessage getErrorMessage() {
        if (this.m_errorMessage == null) {
            this.m_errorMessage = new StartAUTServerStateMessage(1, "Unexpected error, no detail available.");
        }
        return this.m_errorMessage;
    }

    protected boolean isErrorMessage() {
        return this.m_errorMessage != null;
    }

    protected StartAUTServerStateMessage createBusyMessage() {
        return new StartAUTServerStateMessage(1, "AUTServer is already running");
    }

    public static String[] getClasspathEntriesForBundleId(String bundleId) {
        ArrayList<String> classpathEntries;
        block9: {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                log.error("No bundle found for ID '" + bundleId + "'.");
                return new String[0];
            }
            classpathEntries = new ArrayList<String>();
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                if (bundleFile.isFile()) {
                    classpathEntries.add(bundleFile.getAbsolutePath());
                    try {
                        File[] createdFiles = ZipUtil.unzipTempJars((File)bundleFile);
                        int i = 0;
                        while (i < createdFiles.length) {
                            classpathEntries.add(createdFiles[i].getAbsolutePath());
                            ++i;
                        }
                        break block9;
                    }
                    catch (IOException e) {
                        log.error("An error occurred while trying to extract nested JARs from " + bundleId, (Throwable)e);
                    }
                    break block9;
                }
                Enumeration e = bundle.findEntries("/", "*.jar", true);
                if (e != null) {
                    while (e.hasMoreElements()) {
                        URL jarUrl = (URL)e.nextElement();
                        classpathEntries.add(new File(bundleFile + jarUrl.getFile()).getAbsolutePath());
                    }
                }
            }
            catch (IOException ioe) {
                log.error("Bundle with ID '" + bundleId + "' could not be resolved to a file.", (Throwable)ioe);
            }
        }
        return classpathEntries.toArray(new String[classpathEntries.size()]);
    }

    public static String getClasspathForBundleId(String bundleId) {
        StringBuilder pathBuilder = new StringBuilder();
        String[] stringArray = AbstractStartToolkitAut.getClasspathEntriesForBundleId(bundleId);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            pathBuilder.append(entry).append(PATH_SEPARATOR);
            ++n2;
        }
        return pathBuilder.substring(0, pathBuilder.lastIndexOf(PATH_SEPARATOR));
    }
}

