/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private String m_message;
    private Combo m_comboBox;
    private List<String> m_inputList;
    private String m_selection = null;
    private int m_selectionIndex;
    private String m_label;
    private String m_title;
    private Image m_image;
    private String m_shellTitle;

    public ComboBoxDialog(Shell parentShell, List<String> inputList, String message, String title, Image image, String shellTitle, String label) {
        super(parentShell);
        this.m_inputList = inputList;
        this.m_message = message;
        this.m_label = label;
        this.m_title = title;
        this.m_image = image;
        this.m_shellTitle = shellTitle;
    }

    protected Control createDialogArea(Composite parent) {
        this.inputListSort();
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(this.m_image);
        this.getShell().setText(this.m_shellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createComboBox(area);
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    private void inputListSort() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String s1 = o1.toLowerCase();
                String s2 = o2.toLowerCase();
                return s1.compareTo(s2);
            }
        };
        TreeSet<String> set = new TreeSet<String>(comparator);
        set.addAll(this.m_inputList);
        this.m_inputList.clear();
        this.m_inputList.addAll(set);
    }

    private void createComboBox(Composite parent) {
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        new Label(parent, 0).setText(this.m_label);
        this.m_comboBox = new Combo(parent, 2060);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_comboBox);
        this.m_comboBox.setLayoutData((Object)gridData);
        this.fillComboBox();
        this.m_comboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComboBoxDialog.this.enableOKButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setMessage(this.m_message);
    }

    protected void okPressed() {
        this.m_selectionIndex = this.m_comboBox.getSelectionIndex();
        this.m_selection = this.m_selectionIndex != -1 ? this.m_comboBox.getText() : null;
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    protected void fillComboBox() {
        for (String newItem : this.m_inputList) {
            this.m_comboBox.add(newItem);
        }
        if (this.m_comboBox.getItemCount() > 0) {
            this.m_comboBox.select(0);
        }
    }

    public String getSelection() {
        return this.m_selection;
    }

    public Combo getComboBox() {
        return this.m_comboBox;
    }

    public List getInputList() {
        return this.m_inputList;
    }

    public int getSelectionIndex() {
        return this.m_selectionIndex;
    }
}

