/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeleteBrowserTreeItemHandler
extends AbstractDeleteTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IStructuredSelection structuredSelection = this.getSelection();
        if (this.confirmDelete(structuredSelection)) {
            this.deleteSelection(structuredSelection);
        }
        return null;
    }

    private void deleteSelection(IStructuredSelection selection) {
        HashSet<INodePO> set = new HashSet<INodePO>(selection.toList());
        HashSet<INodePO> topNodesToDelete = new HashSet<INodePO>();
        for (INodePO node : set) {
            if (this.containsParent(set, node)) continue;
            topNodesToDelete.add(node);
        }
        ArrayList<INodePO> nodesToDelete = new ArrayList<INodePO>();
        for (INodePO node : topNodesToDelete) {
            this.collectNodesToDelete(nodesToDelete, node);
        }
        Collections.reverse(nodesToDelete);
        List<MultipleNodePM.AbstractCmdHandle> cmds = this.getDeleteCommands(nodesToDelete);
        if (!cmds.isEmpty()) {
            try {
                MultipleNodePM.getInstance().executeCommands(cmds);
                ArrayList<DataChangedEvent> eventList = new ArrayList<DataChangedEvent>();
                for (INodePO node : topNodesToDelete) {
                    eventList.add(new DataChangedEvent((IPersistentObject)node, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all));
                }
                DataEventDispatcher.getInstance().fireDataChangedListener(eventList.toArray(new DataChangedEvent[0]));
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
        }
    }

    protected abstract List<MultipleNodePM.AbstractCmdHandle> getDeleteCommands(List<INodePO> var1);

    protected abstract void collectNodesToDelete(List<INodePO> var1, INodePO var2);

    private boolean containsParent(Set<INodePO> set, INodePO node) {
        INodePO parent = node.getParentNode();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }
}

