/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.rcp.search.data.AbstractSearchData;
import org.eclipse.jubula.client.ui.rcp.search.data.StructureSearchData;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractSearchQuery;

public class StructureSearchQuery
extends AbstractSearchQuery {
    public StructureSearchQuery(StructureSearchData searchData) {
        this.setSearchData(searchData);
    }

    public IStatus run(IProgressMonitor monitor) {
        int operation = 1;
        if (this.getSearchData().isUseRegex()) {
            operation = 3;
        } else if (this.getSearchData().isCaseSensitive()) {
            operation = 2;
        }
        List<AbstractSearchData.SearchableType> listOfTypesToSearchIn = this.getSearchData().getTypesToSearchIn();
        HashSet listOfNodes = new HashSet();
        monitor.beginTask("Collecting all Elements...", listOfTypesToSearchIn.size());
        for (AbstractSearchData.SearchableType type : listOfTypesToSearchIn) {
            listOfNodes.addAll(NodeBP.getAllNodesForGivenTypeInCurrentProject(type.getType()));
            monitor.worked(1);
        }
        monitor.beginTask("Searching...", listOfNodes.size());
        String searchString = this.getSearchData().getSearchString();
        HashSet<INodePO> resultList = new HashSet<INodePO>();
        for (INodePO node : listOfNodes) {
            if (StructureSearchQuery.compare(node.getName(), searchString, operation)) {
                resultList.add(node);
            }
            monitor.worked(1);
        }
        this.setSearchResult(this.getSearchResultList(resultList, null));
        return Status.OK_STATUS;
    }

    private void setSearchData(StructureSearchData searchData) {
        super.setSearchData(searchData);
    }

    public StructureSearchData getSearchData() {
        return (StructureSearchData)super.getSearchData();
    }
}

