/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandHelper {
    private static Logger log = LoggerFactory.getLogger(CommandHelper.class);

    private CommandHelper() {
    }

    public static Object executeCommand(String commandID) {
        return CommandHelper.executeCommand(commandID, null);
    }

    public static Object executeCommand(String commandID, IWorkbenchPartSite site) {
        IHandlerService handlerService = site != null ? (IHandlerService)site.getService(IHandlerService.class) : CommandHelper.getHandlerService();
        try {
            return handlerService.executeCommand(commandID, null);
        }
        catch (CommandException commandException) {
            log.warn(String.valueOf(Messages.ErrorOccurredWhileExecutingCommand) + ":" + " " + commandID);
            return null;
        }
    }

    public static Object executeParameterizedCommand(ParameterizedCommand pc) {
        IHandlerService handlerService = CommandHelper.getHandlerService();
        try {
            return handlerService.executeCommand(pc, null);
        }
        catch (CommandException commandException) {
            log.warn(String.valueOf(Messages.ErrorOccurredWhileExecutingCommand) + ":" + " " + pc.getId());
            return null;
        }
    }

    public static IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    public static ICommandService getCommandService() {
        return (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    }

    public static void createContributionPushItem(IMenuManager menuManager, String commandId) {
        menuManager.add(CommandHelper.createContributionItem(commandId, null, null, 8));
    }

    public static void createContributionItem(IMenuManager menuManager, String commandId, int style) {
        menuManager.add(CommandHelper.createContributionItem(commandId, null, null, style));
    }

    public static IContributionItem createContributionItem(String commandId, Map params, String label, int style) {
        CommandContributionItemParameter itemParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, commandId, style);
        itemParameter.label = label;
        if (params != null) {
            if (itemParameter.parameters == null) {
                itemParameter.parameters = new HashMap(params);
            } else {
                itemParameter.parameters.putAll(params);
            }
        }
        return new CommandContributionItem(itemParameter);
    }
}

