/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.adaptable;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.rc.common.adaptable.IAdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFactoryRegistry {
    private static final String ADAPTER_PACKAGE_NAME = "org.eclipse.jubula.rc.common.adapter";
    private static Logger log;
    private static AdapterFactoryRegistry instance;
    private Map m_registrationMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        instance = new AdapterFactoryRegistry();
    }

    private AdapterFactoryRegistry() {
    }

    public static AdapterFactoryRegistry getInstance() {
        return instance;
    }

    public void registerFactory(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            ArrayList<IAdapterFactory> registeredFactories = (ArrayList<IAdapterFactory>)this.m_registrationMap.get(supportedClasses[i]);
            if (registeredFactories == null) {
                registeredFactories = new ArrayList<IAdapterFactory>();
            }
            registeredFactories.add(factory);
            this.m_registrationMap.put(supportedClasses[i], registeredFactories);
            ++i;
        }
    }

    public void signOffFactory(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            Collection registeredFactories = (Collection)this.m_registrationMap.get(supportedClasses[i]);
            if (registeredFactories == null) {
                return;
            }
            registeredFactories.remove(factory);
            this.m_registrationMap.put(supportedClasses[i], registeredFactories);
            ++i;
        }
    }

    public Object getAdapter(Class targetAdapterClass, Object objectToAdapt) {
        Collection registeredFactories = (Collection)this.m_registrationMap.get(targetAdapterClass);
        if (registeredFactories == null) {
            return null;
        }
        Iterator iterator = registeredFactories.iterator();
        while (iterator.hasNext()) {
            IAdapterFactory adapterFactory = (IAdapterFactory)iterator.next();
            Object object = adapterFactory.getAdapter(targetAdapterClass, objectToAdapt);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static void initRegistration() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.common.adaptable.IAdapterFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class[] adapterFactories = AdapterFactoryRegistry.findClassesOfType(ADAPTER_PACKAGE_NAME, clazz);
        int i = 0;
        while (i < adapterFactories.length) {
            try {
                IAdapterFactory factory = (IAdapterFactory)adapterFactories[i].newInstance();
                AdapterFactoryRegistry.getInstance().registerFactory(factory);
            }
            catch (IllegalAccessException e) {
                log.error("An error occured: ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error("An error occured: ", (Throwable)e);
            }
            ++i;
        }
    }

    private static Class[] findClassesOfType(String packageName, Class superclass) {
        try {
            Class[] allClasses = AdapterFactoryRegistry.getClasses(packageName);
            ArrayList<Class> assignableClasses = new ArrayList<Class>();
            int i = 0;
            while (i < allClasses.length) {
                if (superclass.isAssignableFrom(allClasses[i]) && superclass != allClasses[i]) {
                    assignableClasses.add(allClasses[i]);
                }
                ++i;
            }
            return AdapterFactoryRegistry.castListToClassArray(assignableClasses);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Class[0];
        }
        catch (IOException iOException) {
            return new Class[0];
        }
    }

    private static Class[] castListToClassArray(List classes) {
        Class[] arrayClasses = new Class[classes.size()];
        int i = 0;
        while (i < arrayClasses.length) {
            arrayClasses[i] = (Class)classes.get(i);
            ++i;
        }
        return arrayClasses;
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        int i = 0;
        while (i < dirs.size()) {
            classes.addAll(AdapterFactoryRegistry.findClasses((File)dirs.get(i), packageName));
            ++i;
        }
        return AdapterFactoryRegistry.castListToClassArray(classes);
    }

    private static List findClasses(File directory, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                classes.addAll(AdapterFactoryRegistry.findClasses(file, String.valueOf(packageName) + '.' + fileName));
            } else if (fileName.endsWith(".class")) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + fileName.substring(0, fileName.length() - 6)));
            }
            ++i;
        }
        return classes;
    }
}

