/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class ExternSheetRecord
extends Record {
    public static final short sid = 23;
    private List _list = new ArrayList();

    public ExternSheetRecord() {
    }

    public ExternSheetRecord(RecordInputStream in) {
        int nItems = in.readShort();
        int i = 0;
        while (i < nItems) {
            RefSubRecord rec = new RefSubRecord(in);
            this._list.add(rec);
            ++i;
        }
    }

    public int getNumOfRefs() {
        return this._list.size();
    }

    public void addREFRecord(RefSubRecord rec) {
        this._list.add(rec);
    }

    public int getNumOfREFRecords() {
        return this._list.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int nItems = this._list.size();
        sb.append("[EXTERNSHEET]\n");
        sb.append("   numOfRefs     = ").append(nItems).append("\n");
        int i = 0;
        while (i < nItems) {
            sb.append("refrec         #").append(i).append(": ");
            sb.append(this.getRef(i).toString());
            sb.append('\n');
            ++i;
        }
        sb.append("[/EXTERNSHEET]\n");
        return sb.toString();
    }

    private int getDataSize() {
        return 2 + this._list.size() * 6;
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        int nItems = this._list.size();
        LittleEndian.putShort(data, 0 + offset, (short)23);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putUShort(data, 4 + offset, nItems);
        int pos = 6;
        int i = 0;
        while (i < nItems) {
            this.getRef(i).serialize(offset + pos, data);
            pos += 6;
            ++i;
        }
        return dataSize + 4;
    }

    private RefSubRecord getRef(int i) {
        return (RefSubRecord)this._list.get(i);
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public short getSid() {
        return 23;
    }

    public int getExtbookIndexFromRefIndex(int refIndex) {
        return this.getRef(refIndex).getExtBookIndex();
    }

    public int findRefIndexFromExtBookIndex(int extBookIndex) {
        int nItems = this._list.size();
        int i = 0;
        while (i < nItems) {
            if (this.getRef(i).getExtBookIndex() == extBookIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getFirstSheetIndexFromRefIndex(int extRefIndex) {
        return this.getRef(extRefIndex).getFirstSheetIndex();
    }

    public int addRef(int extBookIndex, int firstSheetIndex, int lastSheetIndex) {
        this._list.add(new RefSubRecord(extBookIndex, firstSheetIndex, lastSheetIndex));
        return this._list.size() - 1;
    }

    public int getRefIxForSheet(int externalBookIndex, int sheetIndex) {
        int nItems = this._list.size();
        int i = 0;
        while (i < nItems) {
            RefSubRecord ref = this.getRef(i);
            if (ref.getExtBookIndex() == externalBookIndex && ref.getFirstSheetIndex() == sheetIndex && ref.getLastSheetIndex() == sheetIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ExternSheetRecord combine(ExternSheetRecord[] esrs) {
        ExternSheetRecord result = new ExternSheetRecord();
        int i = 0;
        while (i < esrs.length) {
            ExternSheetRecord esr = esrs[i];
            int nRefs = esr.getNumOfREFRecords();
            int j = 0;
            while (j < nRefs) {
                result.addREFRecord(esr.getRef(j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private final class RefSubRecord {
        public static final int ENCODED_SIZE = 6;
        private int _extBookIndex;
        private int _firstSheetIndex;
        private int _lastSheetIndex;

        public RefSubRecord(int extBookIndex, int firstSheetIndex, int lastSheetIndex) {
            this._extBookIndex = extBookIndex;
            this._firstSheetIndex = firstSheetIndex;
            this._lastSheetIndex = lastSheetIndex;
        }

        public RefSubRecord(RecordInputStream in) {
            this(in.readShort(), in.readShort(), in.readShort());
        }

        public int getExtBookIndex() {
            return this._extBookIndex;
        }

        public int getFirstSheetIndex() {
            return this._firstSheetIndex;
        }

        public int getLastSheetIndex() {
            return this._lastSheetIndex;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("extBook=").append(this._extBookIndex);
            buffer.append(" firstSheet=").append(this._firstSheetIndex);
            buffer.append(" lastSheet=").append(this._lastSheetIndex);
            return buffer.toString();
        }

        public void serialize(int offset, byte[] data) {
            LittleEndian.putUShort(data, 0 + offset, this._extBookIndex);
            LittleEndian.putUShort(data, 2 + offset, this._firstSheetIndex);
            LittleEndian.putUShort(data, 4 + offset, this._lastSheetIndex);
        }
    }
}

