/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Index
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        Eval firstArg = args[0];
        if (firstArg instanceof RefEval) {
            firstArg = ((RefEval)firstArg).offset(0, 0, 0, 0);
        }
        if (!(firstArg instanceof AreaEval)) {
            throw new RuntimeException("Incomplete code - cannot handle first arg of type (" + firstArg.getClass().getName() + ")");
        }
        AreaEval reference = (AreaEval)firstArg;
        int rowIx = 0;
        int columnIx = 0;
        try {
            switch (nArgs) {
                case 4: {
                    Index.convertIndexArgToZeroBase(args[3], srcCellRow, srcCellCol);
                    throw new RuntimeException("Incomplete code - don't know how to support the 'area_num' parameter yet)");
                }
                case 3: {
                    columnIx = Index.convertIndexArgToZeroBase(args[2], srcCellRow, srcCellCol);
                }
                case 2: {
                    rowIx = Index.convertIndexArgToZeroBase(args[1], srcCellRow, srcCellCol);
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
            return Index.getValueFromArea(reference, rowIx, columnIx, nArgs);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static ValueEval getValueFromArea(AreaEval ae, int pRowIx, int pColumnIx, int nArgs) throws EvaluationException {
        int columnIx;
        int rowIx;
        if (ae.isRow()) {
            if (ae.isColumn()) {
                rowIx = pRowIx == -1 ? 0 : pRowIx;
                columnIx = pColumnIx == -1 ? 0 : pColumnIx;
            } else if (nArgs == 2) {
                rowIx = 0;
                columnIx = pRowIx;
            } else {
                rowIx = pRowIx == -1 ? 0 : pRowIx;
                columnIx = pColumnIx;
            }
            if (rowIx < -1 || columnIx < -1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
        } else if (ae.isColumn()) {
            if (nArgs == 2) {
                rowIx = pRowIx;
                columnIx = 0;
            } else {
                rowIx = pRowIx;
                int n = columnIx = pColumnIx == -1 ? 0 : pColumnIx;
            }
            if (rowIx < -1 || columnIx < -1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
        } else {
            if (nArgs == 2) {
                if (pRowIx < -1) {
                    throw new EvaluationException(ErrorEval.VALUE_INVALID);
                }
                throw new EvaluationException(ErrorEval.REF_INVALID);
            }
            rowIx = pRowIx;
            columnIx = pColumnIx;
        }
        int width = ae.getWidth();
        int height = ae.getHeight();
        if (rowIx >= height || columnIx >= width) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        if (rowIx < 0 || columnIx < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return ae.getRelativeValue(rowIx, columnIx);
    }

    private static int convertIndexArgToZeroBase(Eval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        int oneBasedVal = OperandResolver.coerceValueToInt(ev);
        return oneBasedVal - 1;
    }
}

