/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public abstract class TextFunction
implements Function {
    protected static final String EMPTY_STRING = "";
    public static final Function LEN = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new NumberEval(arg.length());
        }
    };
    public static final Function LOWER = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new StringEval(arg.toLowerCase());
        }
    };
    public static final Function UPPER = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new StringEval(arg.toUpperCase());
        }
    };
    public static final Function TRIM = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new StringEval(arg.trim());
        }
    };
    public static final Function MID = new TextFunction(){

        protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            if (args.length != 3) {
                return ErrorEval.VALUE_INVALID;
            }
            String text = 5.evaluateStringArg(args[0], srcCellRow, srcCellCol);
            int startCharNum = 5.evaluateIntArg(args[1], srcCellRow, srcCellCol);
            int numChars = 5.evaluateIntArg(args[2], srcCellRow, srcCellCol);
            int startIx = startCharNum - 1;
            if (startIx < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            if (numChars < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            int len = text.length();
            if (numChars < 0 || startIx > len) {
                return new StringEval(TextFunction.EMPTY_STRING);
            }
            int endIx = Math.min(startIx + numChars, len);
            String result = text.substring(startIx, endIx);
            return new StringEval(result);
        }
    };
    public static final Function LEFT = new LeftRight(true);
    public static final Function RIGHT = new LeftRight(false);
    public static final Function CONCATENATE = new TextFunction(){

        protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int iSize = args.length;
            while (i < iSize) {
                sb.append(6.evaluateStringArg(args[i], srcCellRow, srcCellCol));
                ++i;
            }
            return new StringEval(sb.toString());
        }
    };
    public static final Function EXACT = new TextFunction(){

        protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            if (args.length != 2) {
                return ErrorEval.VALUE_INVALID;
            }
            String s0 = 7.evaluateStringArg(args[0], srcCellRow, srcCellCol);
            String s1 = 7.evaluateStringArg(args[1], srcCellRow, srcCellCol);
            return BoolEval.valueOf(s0.equals(s1));
        }
    };

    protected static final String evaluateStringArg(Eval eval, int srcRow, short srcCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(eval, srcRow, srcCol);
        return OperandResolver.coerceValueToString(ve);
    }

    protected static final int evaluateIntArg(Eval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        return OperandResolver.coerceValueToInt(ve);
    }

    public final Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        try {
            return this.evaluateFunc(args, srcCellRow, srcCellCol);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    protected abstract ValueEval evaluateFunc(Eval[] var1, int var2, short var3) throws EvaluationException;

    private static final class LeftRight
    extends TextFunction {
        private final boolean _isLeft;

        protected LeftRight(boolean isLeft) {
            this._isLeft = isLeft;
        }

        protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            if (args.length != 2) {
                return ErrorEval.VALUE_INVALID;
            }
            String arg = LeftRight.evaluateStringArg(args[0], srcCellRow, srcCellCol);
            int index = LeftRight.evaluateIntArg(args[1], srcCellRow, srcCellCol);
            String result = this._isLeft ? arg.substring(0, Math.min(arg.length(), index)) : arg.substring(Math.max(0, arg.length() - index));
            return new StringEval(result);
        }
    }

    private static abstract class SingleArgTextFunc
    extends TextFunction {
        protected SingleArgTextFunc() {
        }

        protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            if (args.length != 1) {
                return ErrorEval.VALUE_INVALID;
            }
            String arg = SingleArgTextFunc.evaluateStringArg(args[0], srcCellRow, srcCellCol);
            return this.evaluate(arg);
        }

        protected abstract ValueEval evaluate(String var1);
    }
}

