/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.JTableHeaderImplClass;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJTableImplClass;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JTableImplClass
extends AbstractSwingImplClass
implements IJTableImplClass {
    private static AutServerLogger log;
    private JTable m_table;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JTableImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public void setComponent(Object graphicsComponent) {
        this.m_table = (JTable)graphicsComponent;
    }

    public JComponent getComponent() {
        return this.m_table;
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    private void checkRowColBounds(int row, int column) throws StepExecutionException {
        this.checkBounds(row, this.m_table.getRowCount());
        this.checkBounds(column, this.m_table.getColumnCount());
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        Point mousePos = this.getRobot().getCurrentMousePosition();
        Point tablePos = this.m_table.getLocationOnScreen();
        Point relativePos = new Point(mousePos.x - tablePos.x, mousePos.y - tablePos.y);
        int column = this.m_table.columnAtPoint(relativePos);
        int row = this.m_table.rowAtPoint(relativePos);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected row, col: " + row + ", " + column));
        }
        this.checkRowColBounds(row, column);
        return new Cell(row, column);
    }

    private Cell getSelectedCell() throws StepExecutionException {
        int row = this.m_table.getSelectedRow();
        int col = this.m_table.getSelectedColumn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected row, col: " + row + ", " + col));
        }
        try {
            this.checkRowColBounds(row, col);
        }
        catch (StepExecutionException e) {
            if (e.getEvent() != null && "TestErrorEvent.InvalidIndex".equals(e.getEvent().getProps().get("guidancerErrorDescription"))) {
                throw new StepExecutionException("No selection", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
            throw e;
        }
        return new Cell(row, col);
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getSelectedCell().getCol() + 1;
        }
        return startingIndex;
    }

    private int getStartingRowIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getSelectedCell().getRow() + 1;
        }
        return startingIndex;
    }

    private Cell invokeGetSelectedCell() throws StepExecutionException {
        return (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", new IRunnable(){

            public Object run() {
                return JTableImplClass.this.getSelectedCell();
            }
        });
    }

    private Cell invokeGetCellAtMousePosition() throws StepExecutionException {
        return (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition()", new IRunnable(){

            public Object run() {
                return JTableImplClass.this.getCellAtMousePosition();
            }
        });
    }

    private Rectangle invokeScrollCellToVisible(final int row, final int col) throws StepExecutionException {
        Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getCellRect", new IRunnable(){

            public Object run() {
                return JTableImplClass.this.m_table.getCellRect(row, col, true);
            }
        });
        this.getRobot().scrollToVisible((Object)this.m_table, (Object)bounds);
        return bounds;
    }

    private void gdSelectCell(String row, String rowOperator, String col, String colOperator, ClickOptions co, String extendSelection) {
        this.gdSelectCell(row, rowOperator, col, colOperator, co.getClickCount(), 50, "Percent", 50, "Percent", extendSelection, co.getMouseButton());
    }

    private void gdSelectCell(int row, int col, int clickCount, String extendSelection) {
        this.gdSelectCell(row, col, clickCount, 50, "Percent", 50, "Percent", extendSelection);
    }

    /*
     * Exception decompiling
     */
    public void gdSelectCell(String row, String rowOperator, String col, String colOperator, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection, int button) throws StepExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 254->258)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void gdSelectCell(int row, int col, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 204->208)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gdMove(String direction, int cellCount, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell currCell = null;
        try {
            currCell = this.invokeGetCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            currCell = this.invokeGetSelectedCell();
        }
        int newCol = currCell.getCol();
        int newRow = currCell.getRow();
        if ("up".equalsIgnoreCase(direction)) {
            newRow -= cellCount;
        } else if ("down".equalsIgnoreCase(direction)) {
            newRow += cellCount;
        } else if ("left".equalsIgnoreCase(direction)) {
            newCol -= cellCount;
        } else if ("right".equalsIgnoreCase(direction)) {
            newCol += cellCount;
        }
        newRow = IndexConverter.toUserIndex((int)newRow);
        newCol = IndexConverter.toUserIndex((int)newCol);
        this.gdSelectCell(newRow, newCol, clickCount, xPos, xUnits, yPos, yUnits, extendSelection);
    }

    public void gdSelectRow(int row, String extendSelection) throws StepExecutionException {
        this.gdSelectCell(row, IndexConverter.toUserIndex((int)0), 1, extendSelection);
    }

    public void gdVerifyText(String text, String operator, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        String current;
        final int implRow = this.getRowFromString(row, rowOperator);
        final int implCol = this.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            current = (String)this.getEventThreadQueuer().invokeAndWait("gdVerifyText", new IRunnable(){

                public Object run() {
                    return JTableImplClass.this.m_table.getColumnName(implCol);
                }
            });
        } else {
            this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

                public Object run() {
                    JTableImplClass.this.checkRowColBounds(implRow, implCol);
                    return null;
                }
            });
            this.invokeScrollCellToVisible(implRow, implCol);
            current = this.getCellText(implRow, implCol);
        }
        Verifier.match((String)current, (String)text, (String)operator);
    }

    public void gdVerifyText(String text, String operator, int row, int col) throws StepExecutionException {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

            public Object run() {
                JTableImplClass.this.checkRowColBounds(implRow, implCol);
                return null;
            }
        });
        this.invokeScrollCellToVisible(implRow, implCol);
        String current = this.getCellText(implRow, implCol);
        Verifier.match((String)current, (String)text, (String)operator);
    }

    protected String getCellText(final int row, final int col) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getCellText", new IRunnable(){

            public Object run() {
                Object value = JTableImplClass.this.m_table.getValueAt(row, col);
                boolean selected = JTableImplClass.this.m_table.isCellSelected(row, col);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting cell text:");
                    log.debug((Object)("Row, col: " + row + ", " + col));
                    log.debug((Object)("Value: " + value));
                }
                TableCellRenderer renderer = JTableImplClass.this.m_table.getCellRenderer(row, col);
                Component c = renderer.getTableCellRendererComponent(JTableImplClass.this.m_table, value, selected, true, row, col);
                return JTableImplClass.this.getRenderedText(c, false);
            }
        });
        return current;
    }

    public void gdVerifyText(String text, String operator) throws StepExecutionException {
        Cell cell = this.invokeGetSelectedCell();
        this.gdVerifyText(text, operator, IndexConverter.toUserIndex((int)cell.getRow()), IndexConverter.toUserIndex((int)cell.getCol()));
    }

    public void gdVerifyTextAtMousePosition(String text, String operator) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = this.invokeGetCellAtMousePosition();
        this.gdVerifyText(text, operator, IndexConverter.toUserIndex((int)cell.getRow()), IndexConverter.toUserIndex((int)cell.getCol()));
    }

    public void gdVerifyText(String text) throws StepExecutionException {
        this.gdVerifyText(text, "equals");
    }

    public void gdVerifyValueInRow(String row, String rowOperator, final String value, final String operator, final String searchType, boolean exists) throws StepExecutionException {
        final int implRow = this.getRowFromString(row, rowOperator);
        Boolean valueExists = Boolean.TRUE;
        valueExists = implRow == -1 ? (Boolean)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int k = JTableImplClass.this.getStartingColIndex(searchType);
                while (k < JTableImplClass.this.m_table.getColumnCount()) {
                    String header = JTableImplClass.this.m_table.getColumnName(k);
                    if (MatchUtil.getInstance().match(header, value, operator)) {
                        return Boolean.TRUE;
                    }
                    ++k;
                }
                return Boolean.FALSE;
            }
        }) : (Boolean)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = JTableImplClass.this.getStartingColIndex(searchType);
                while (i < JTableImplClass.this.m_table.getColumnCount()) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(implRow, i), value, operator)) {
                        return Boolean.TRUE;
                    }
                    ++i;
                }
                return Boolean.FALSE;
            }
        });
        Verifier.equals((boolean)exists, (boolean)valueExists);
    }

    public void gdVerifyValueInColumn(String col, String colOperator, final String value, final String operator, final String searchType, boolean exists) throws StepExecutionException {
        final int implCol = this.getColumnFromString(col, colOperator);
        Boolean valueExists = (Boolean)this.getEventThreadQueuer().invokeAndWait("verifyValueInColumn", new IRunnable(){

            public Object run() throws StepExecutionException {
                int rowCount = JTableImplClass.this.m_table.getRowCount();
                int i = JTableImplClass.this.getStartingRowIndex(searchType);
                while (i < rowCount) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(i, implCol), value, operator)) {
                        return Boolean.TRUE;
                    }
                    ++i;
                }
                String header = JTableImplClass.this.m_table.getColumnName(implCol);
                if (MatchUtil.getInstance().match(header, value, operator)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        Verifier.equals((boolean)exists, (boolean)valueExists);
    }

    private boolean isCellEditable() throws StepExecutionException {
        Boolean editable = (Boolean)this.getEventThreadQueuer().invokeAndWait("isCellEditable", new IRunnable(){

            public Object run() {
                Cell cell = JTableImplClass.this.getSelectedCell();
                return JTableImplClass.this.m_table.isCellEditable(cell.getRow(), cell.getCol()) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return editable;
    }

    private boolean isCellEditableMousePosition() throws StepExecutionException {
        Boolean editable = (Boolean)this.getEventThreadQueuer().invokeAndWait("isCellEditable", new IRunnable(){

            public Object run() {
                Cell cell = JTableImplClass.this.getCellAtMousePosition();
                return JTableImplClass.this.m_table.isCellEditable(cell.getRow(), cell.getCol()) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return editable;
    }

    public void gdVerifyEditable(boolean editable) {
        Verifier.equals((boolean)editable, (boolean)this.isCellEditable());
    }

    private void verifyEditableMousePosition(boolean editable) {
        Verifier.equals((boolean)editable, (boolean)this.isCellEditableMousePosition());
    }

    public void gdVerifyEditable(boolean editable, String row, String rowOperator, String col, String colOperator) {
        if (this.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create(), "no");
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditable(boolean editable, int row, int col) {
        this.gdSelectCell(row, col, 1, "no");
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditableSelected(boolean editable) {
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditableMousePosition(boolean editable) {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.verifyEditableMousePosition(editable);
    }

    private Component getTableCellEditor(final Cell cell) {
        return (Component)this.getEventThreadQueuer().invokeAndWait("getCellEditor", new IRunnable(){

            public Object run() {
                Object value = JTableImplClass.this.m_table.getValueAt(cell.getRow(), cell.getCol());
                boolean selected = JTableImplClass.this.m_table.isCellSelected(cell.getRow(), cell.getCol());
                return JTableImplClass.this.m_table.getCellEditor(cell.getRow(), cell.getCol()).getTableCellEditorComponent(JTableImplClass.this.m_table, value, selected, cell.getRow(), cell.getCol());
            }
        });
    }

    public void gdReplaceText(String text) throws StepExecutionException {
        this.inputText(text, true);
    }

    public void gdReplaceText(String text, String row, String rowOperator, String col, String colOperator) {
        if (this.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create(), "no");
        this.inputText(text, true);
    }

    public void gdReplaceText(String text, int row, int col) {
        this.gdSelectCell(row, col, 1, "no");
        this.inputText(text, true);
    }

    public void gdInputText(String text) throws StepExecutionException {
        this.inputText(text, false);
    }

    private void inputText(String text, boolean replace) throws StepExecutionException {
        Cell cell = this.invokeGetSelectedCell();
        if (!this.isCellEditable()) {
            throw new StepExecutionException("Selected table cell " + cell + " is not editable", EventFactory.createActionError((String)"TestErrorEvent.NotEditable"));
        }
        Rectangle rectangle = this.invokeScrollCellToVisible(cell.getRow(), cell.getCol());
        this.getRobot().click((Object)this.m_table, (Object)rectangle);
        Component editor = this.getTableCellEditor(cell);
        if (editor == null) {
            ClickOptions co = ClickOptions.create().setClickCount(2);
            this.getRobot().click((Object)this.m_table, (Object)rectangle, co);
            editor = this.getTableCellEditor(cell);
        }
        if (replace) {
            this.getRobot().clickAtCurrentPosition((Object)editor, 3, 1);
        } else {
            editor = this.m_table;
        }
        this.getRobot().type((Object)editor, text);
    }

    public void gdInputText(String text, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        if (this.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create(), "no");
        this.gdInputText(text);
    }

    public void gdInputText(String text, int row, int col) throws StepExecutionException {
        this.gdSelectCell(row, col, 1, "no");
        this.gdInputText(text);
    }

    public void gdClick(int count, int button) {
        Cell currCell = null;
        if (this.isMouseOverCell()) {
            currCell = this.invokeGetCellAtMousePosition();
        } else if (this.isCellSelection()) {
            currCell = this.invokeGetSelectedCell();
        }
        if (currCell != null) {
            final Cell cell = currCell;
            Rectangle rectangle = (Rectangle)this.getEventThreadQueuer().invokeAndWait("click", new IRunnable(){

                public Object run() {
                    JTableImplClass.this.checkRowColBounds(cell.getRow(), cell.getCol());
                    return JTableImplClass.this.m_table.getCellRect(cell.getRow(), cell.getCol(), true);
                }
            });
            this.getRobot().click((Object)this.m_table, (Object)rectangle, ClickOptions.create().setClickCount(count).setMouseButton(button));
        } else {
            super.gdClick(count, button);
        }
    }

    private boolean isCellSelection() {
        try {
            this.invokeGetSelectedCell();
        }
        catch (StepExecutionException stepExecutionException) {
            return false;
        }
        return true;
    }

    private boolean isMouseOverCell() {
        try {
            this.invokeGetCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            return false;
        }
        return true;
    }

    private boolean isMouseOnHeader() {
        if (this.m_table.getTableHeader() == null || !this.m_table.getTableHeader().isShowing()) {
            return false;
        }
        JTableHeader header = this.m_table.getTableHeader();
        Point mousePos = this.getRobot().getCurrentMousePosition();
        try {
            Point headerPos = header.getLocationOnScreen();
            Point relativePos = new Point(mousePos.x - headerPos.x, mousePos.y - headerPos.y);
            return header.getBounds().contains(relativePos);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return false;
        }
    }

    public void gdSelectRowByValue(String col, String colOperator, String value, String regexOp, int clickCount, String extendSelection, String searchType, int button) {
        this.gdSelectRowByValue(col, colOperator, value, regexOp, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    public void gdSelectRowByValue(int col, String value, int clickCount, String regexOp, String extendSelection, String searchType) {
        this.gdSelectRowByValue(col, value, regexOp, extendSelection, searchType, clickCount);
    }

    protected void gdSelectRowByValue(String col, String colOperator, final String value, final String regexOp, String extendSelection, final String searchType, ClickOptions co) {
        final int implCol = this.getColumnFromString(col, colOperator);
        Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("selectRowByValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int rowCount = JTableImplClass.this.m_table.getRowCount();
                int i = JTableImplClass.this.getStartingRowIndex(searchType);
                while (i < rowCount) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(i, implCol), value, regexOp)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                String header = JTableImplClass.this.m_table.getColumnName(implCol);
                if (MatchUtil.getInstance().match(header, value, regexOp)) {
                    return new Integer(-1);
                }
                return null;
            }
        });
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String userIdxRow = new Integer(IndexConverter.toUserIndex((int)implRow)).toString();
        String userIdxCol = new Integer(IndexConverter.toUserIndex((int)implCol)).toString();
        this.gdSelectCell(userIdxRow, "equals", userIdxCol, colOperator, co, extendSelection);
    }

    protected void gdSelectRowByValue(int col, final String value, final String regexOp, String extendSelection, final String searchType, int clickCount) {
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("selectRowByValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int rowCount = JTableImplClass.this.m_table.getRowCount();
                int i = JTableImplClass.this.getStartingRowIndex(searchType);
                while (i < rowCount) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(i, implCol), value, regexOp)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return null;
            }
        });
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.gdSelectCell(IndexConverter.toUserIndex((int)implRow), IndexConverter.toUserIndex((int)implCol), clickCount, extendSelection);
    }

    public void gdSelectCellByColValue(String row, String rowOperator, String value, String regex, int clickCount, String extendSelection, String searchType, int button) {
        this.gdSelectCellByColValue(row, rowOperator, value, regex, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    public void gdSelectCellByColValue(int row, String value, String regex, int clickCount, String extendSelection, String searchType) {
        this.gdSelectCellByColValue(row, value, regex, extendSelection, searchType, clickCount);
    }

    protected void gdSelectCellByColValue(String row, String rowOperator, final String value, final String regex, String extendSelection, final String searchType, ClickOptions co) {
        final int implRow = this.getRowFromString(row, rowOperator);
        Integer implCol = implRow == -1 ? (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int k = JTableImplClass.this.getStartingColIndex(searchType);
                while (k < JTableImplClass.this.m_table.getColumnCount()) {
                    String header = JTableImplClass.this.m_table.getColumnName(k);
                    if (MatchUtil.getInstance().match(header, value, regex)) {
                        return new Integer(k);
                    }
                    ++k;
                }
                return null;
            }
        }) : (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = JTableImplClass.this.getStartingColIndex(searchType);
                while (i < JTableImplClass.this.m_table.getColumnCount()) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(implRow, i), value, regex)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return null;
            }
        });
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String usrIdxRowStr = new Integer(IndexConverter.toUserIndex((int)implRow)).toString();
        String usrIdxColStr = new Integer(IndexConverter.toUserIndex((int)implCol)).toString();
        this.gdSelectCell(usrIdxRowStr, rowOperator, usrIdxColStr, "equals", co, extendSelection);
    }

    protected void gdSelectCellByColValue(int row, final String value, final String regex, String extendSelection, final String searchType, int clickCount) {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        Integer implCol = (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = JTableImplClass.this.getStartingColIndex(searchType);
                while (i < JTableImplClass.this.m_table.getColumnCount()) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(implRow, i), value, regex)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return null;
            }
        });
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.gdSelectCell(row, IndexConverter.toUserIndex((int)implCol), clickCount, extendSelection);
    }

    public void gdSelectCellByRowValue(int col, final String value, boolean regex) {
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        Integer implRow = regex ? (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByRowValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = 0;
                while (i < JTableImplClass.this.m_table.getRowCount()) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(i, implCol), value, "matches")) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return null;
            }
        }) : (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByRowValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = 0;
                while (i < JTableImplClass.this.m_table.getRowCount()) {
                    if (MatchUtil.getInstance().match(JTableImplClass.this.getCellText(i, implCol), value, "matches")) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return null;
            }
        });
        if (implRow == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.gdSelectCell(IndexConverter.toUserIndex((int)implRow), col, 1, "no");
    }

    public void gdPopupByIndexPathAtCell(int row, int col, String indexPath) {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selecting row, col: " + row + ", " + col));
        }
        Rectangle rectangle = (Rectangle)this.getEventThreadQueuer().invokeAndWait("selectCell", new IRunnable(){

            public Object run() {
                JTableImplClass.this.checkRowColBounds(implRow, implCol);
                return JTableImplClass.this.m_table.getCellRect(implRow, implCol, true);
            }
        });
        this.gdPopupSelectByIndexPath((int)rectangle.getCenterX(), (int)rectangle.getCenterY(), "Pixel", indexPath);
    }

    public void gdPopupByTextPathAtCell(int row, int col, String textPath) {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selecting row, col: " + row + ", " + col));
        }
        Rectangle rectangle = (Rectangle)this.getEventThreadQueuer().invokeAndWait("selectCell", new IRunnable(){

            public Object run() {
                JTableImplClass.this.checkRowColBounds(implRow, implCol);
                return JTableImplClass.this.m_table.getCellRect(implRow, implCol, true);
            }
        });
        this.gdPopupSelectByTextPath((int)rectangle.getCenterX(), (int)rectangle.getCenterY(), "Pixel", textPath, "equals");
    }

    public void gdPopupByIndexPathAtSelectedCell(String indexPath) {
        Cell cell = this.getSelectedCell();
        int row = IndexConverter.toUserIndex((int)cell.getRow());
        int col = IndexConverter.toUserIndex((int)cell.getCol());
        this.gdPopupByIndexPathAtCell(row, col, indexPath);
    }

    public void gdPopupByTextPathAtSelectedCell(String textPath) {
        Cell cell = this.getSelectedCell();
        int row = IndexConverter.toUserIndex((int)cell.getRow());
        int col = IndexConverter.toUserIndex((int)cell.getCol());
        this.gdPopupByTextPathAtCell(row, col, textPath);
    }

    public String gdReadValue(String variable) {
        return this.getText();
    }

    public String gdReadValue(String variable, String row, String rowOperator, String col, String colOperator) {
        final int implRow = this.getRowFromString(row, rowOperator);
        final int implCol = this.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            this.getEventThreadQueuer().invokeAndWait("gdReadValue", new IRunnable(){

                public Object run() {
                    return JTableImplClass.this.m_table.getColumnName(implCol);
                }
            });
        }
        this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

            public Object run() {
                JTableImplClass.this.checkRowColBounds(implRow, implCol);
                return null;
            }
        });
        this.invokeScrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public String gdReadValue(String variable, int row, int col) {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

            public Object run() {
                JTableImplClass.this.checkRowColBounds(implRow, implCol);
                return null;
            }
        });
        this.invokeScrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public void gdDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void gdDragCell(int mouseButton, String modifier, int row, int col, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectCell(row, col, 0, xPos, xUnits, yPos, yUnits, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCell(String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
            JTableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCell(int row, int col, int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectCell(row, col, 0, xPos, xUnits, yPos, yUnits, "no");
            JTableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectRowByValue(col, colOperator, value, regexOp, 1, "no", searchType, 1);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void gdDragRowByValue(int mouseButton, String modifier, int col, String value, String regexOp, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectRowByValue(col, value, 1, regexOp, "no", searchType);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropRowByValue(int col, String value, String regexOp, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectRowByValue(col, value, regexOp, "no", searchType, 0);
            JTableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropRowByValue(String col, String colOperator, String value, String regexOp, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectRowByValue(col, colOperator, value, regexOp, "no", searchType, ClickOptions.create().setClickCount(0));
            JTableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void gdDragCellByColValue(int mouseButton, String modifier, int row, String value, String regex, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectCellByColValue(row, value, regex, "no", searchType, 0);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCellByColValue(String row, String rowOperator, String value, String regex, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
            JTableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCellByColValue(int row, String value, String regex, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectCellByColValue(row, value, regex, "no", searchType, 0);
            JTableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public String[] getTextArrayFromComponent() {
        String[] componentTextArray;
        TableColumnModel columnModel = this.m_table.getColumnModel();
        if (columnModel == null) {
            componentTextArray = null;
        } else {
            componentTextArray = new String[columnModel.getColumnCount()];
            int i = 0;
            while (i < componentTextArray.length) {
                Object headerValue;
                TableColumn tableColumn = columnModel.getColumn(i);
                componentTextArray[i] = tableColumn == null ? null : ((headerValue = tableColumn.getHeaderValue()) == null ? null : headerValue.toString());
                ++i;
            }
        }
        return componentTextArray;
    }

    private int getColumnFromString(String col, String operator) {
        int column = -2;
        try {
            int usrIdxCol = Integer.parseInt(col);
            if (usrIdxCol == 0) {
                ++usrIdxCol;
            }
            column = IndexConverter.toImplementationIndex((int)usrIdxCol);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (this.m_table.getTableHeader() == null || !this.m_table.getTableHeader().isShowing()) {
                    throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                }
                int i = 0;
                while (i < this.m_table.getColumnCount()) {
                    String header = this.m_table.getColumnName(i);
                    if (MatchUtil.getInstance().match(header, col, operator)) {
                        column = i;
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return column;
    }

    /*
     * Unable to fully structure code
     */
    private int getRowFromString(String row, String operator) {
        block5: {
            rowInt = -2;
            try {
                rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
                if (!(rowInt != -1 || this.m_table.getTableHeader() != null && this.m_table.getTableHeader().isShowing())) {
                    throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                }
                break block5;
            }
            catch (NumberFormatException v0) {
                i = 0;
                ** while (i < this.m_table.getRowCount())
            }
lbl-1000:
            // 1 sources

            {
                cellTxt = this.getCellText(i, 0);
                if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                    return i;
                }
                ++i;
                continue;
            }
        }
        return rowInt;
    }

    protected String getText() {
        Cell selectedCell = this.invokeGetSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public String gdReadValueAtMousePosition(String variable) {
        Cell cellAtMousePosition = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTableImplClass.this.getCellAtMousePosition();
            }
        });
        return this.getCellText(cellAtMousePosition.getRow(), cellAtMousePosition.getCol());
    }

    protected JPopupMenu showPopup(int button) {
        if (this.isMouseOnHeader()) {
            JTableHeaderImplClass headerTester = new JTableHeaderImplClass();
            headerTester.setComponent(this.m_table.getTableHeader());
            return headerTester.showPopup(button);
        }
        return super.showPopup(button);
    }
}

