/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.PropertyControllerLabelProvider;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMLogicNameGUIPropertySource
extends AbstractPropertySource<IComponentNamePO> {
    public static final String P_ELEMENT_DISPLAY_COMPNAME = Messages.OMLogicNameGUIPropertySourceComponentName;
    public static final String P_ELEMENT_DISPLAY_COMPTYPE = Messages.OMLogicNameGUIPropertySourceCompType;
    public static final String P_ELEMENT_DISPLAY_PARENTPROJECT = Messages.OMLogicNameGUIPropertySourceParentProject;
    public static final String P_COMPONENT_CAT = Messages.OMLogicNameGUIPropertySourceComponent;

    public OMLogicNameGUIPropertySource(IComponentNamePO compName) {
        super(compName);
        this.initPropDescriptor();
    }

    protected void initPropDescriptor() {
        this.clearPropertyDescriptors();
        JBPropertyDescriptor propDes = null;
        propDes = new JBPropertyDescriptor(new ComponentNameController(), P_ELEMENT_DISPLAY_COMPNAME);
        propDes.setCategory(P_COMPONENT_CAT);
        propDes.setLabelProvider((ILabelProvider)new PropertyControllerLabelProvider());
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ComponentTypeController(), P_ELEMENT_DISPLAY_COMPTYPE);
        propDes.setCategory(P_COMPONENT_CAT);
        propDes.setLabelProvider((ILabelProvider)new PropertyControllerLabelProvider());
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
        propDes = new JBPropertyDescriptor(new ParentProjectController(), P_ELEMENT_DISPLAY_PARENTPROJECT);
        propDes.setCategory(P_COMPONENT_CAT);
        propDes.setLabelProvider((ILabelProvider)new PropertyControllerLabelProvider());
        this.addPropertyDescriptor((IPropertyDescriptor)propDes);
    }

    public boolean isPropertySet(Object id) {
        boolean isPropSet = false;
        return isPropSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentNameController
    extends AbstractPropertySource.AbstractPropertyController {
        private ComponentNameController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            IComponentNamePO compName = (IComponentNamePO)OMLogicNameGUIPropertySource.this.getGuiNode();
            IComponentNameMapper compMapper = Plugin.getActiveCompMapper();
            if (compMapper != null) {
                compName = compMapper.getCompNameCache().getCompNamePo(compName.getGuid());
            }
            if (compName != null && compName.getName() != null) {
                return compName.getName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return IconConstants.LOGICAL_NAME_IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentTypeController
    extends AbstractPropertySource.AbstractPropertyController {
        private ComponentTypeController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            IComponentNamePO compName = (IComponentNamePO)OMLogicNameGUIPropertySource.this.getGuiNode();
            IComponentNameMapper compMapper = Plugin.getActiveCompMapper();
            if (compMapper != null) {
                compName = compMapper.getCompNameCache().getCompNamePo(compName.getGuid());
            }
            if (compName != null && compName.getComponentType() != null) {
                return CompSystemI18n.getString((String)compName.getComponentType());
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentProjectController
    extends AbstractPropertySource.AbstractPropertyController {
        private ParentProjectController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            IComponentNamePO compName = (IComponentNamePO)OMLogicNameGUIPropertySource.this.getGuiNode();
            Long parentProjectId = compName.getParentProjectId();
            IProjectPO currentProject = GeneralStorage.getInstance().getProject();
            if (currentProject != null) {
                Long currentProjectId = currentProject.getId();
                String parentProjectGuid = null;
                if (parentProjectId == null || parentProjectId.equals(currentProjectId)) {
                    parentProjectGuid = currentProject.getGuid();
                } else {
                    try {
                        parentProjectGuid = ProjectPM.getGuidOfProjectId((Long)compName.getParentProjectId());
                    }
                    catch (JBException jBException) {}
                }
                if (parentProjectGuid != null) {
                    return ProjectNameBP.getInstance().getName(parentProjectGuid);
                }
            }
            return Messages.OMLogicNameGUIPropertySourceUnknownParentProject;
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }
}

