/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import org.h2.compress.Compressor;

public class CompressLZF
implements Compressor {
    private static final int HASH_SIZE = 16384;
    private static final int[] EMPTY = new int[16384];
    private static final int MAX_LITERAL = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private int[] cachedHashTable;

    public void setOptions(String string) {
    }

    public int getAlgorithm() {
        return 1;
    }

    private int first(byte[] byArray, int n) {
        return (byArray[n] << 8) + (byArray[n + 1] & 0xFF);
    }

    private int next(int n, byte[] byArray, int n2) {
        return (n << 8) + (byArray[n2 + 2] & 0xFF);
    }

    private int hash(int n) {
        return n * 184117 >> 9 & 0x3FFF;
    }

    public int compress(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        } else {
            System.arraycopy(EMPTY, 0, this.cachedHashTable, 0, 16384);
        }
        int[] nArray = this.cachedHashTable;
        int n4 = 0;
        int n5 = this.first(byArray, n3);
        while (true) {
            if (n3 < n - 4) {
                n5 = this.next(n5, byArray, n3);
                int n6 = this.hash(n5);
                int n7 = nArray[n6];
                nArray[n6] = n3;
                n6 = n3 - n7 - 1;
                if (n6 < 8192 && n7 > 0 && byArray[n7 + 2] == byArray[n3 + 2] && byArray[n7 + 1] == byArray[n3 + 1] && byArray[n7] == byArray[n3]) {
                    int n8;
                    int n9 = n - n3 - 2;
                    n9 = n9 > 264 ? 264 : n9;
                    for (n8 = 3; n8 < n9 && byArray[n7 + n8] == byArray[n3 + n8]; ++n8) {
                    }
                    n8 -= 2;
                    if (n4 != 0) {
                        byArray2[n2++] = (byte)(n4 - 1);
                        n4 = -n4;
                        do {
                            byArray2[n2++] = byArray[n3 + n4++];
                        } while (n4 != 0);
                    }
                    if (n8 < 7) {
                        byArray2[n2++] = (byte)((n6 >> 8) + (n8 << 5));
                    } else {
                        byArray2[n2++] = (byte)((n6 >> 8) + 224);
                        byArray2[n2++] = (byte)(n8 - 7);
                    }
                    byArray2[n2++] = (byte)n6;
                    n5 = this.first(byArray, n3 += n8);
                    n5 = this.next(n5, byArray, n3);
                    nArray[this.hash((int)n5)] = n3++;
                    n5 = this.next(n5, byArray, n3);
                    nArray[this.hash((int)n5)] = n3++;
                    continue;
                }
            } else if (n3 == n) break;
            ++n3;
            if (++n4 != 32) continue;
            byArray2[n2++] = (byte)(n4 - 1);
            n4 = -n4;
            do {
                byArray2[n2++] = byArray[n3 + n4++];
            } while (n4 != 0);
        }
        if (n4 != 0) {
            byArray2[n2++] = (byte)(n4 - 1);
            n4 = -n4;
            do {
                byArray2[n2++] = byArray[n3 + n4++];
            } while (n4 != 0);
        }
        return n2;
    }

    public void expand(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        do {
            int n5;
            if ((n5 = byArray[n++] & 0xFF) < 32) {
                n5 += n;
                do {
                    byArray2[n3++] = byArray[n];
                } while (n++ < n5);
                continue;
            }
            int n6 = n5 >> 5;
            n5 = -((n5 & 0x1F) << 8) - 1;
            if (n6 == 7) {
                n6 += byArray[n++] & 0xFF;
            }
            int n7 = n++;
            n6 += n3 + 2;
            byArray2[n3] = byArray2[n3++ + (n5 -= byArray[n7] & 0xFF)];
            byArray2[n3] = byArray2[n3++ + n5];
            while (n3 < n6 - 8) {
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
                byArray2[n3] = byArray2[n3++ + n5];
            }
            while (n3 < n6) {
                byArray2[n3] = byArray2[n3++ + n5];
            }
        } while (n3 < n4);
    }
}

