/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.IOException;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.IStartAut;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.StartAUTServerMessage;
import org.eclipse.jubula.communication.message.StartAUTServerStateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAUTServerCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(StartAUTServerCommand.class);
    private StartAUTServerMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        try {
            this.m_message = (StartAUTServerMessage)message;
        }
        catch (ClassCastException cce) {
            if (log.isErrorEnabled()) {
                log.error("Cannot convert from " + message.getClass().toString() + " to " + this.m_message.getClass().toString(), (Throwable)cce);
            }
            throw cce;
        }
    }

    public Message execute() {
        log.debug("execute() called");
        try {
            this.m_message.getAutConfiguration().put("LOCALE", this.m_message.getLocale());
            this.m_message.getAutConfiguration().put("NAME_TECHNICAL_COMPONENTS", this.m_message.isGenerateNames());
            AutStarter.getInstance().getAgent().setStartAutMessage(this.m_message);
            String autToolkit = this.m_message.getAutToolKit();
            String toolkitName = autToolkit.substring(autToolkit.lastIndexOf(46) + 1, autToolkit.lastIndexOf("ToolkitPlugin"));
            String className = "org.eclipse.jubula.autagent.commands.Start" + toolkitName + "AutServerCommand";
            Class<?> autServerClass = Class.forName(className);
            IStartAut autStarter = (IStartAut)autServerClass.newInstance();
            return autStarter.startAut(this.m_message.getAutConfiguration());
        }
        catch (IllegalArgumentException iae) {
            log.error("An error occured: ", (Throwable)iae);
            return new StartAUTServerStateMessage(2, iae.getMessage());
        }
        catch (NullPointerException npe) {
            log.error("An error occured: ", (Throwable)npe);
            return new StartAUTServerStateMessage(4, npe.getMessage());
        }
        catch (SecurityException se) {
            log.error("security violation", (Throwable)se);
            return new StartAUTServerStateMessage(5, "security violation:" + se.getMessage());
        }
        catch (IOException ioe) {
            log.error("could not start AUTServer", (Throwable)ioe);
            return new StartAUTServerStateMessage(3, ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            log.error("could not find class for AUTServer", (Throwable)cnfe);
            return new StartAUTServerStateMessage(12, cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            log.error("could not instantiate class for AUTServer", (Throwable)ie);
            return new StartAUTServerStateMessage(12, ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            log.error("could not instantiate class for AUTServer", (Throwable)iae);
            return new StartAUTServerStateMessage(12, iae.getMessage());
        }
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + "timeout() called when it shouldn't (no response)");
    }
}

