/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPolygon;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;
import org.apache.poi.util.StringUtil;

public final class HSSFPatriarch
implements HSSFShapeContainer {
    List shapes = new ArrayList();
    HSSFSheet sheet;
    int x1 = 0;
    int y1 = 0;
    int x2 = 1023;
    int y2 = 255;
    private EscherAggregate boundAggregate;

    HSSFPatriarch(HSSFSheet sheet, EscherAggregate boundAggregate) {
        this.boundAggregate = boundAggregate;
        this.sheet = sheet;
    }

    public HSSFShapeGroup createGroup(HSSFClientAnchor anchor) {
        HSSFShapeGroup group = new HSSFShapeGroup(null, anchor);
        group.anchor = anchor;
        this.shapes.add(group);
        return group;
    }

    public HSSFSimpleShape createSimpleShape(HSSFClientAnchor anchor) {
        HSSFSimpleShape shape = new HSSFSimpleShape(null, anchor);
        shape.anchor = anchor;
        this.shapes.add(shape);
        return shape;
    }

    public HSSFPicture createPicture(HSSFClientAnchor anchor, int pictureIndex) {
        HSSFPicture shape = new HSSFPicture(null, anchor);
        shape.setPictureIndex(pictureIndex);
        shape.anchor = anchor;
        shape.patriarch = this;
        this.shapes.add(shape);
        return shape;
    }

    public HSSFPolygon createPolygon(HSSFClientAnchor anchor) {
        HSSFPolygon shape = new HSSFPolygon(null, anchor);
        shape.anchor = anchor;
        this.shapes.add(shape);
        return shape;
    }

    public HSSFTextbox createTextbox(HSSFClientAnchor anchor) {
        HSSFTextbox shape = new HSSFTextbox(null, anchor);
        shape.anchor = anchor;
        this.shapes.add(shape);
        return shape;
    }

    public HSSFComment createComment(HSSFAnchor anchor) {
        HSSFComment shape = new HSSFComment(null, anchor);
        shape.anchor = anchor;
        this.shapes.add(shape);
        return shape;
    }

    public List getChildren() {
        return this.shapes;
    }

    public int countOfAllChildren() {
        int count = this.shapes.size();
        for (HSSFShape shape : this.shapes) {
            count += shape.countOfAllChildren();
        }
        return count;
    }

    public void setCoordinates(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public boolean containsChart() {
        EscherOptRecord optRecord = (EscherOptRecord)this.boundAggregate.findFirstWithId((short)-4085);
        if (optRecord == null) {
            return false;
        }
        for (EscherProperty prop : optRecord.getEscherProperties()) {
            EscherComplexProperty cp;
            String str;
            if (prop.getPropertyNumber() != 896 || !prop.isComplex() || !(str = StringUtil.getFromUnicodeLE((cp = (EscherComplexProperty)prop).getComplexData())).equals("Chart 1\u0000")) continue;
            return true;
        }
        return false;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    protected EscherAggregate _getBoundAggregate() {
        return this.boundAggregate;
    }
}

