/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.UnknownMessageException;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.communication.message.ActivateApplicationMessage;
import org.eclipse.jubula.communication.message.CAPTestMessage;
import org.eclipse.jubula.communication.message.MessageCap;
import org.eclipse.jubula.communication.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MessageFactory.class);
    private static Map<String, String> toolkitToActivationMessageClassName = new HashMap<String, String>();
    private static Map<String, String> toolkitToTestMessageClassName;

    static {
        toolkitToActivationMessageClassName.put("com.bredexsw.guidancer.SwtToolkitPlugin", "org.eclipse.jubula.communication.message.swt.ActivateSwtApplicationMessage");
        toolkitToActivationMessageClassName.put("com.bredexsw.guidancer.RcpToolkitPlugin", toolkitToActivationMessageClassName.get("com.bredexsw.guidancer.SwtToolkitPlugin"));
        toolkitToActivationMessageClassName.put("com.bredexsw.guidancer.SwingToolkitPlugin", "org.eclipse.jubula.communication.message.swing.ActivateSwingApplicationMessage");
        toolkitToActivationMessageClassName.put("ui.toolkit.DotnetToolkitPlugin", "org.eclipse.jubula.communication.message.dotnet.ActivateDotNetApplicationMessage");
        toolkitToTestMessageClassName = new HashMap<String, String>();
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.SwtToolkitPlugin", "org.eclipse.jubula.communication.message.swt.CAPSwtTestMessage");
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.RcpToolkitPlugin", toolkitToTestMessageClassName.get("com.bredexsw.guidancer.SwtToolkitPlugin"));
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.SwingToolkitPlugin", "org.eclipse.jubula.communication.message.swing.CAPSwingTestMessage");
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.HtmlToolkitPlugin", "org.eclipse.jubula.communication.message.html.CAPHtmlTestMessage");
        toolkitToTestMessageClassName.put("ui.toolkit.aria.RapToolkitPlugin", "org.eclipse.jubula.communication.message.html.CAPHtmlTestMessage");
        toolkitToTestMessageClassName.put("ui.toolkit.DotnetToolkitPlugin", "org.eclipse.jubula.communication.message.dotnet.CAPDotNetTestMessage");
    }

    private MessageFactory() {
    }

    public static ActivateApplicationMessage getActivateApplicationMessage() throws UnknownMessageException {
        String autToolKit = MessageFactory.getAutToolkit();
        String messageClassName = "";
        try {
            messageClassName = toolkitToActivationMessageClassName.get(autToolKit);
            if (messageClassName != null) {
                Class<?> messageClass = Class.forName(messageClassName, false, ActivateApplicationMessage.class.getClassLoader());
                if (!ActivateApplicationMessage.class.isAssignableFrom(messageClass)) {
                    throw new UnknownMessageException(String.valueOf(messageClass.getName()) + Messages.IsNotAssignableTo + " " + ActivateApplicationMessage.class.getName(), MessageIDs.E_MESSAGE_NOT_ASSIGNABLE);
                }
                ActivateApplicationMessage result = (ActivateApplicationMessage)messageClass.newInstance();
                return result;
            }
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + Messages.NoAUTActivationMessageClassFoundForToolkit + " " + autToolKit, MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (ExceptionInInitializerError eiie) {
            LOG.error("An error occured: ", (Throwable)eiie);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + eiie.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (LinkageError le) {
            LOG.error("An error occured: ", (Throwable)le);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + le.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("An error occured: ", (Throwable)cnfe);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + cnfe.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (InstantiationException ie) {
            LOG.error("An error occured: ", (Throwable)ie);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + ie.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (IllegalAccessException iae) {
            LOG.error("An error occured: ", (Throwable)iae);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + iae.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
    }

    private static String getAutToolkit() {
        String autToolKit = "";
        IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
        if (connectedAut != null) {
            autToolKit = connectedAut.getToolkit();
        }
        return autToolKit;
    }

    public static CAPTestMessage getCAPTestMessage(MessageCap messageCap) throws UnknownMessageException {
        String autToolKit = MessageFactory.getAutToolkit();
        try {
            if ("".equals(autToolKit) && !AUTConnection.getInstance().isConnected()) {
                throw new UnknownMessageException(Messages.CreatingMessageSharedInstanceFailed, MessageIDs.E_MESSAGE_NOT_CREATED);
            }
        }
        catch (ConnectionException connectionException) {
            throw new UnknownMessageException(Messages.CreatingMessageSharedInstanceFailed, MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        String messageClassName = "null";
        try {
            messageClassName = toolkitToTestMessageClassName.get(autToolKit);
            if (messageClassName != null) {
                Class<?> messageClass = Class.forName(messageClassName, false, CAPTestMessage.class.getClassLoader());
                if (!CAPTestMessage.class.isAssignableFrom(messageClass)) {
                    throw new UnknownMessageException(String.valueOf(messageClass.getName()) + Messages.IsNotAssignableTo + " " + CAPTestMessage.class.getName(), MessageIDs.E_MESSAGE_NOT_ASSIGNABLE);
                }
                CAPTestMessage result = (CAPTestMessage)messageClass.newInstance();
                result.setMessageCap(messageCap);
                return result;
            }
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + Messages.NoAUTActivationMessageClassFoundForToolkit + autToolKit, MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (ExceptionInInitializerError eiie) {
            MessageFactory.throwUnknownMessageException(messageClassName, eiie);
        }
        catch (LinkageError le) {
            MessageFactory.throwUnknownMessageException(messageClassName, le);
        }
        catch (ClassNotFoundException cnfe) {
            MessageFactory.throwUnknownMessageException(messageClassName, cnfe);
        }
        catch (InstantiationException ie) {
            MessageFactory.throwUnknownMessageException(messageClassName, ie);
        }
        catch (IllegalAccessException iae) {
            MessageFactory.throwUnknownMessageException(messageClassName, iae);
        }
        return null;
    }

    private static void throwUnknownMessageException(String messageClassName, Throwable nestedException) throws UnknownMessageException {
        LOG.error("An error occured: ", nestedException);
        throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + nestedException.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
    }

    public static SendAUTListOfSupportedComponentsMessage getSendAUTListOfSupportedComponentsMessage() throws UnknownMessageException {
        String autToolKit = MessageFactory.getAutToolkit();
        String messageClassName = "null";
        try {
            if ("com.bredexsw.guidancer.SwtToolkitPlugin".equals(autToolKit) || "com.bredexsw.guidancer.RcpToolkitPlugin".equals(autToolKit)) {
                messageClassName = "org.eclipse.jubula.communication.message.swt.SendSwtAUTListOfSupportedComponentsMessage";
            } else if ("com.bredexsw.guidancer.SwingToolkitPlugin".equals(autToolKit)) {
                messageClassName = "org.eclipse.jubula.communication.message.swing.SendSwingAUTListOfSupportedComponentsMessage";
            } else if ("com.bredexsw.guidancer.HtmlToolkitPlugin".equals(autToolKit) || "ui.toolkit.aria.RapToolkitPlugin".equals(autToolKit)) {
                messageClassName = "org.eclipse.jubula.communication.message.html.SendHtmlAUTListOfSupportedComponentsMessage";
            } else if ("ui.toolkit.DotnetToolkitPlugin".equals(autToolKit)) {
                messageClassName = "org.eclipse.jubula.communication.message.dotnet.SenddotnetAUTListOfSupportedComponentsMessage";
            }
            Class<?> messageClass = Class.forName(messageClassName, false, SendAUTListOfSupportedComponentsMessage.class.getClassLoader());
            if (!SendAUTListOfSupportedComponentsMessage.class.isAssignableFrom(messageClass)) {
                throw new UnknownMessageException(String.valueOf(messageClass.getName()) + Messages.IsNotAssignableTo + " " + SendAUTListOfSupportedComponentsMessage.class.getName(), MessageIDs.E_MESSAGE_NOT_ASSIGNABLE);
            }
            SendAUTListOfSupportedComponentsMessage result = (SendAUTListOfSupportedComponentsMessage)messageClass.newInstance();
            return result;
        }
        catch (ExceptionInInitializerError eiie) {
            LOG.error("An error occured: ", (Throwable)eiie);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + eiie.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (LinkageError le) {
            LOG.error("An error occured: ", (Throwable)le);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + le.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("An error occured: ", (Throwable)cnfe);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + cnfe.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (InstantiationException ie) {
            LOG.error("An error occured: ", (Throwable)ie);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + ie.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (IllegalAccessException iae) {
            LOG.error("An error occured: ", (Throwable)iae);
            throw new UnknownMessageException(String.valueOf(Messages.CreatingAnMessageSharedInstanceFor) + " " + messageClassName + Messages.Failed + ":" + " " + iae.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
        }
    }
}

