/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultTreeTracker
implements IExecStackModificationListener {
    private static Logger log = LoggerFactory.getLogger(ResultTreeTracker.class);
    private TestResultNode m_endNode;
    private TestResultNode m_lastNonCap;
    private int m_eventHierarchy = 0;
    private ExternalTestDataBP m_externalTestDataBP;

    public ResultTreeTracker(TestResultNode root, ExternalTestDataBP externalTestDataBP) {
        this.m_endNode = root;
        this.m_lastNonCap = root;
        this.m_externalTestDataBP = externalTestDataBP;
    }

    public void stackIncremented(INodePO node) {
        if (this.m_lastNonCap.getStatus() == 0) {
            this.m_lastNonCap.setResult(6, null);
        }
        if (Persistor.isPoSubclass(node, IEventExecTestCasePO.class) || this.m_eventHierarchy > 0) {
            ++this.m_eventHierarchy;
        }
        if (this.m_eventHierarchy > 0) {
            int nextIndex = this.m_lastNonCap.getNextChildIndex();
            this.m_lastNonCap = new TestResultNode(node, this.m_lastNonCap, nextIndex);
            this.m_lastNonCap.getParent().updateResultNode(nextIndex, this.m_lastNonCap);
        } else {
            TestResultNode nextNonCap = this.m_lastNonCap.getResultNodeList().get(this.m_lastNonCap.getNextChildIndex());
            while (nextNonCap.getNode() != node) {
                nextNonCap = this.m_lastNonCap.getResultNodeList().get(this.m_lastNonCap.getNextChildIndex());
            }
            this.m_lastNonCap = nextNonCap;
        }
        this.m_endNode = this.m_lastNonCap;
        if (this.m_lastNonCap.getStatus() == 0) {
            this.m_lastNonCap.setResult(6, null);
            if (node instanceof IParamNodePO) {
                this.addParameters((IParamNodePO)node, this.m_lastNonCap);
            }
        }
        if (this.m_lastNonCap.getParent().getStatus() == 0) {
            this.m_lastNonCap.getParent().setResult(6, null);
        }
    }

    public void stackDecremented() {
        if (this.m_eventHierarchy > 0) {
            --this.m_eventHierarchy;
        }
        if (this.m_lastNonCap.getStatus() == 0 || this.m_lastNonCap.getStatus() == 6) {
            this.m_lastNonCap.setResult(1, null);
            if (this.m_endNode.getStatus() == 0 || this.m_endNode.getStatus() == 6) {
                this.m_endNode.setResult(1, null);
            }
        }
        this.m_endNode = this.m_lastNonCap = this.m_lastNonCap.getParent();
    }

    public void nextDataSetIteration() {
        if (this.m_lastNonCap.getStatus() == 0 || this.m_lastNonCap.getStatus() == 6) {
            this.m_lastNonCap.setResult(1, null);
            if (this.m_endNode.getStatus() == 0 || this.m_endNode.getStatus() == 6) {
                this.m_endNode.setResult(1, null);
            }
        }
        int nextIndex = this.m_lastNonCap.getParent().getNextChildIndex();
        if (this.m_eventHierarchy > 0) {
            this.m_lastNonCap = new TestResultNode(this.m_lastNonCap.getNode(), this.m_lastNonCap.getParent(), nextIndex);
            this.m_lastNonCap.getParent().updateResultNode(nextIndex, this.m_lastNonCap);
        } else {
            this.m_lastNonCap = this.m_lastNonCap.getParent().getResultNodeList().get(nextIndex);
        }
        if (this.m_lastNonCap.getStatus() == 0) {
            INodePO node = this.m_lastNonCap.getNode();
            if (node instanceof IParamNodePO) {
                this.addParameters((IParamNodePO)node, this.m_lastNonCap);
            }
            this.m_lastNonCap.setResult(6, null);
        }
        if (this.m_lastNonCap.getParent().getStatus() == 0) {
            this.m_lastNonCap.getParent().setResult(6, null);
        }
    }

    public void nextCap(ICapPO cap) {
        int nextIndex = this.m_lastNonCap.getNextChildIndex();
        if (this.m_eventHierarchy > 0) {
            this.m_endNode = new TestResultNode(cap, this.m_lastNonCap);
            this.m_endNode.getParent().updateResultNode(nextIndex, this.m_endNode);
            this.m_endNode.setActionName(CompSystemI18n.getString((String)cap.getActionName()));
            this.m_endNode.setComponentType(CompSystemI18n.getString((String)cap.getComponentType()));
        } else {
            this.m_endNode = this.m_lastNonCap.getResultNodeList().get(nextIndex);
            while (this.m_endNode.getNode() != cap) {
                nextIndex = this.m_lastNonCap.getNextChildIndex();
                this.m_endNode = this.m_lastNonCap.getResultNodeList().get(nextIndex);
            }
        }
        if (this.m_endNode.getStatus() == 0) {
            this.m_endNode.setResult(6, null);
        }
        this.addParameters(cap, this.m_endNode);
    }

    private void addParameters(IParamNodePO paramNode, TestResultNode resultNode) {
        List<IParamDescriptionPO> parameterList = paramNode.getParameterList();
        for (IParamDescriptionPO desc : parameterList) {
            List<ExecObject> execList = TestExecution.getInstance().getTrav().getExecStackAsList();
            ExecObject currentExecObj = execList.get(execList.size() - 1);
            resultNode.addParameter(new TestResultParameter(desc.getName(), CompSystemI18n.getString((String)desc.getType()), currentExecObj.getParameterValue(desc.getUniqueId())));
        }
    }

    private void addParameters(ICapPO testStep, TestResultNode resultNode) {
        List<IParamDescriptionPO> parameterList = testStep.getParameterList();
        String value = null;
        for (IParamDescriptionPO desc : parameterList) {
            IParameterInterfacePO referencedDataCube;
            ITDManager tdManager = null;
            try {
                tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(testStep);
            }
            catch (JBException e) {
                log.error(String.valueOf(Messages.TestDataNotAvailable) + ".", (Throwable)e);
            }
            TestExecution te = TestExecution.getInstance();
            ArrayList<ExecObject> stackList = new ArrayList<ExecObject>(te.getTrav().getExecStackAsList());
            int dataSetIndex = 0;
            if (tdManager.findColumnForParam(desc.getUniqueId()) == -1 && (referencedDataCube = testStep.getReferencedDataCube()) != null) {
                desc = referencedDataCube.getParameterForName(desc.getName());
            }
            ITestDataPO date = tdManager.getCell(dataSetIndex, desc);
            ModelParamValueConverter conv = new ModelParamValueConverter(date.getValue(te.getLocale()), (IParameterInterfacePO)testStep, te.getLocale(), desc);
            try {
                value = conv.getExecutionString(stackList, te.getLocale());
            }
            catch (InvalidDataException e) {
                log.error(e.getMessage());
                value = MessageIDs.getMessageObject((Integer)e.getErrorId()).getMessage(new Object[0]);
            }
            resultNode.addParameter(new TestResultParameter(desc.getUniqueId(), desc.getType(), StringUtils.defaultString((String)value)));
        }
    }

    public TestResultNode getEndNode() {
        return this.m_endNode;
    }

    public void retryCap(ICapPO cap) {
        int nextIndex = this.m_lastNonCap.getNextChildIndex();
        this.m_endNode = new TestResultNode(cap, this.m_lastNonCap, nextIndex);
        if (this.m_endNode.getStatus() == 0) {
            this.m_endNode.setResult(6, null);
        }
        this.m_endNode.getParent().updateResultNode(nextIndex, this.m_endNode);
        this.addParameters(cap, this.m_endNode);
    }
}

