/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.errorhandling.IDatabaseVersionErrorHandler;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.DBVersionPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.AmbiguousDatabaseVersionException;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.DatabaseVersionConflictException;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDatabaseConfException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.progress.JobChangeListener;
import org.eclipse.jubula.client.core.utils.DatabaseStateDispatcher;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.jarutils.IVersion;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistor {
    private static final String DEFAULT_PU_NAME = "org.eclipse.jubula";
    private static final Thread SHUTDOWN_HOOK = new Thread("Close Session Factory"){

        public void run() {
            Persistor hib = Persistor.instance();
            if (hib != null) {
                try {
                    if (LockManager.isRunning()) {
                        LockManager.instance().dispose();
                    }
                }
                catch (Throwable t) {
                    log.warn(String.valueOf(Messages.CouldNotShutDownLockManager) + ".", t);
                }
                try {
                    hib.dispose();
                }
                catch (Throwable t) {
                    log.warn(String.valueOf(Messages.CouldNotShutDownDatabaseConnectionPool) + ".", t);
                }
            }
        }
    };
    private static Logger log;
    private static Persistor instance;
    private static String user;
    private static String pw;
    private static String dburl;
    private static DatabaseConnectionInfo dbConnectionInfo;
    private EntityManagerFactory m_sf;
    private List<EntityManager> m_sessions = new ArrayList<EntityManager>();
    private boolean m_newDbSchemeInstalled = false;
    private AtomicInteger m_dbLockCnt = new AtomicInteger();

    static {
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
        log = LoggerFactory.getLogger(Persistor.class);
        instance = null;
        user = null;
        pw = null;
        dburl = null;
        dbConnectionInfo = null;
    }

    private Persistor(String userName, String pwd, String url, IProgressMonitor monitor) throws JBException, DatabaseVersionConflictException {
        try {
            this.buildSessionFactoryWithLoginData(userName, pwd, url, monitor);
        }
        catch (PersistenceException e) {
            String msg = Messages.CantSetupPersistence;
            log.error(msg, (Throwable)e);
            throw new JBFatalException(msg, MessageIDs.E_PERSISTENCE_CANT_SETUP);
        }
        catch (DatabaseVersionConflictException dbvce) {
            this.dispose();
            throw dbvce;
        }
    }

    public static synchronized boolean init() throws JBFatalException {
        if (instance == null) {
            return Persistor.connectToDB();
        }
        return true;
    }

    private static boolean connectToDB() {
        Job connectToDBJob = new Job(Messages.ConnectingToDatabaseJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Persistor.instance(user, pw, dburl, monitor);
                    user = null;
                    pw = null;
                    if (instance.m_newDbSchemeInstalled) {
                        instance.m_newDbSchemeInstalled = false;
                        DatabaseStateDispatcher.notifyListener(new DatabaseStateEvent(DatabaseStateEvent.DatabaseState.DB_SCHEME_CREATED));
                    }
                    return Status.OK_STATUS;
                }
                catch (PMDatabaseConfException e) {
                    if (e.getErrorId().equals(MessageIDs.E_INVALID_DB_VERSION)) {
                    } else if (e.getErrorId().equals(MessageIDs.E_NOT_CHECKABLE_DB_VERSION)) {
                    } else if (e.getErrorId().equals(MessageIDs.E_NO_DB_SCHEME)) {
                    } else if (e.getErrorId().equals(MessageIDs.E_ERROR_IN_SCHEMA_CONFIG)) {
                    }
                    return new Status(4, "org.eclipse.jubula.client.core", "", (Throwable)((Object)e));
                }
                catch (JBException e) {
                    if (e.getErrorId().equals(MessageIDs.E_NO_DB_CONNECTION)) {
                    }
                    if (e.getErrorId().equals(MessageIDs.E_DB_IN_USE)) {
                    }
                    return new Status(4, "org.eclipse.jubula.client.core", "", (Throwable)e);
                }
            }
        };
        final AtomicBoolean connectionGained = new AtomicBoolean();
        connectToDBJob.addJobChangeListener((IJobChangeListener)new JobChangeListener(){

            public void done(IJobChangeEvent event) {
                connectionGained.set(event.getResult().isOK());
            }
        });
        connectToDBJob.setUser(true);
        connectToDBJob.schedule();
        try {
            connectToDBJob.join();
        }
        catch (InterruptedException e) {
            log.error("An error occured: ", (Throwable)e);
            connectionGained.set(false);
        }
        return connectionGained.get();
    }

    private void buildSessionFactoryWithLoginData(String userName, String pwd, String url, IProgressMonitor monitor) throws PersistenceException, PMDatabaseConfException, JBException, DatabaseVersionConflictException {
        block9: {
            if (userName != null) {
                monitor.beginTask(NLS.bind((String)Messages.ConnectingToDatabase, (Object[])new Object[]{userName, dbConnectionInfo.getConnectionUrl()}), -1);
                this.m_sf = Persistor.createEntityManagerFactory(dbConnectionInfo, userName, pwd, url);
                EntityManager em = null;
                try {
                    try {
                        em = this.m_sf.createEntityManager();
                        try {
                            this.validateDBVersion(em);
                            monitor.subTask(Messages.DatabaseConnectionEstablished);
                            break block9;
                        }
                        catch (AmbiguousDatabaseVersionException ambiguousDatabaseVersionException) {
                            throw new PMDatabaseConfException(String.valueOf(Messages.DBVersionProblem) + ".", MessageIDs.E_NOT_CHECKABLE_DB_VERSION);
                        }
                    }
                    catch (PersistenceException e) {
                        log.error(Messages.NoOrWrongUsernameOrPassword, (Throwable)e);
                        throw new JBException(e.getMessage(), MessageIDs.E_NO_DB_CONNECTION);
                    }
                }
                finally {
                    if (em != null) {
                        em.close();
                    }
                }
            }
            throw new JBException(Messages.DatabaseProfileDoesNotExist, MessageIDs.E_DB_PROFILE_NOT_EXIST);
        }
    }

    private static boolean handleDatabaseVersionConflict(DatabaseVersionConflictException dvce) {
        IConfigurationElement[] config;
        ArrayList<IDatabaseVersionErrorHandler> errorHandlers = new ArrayList<IDatabaseVersionErrorHandler>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jubula.client.core.databaseVersionErrorHandler");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof IDatabaseVersionErrorHandler) {
                    errorHandlers.add((IDatabaseVersionErrorHandler)o);
                }
            }
            catch (CoreException ce) {
                log.warn(String.valueOf(Messages.ErrorOccurredInitializingDatabaseVersion) + ".", (Throwable)ce);
            }
            ++n2;
        }
        if (errorHandlers.isEmpty()) {
            return false;
        }
        for (final IDatabaseVersionErrorHandler handler : errorHandlers) {
            if (handler.getMinimumDatabaseMajorVersionNumber() > dvce.getDatabaseMajorVersion()) continue;
            final AtomicBoolean isHandled = new AtomicBoolean(false);
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable t) {
                    log.warn(String.valueOf(Messages.ErrorOccurredResolvingDatabaseVersionConflict) + ".", t);
                }

                public void run() throws Exception {
                    isHandled.set(handler.handleDatabaseError());
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            if (!isHandled.get()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateDBVersion(EntityManager session) throws PMDatabaseConfException, JBException, DatabaseVersionConflictException, AmbiguousDatabaseVersionException {
        List hits = null;
        try {
            hits = session.createQuery("select version from DBVersionPO as version").getResultList();
        }
        catch (RuntimeException e) {
            String msg;
            SQLException se;
            Throwable cause = ExceptionUtils.getCause((Throwable)e);
            if (cause instanceof SQLException && (se = (SQLException)cause).getErrorCode() == 17002) {
                String msg2 = String.valueOf(Messages.ProblemWithDatabaseSchemeConf) + ".";
                log.error(msg2);
                throw new PMDatabaseConfException(msg2, MessageIDs.E_ERROR_IN_SCHEMA_CONFIG);
            }
            this.m_newDbSchemeInstalled = Persistor.installDbScheme(session.getEntityManagerFactory());
            try {
                hits = session.createQuery("select version from DBVersionPO as version").getResultList();
            }
            catch (PersistenceException persistenceException) {
                msg = String.valueOf(Messages.ProblemWithInstallingDBScheme) + ".";
                log.error(msg);
                throw new PMDatabaseConfException(msg, MessageIDs.E_NO_DB_SCHEME);
            }
            catch (DatabaseException databaseException) {
                msg = String.valueOf(Messages.ProblemWithInstallingDBScheme) + ".";
                log.error(msg);
                throw new PMDatabaseConfException(msg, MessageIDs.E_NO_DB_SCHEME);
            }
        }
        if (!hits.isEmpty() && hits.size() == 1) {
            DBVersionPO dbVersion = (DBVersionPO)hits.get(0);
            Integer dbMaj = dbVersion.getMajorVersion();
            Integer dbMin = dbVersion.getMinorVersion();
            if (!dbMaj.equals(IVersion.JB_DB_MAJOR_VERSION)) {
                log.error(String.valueOf(Messages.DBVersion) + ":" + " " + Messages.MajorVersionInvalid);
                throw new DatabaseVersionConflictException(dbMaj, dbMin);
            }
            if (dbMin.equals(IVersion.JB_DB_MINOR_VERSION)) {
                log.info(String.valueOf(Messages.DBVersion) + ":" + " " + Messages.OK);
                return;
            }
            log.error(String.valueOf(Messages.DBVersion) + ":" + " " + Messages.MinorVersionInvalid);
            throw new DatabaseVersionConflictException(dbMaj, dbMin);
        }
        log.error(String.valueOf(Messages.DBVersion) + ":" + " " + Messages.DBEntryMissingAmbiguous);
        throw new AmbiguousDatabaseVersionException(hits);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean installDbScheme(EntityManagerFactory entityManagerFactory) throws PMDatabaseConfException, JBException {
        EntityManager em = null;
        try {
            em = entityManagerFactory.createEntityManager();
            SchemaManager schemaManager = new SchemaManager((DatabaseSessionImpl)em.unwrap(ServerSession.class));
            schemaManager.replaceDefaultTables();
            Persistor.createOrUpdateDBVersion(em);
            Persistor.createOrUpdateDBGuard(em);
            if (em == null) return true;
        }
        catch (PersistenceException e) {
            try {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (!(rootCause instanceof SQLException)) {
                    String msg = String.valueOf(Messages.ProblemInstallingDBScheme) + ".";
                    log.error(msg);
                    throw new PMDatabaseConfException(msg, MessageIDs.E_NO_DB_SCHEME);
                }
                if ("08001".equals(((SQLException)rootCause).getSQLState())) {
                    log.error(Messages.TheDBAllreadyUseAnotherProcess, (Throwable)e);
                    throw new JBException(rootCause.getMessage(), MessageIDs.E_DB_IN_USE);
                }
                log.error(Messages.NoOrWrongUsernameOrPassword, (Throwable)e);
                throw new JBException(e.getMessage(), MessageIDs.E_NO_DB_CONNECTION);
            }
            catch (Throwable throwable) {
                if (em == null) throw throwable;
                try {
                    em.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
        try {
            em.close();
            return true;
        }
        catch (Throwable throwable) {}
        return true;
    }

    private static void createOrUpdateDBVersion(EntityManager em) throws PersistenceException {
        EntityTransaction tx = null;
        try {
            tx = em.getTransaction();
            tx.begin();
            try {
                DBVersionPO version = (DBVersionPO)em.createQuery("select version from DBVersionPO as version").getSingleResult();
                version.setMajorVersion(IVersion.JB_DB_MAJOR_VERSION);
                version.setMinorVersion(IVersion.JB_DB_MINOR_VERSION);
                em.merge((Object)version);
            }
            catch (NoResultException noResultException) {
                em.merge((Object)new DBVersionPO(IVersion.JB_DB_MAJOR_VERSION, IVersion.JB_DB_MINOR_VERSION));
            }
            tx.commit();
        }
        catch (PersistenceException pe) {
            if (tx != null) {
                tx.rollback();
            }
            throw pe;
        }
    }

    private static void createOrUpdateDBGuard(EntityManager em) throws PersistenceException {
        EntityTransaction tx = null;
        try {
            tx = em.getTransaction();
            tx.begin();
            try {
                em.createQuery("select guard from DbGuardPO as guard").getSingleResult();
            }
            catch (NoResultException noResultException) {
                LockManager.initDbGuard(em);
            }
            tx.commit();
        }
        catch (PersistenceException pe) {
            if (tx != null) {
                tx.rollback();
            }
            throw pe;
        }
    }

    public static Persistor instance() {
        return instance;
    }

    private static Persistor instance(String userName, String pwd, String url, IProgressMonitor monitor) throws JBFatalException, JBException {
        if (instance == null) {
            try {
                instance = new Persistor(userName, pwd, url, monitor);
                DatabaseStateDispatcher.notifyListener(new DatabaseStateEvent(DatabaseStateEvent.DatabaseState.DB_LOGIN_SUCCEEDED));
            }
            catch (DatabaseVersionConflictException e) {
                if (IVersion.JB_DB_MAJOR_VERSION > e.getDatabaseMajorVersion() || IVersion.JB_DB_MAJOR_VERSION.equals(e.getDatabaseMajorVersion()) && IVersion.JB_DB_MINOR_VERSION > e.getDatabaseMinorVersion()) {
                    if (!Persistor.handleDatabaseVersionConflict(e)) {
                        throw new PMDatabaseConfException(String.valueOf(Messages.DBVersionProblem) + ".", MessageIDs.E_INVALID_DB_VERSION);
                    }
                }
                throw new PMDatabaseConfException(String.valueOf(Messages.DBVersionProblem) + ".", MessageIDs.E_INVALID_DB_VERSION);
            }
            LockManager.instance().startKeepAlive();
        }
        return instance;
    }

    public EntityManager openSession() throws JBFatalAbortException {
        try {
            EntityManager em = this.m_sf.createEntityManager();
            this.m_sessions.add(em);
            return em;
        }
        catch (PersistenceException e) {
            String msg = Messages.PersistenceErrorCreateEntityManagerFailed;
            log.error(msg, (Throwable)e);
            throw new JBFatalAbortException(msg, (Throwable)e, MessageIDs.E_SESSION_FAILED);
        }
    }

    public void rollbackTransaction(EntityManager s, EntityTransaction tx) throws PMException {
        Validate.notNull((Object)s);
        if (tx != null) {
            Validate.isTrue((boolean)tx.equals(s.getTransaction()), (String)"Session and Transaction don't match");
            try {
                try {
                    tx.rollback();
                }
                catch (PersistenceException e) {
                    log.error(Messages.RollbackFailed, (Throwable)e);
                    if (s.equals(GeneralStorage.getInstance().getMasterSession())) {
                        GeneralStorage.getInstance().recoverSession();
                    }
                    throw new PMException(Messages.RollbackFailed, MessageIDs.E_DATABASE_GENERAL);
                }
            }
            finally {
                this.removeLocks(s);
            }
        }
    }

    public void flushSession(EntityManager s) throws PMException {
        Validate.notNull((Object)s, (String)"No null value allowed");
        try {
            try {
                s.flush();
            }
            catch (PersistenceException e) {
                log.error(Messages.FlushFailed, (Throwable)e);
                if (s.equals(GeneralStorage.getInstance().getMasterSession())) {
                    GeneralStorage.getInstance().recoverSession();
                }
                throw new PMException(Messages.FlushFailed, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        finally {
            this.removeLocks(s);
        }
    }

    public EntityTransaction getTransaction(EntityManager s) {
        EntityTransaction result = s.getTransaction();
        if (result.isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.JoiningTransaction);
            }
        } else {
            result.begin();
            if (log.isDebugEnabled()) {
                log.debug(Messages.StartingTransaction);
            }
        }
        return result;
    }

    public void commitTransaction(EntityManager s, EntityTransaction tx) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException, ProjectDeletedException {
        Validate.notNull((Object)s);
        Validate.notNull((Object)tx);
        Validate.isTrue((boolean)tx.equals(s.getTransaction()), (String)Messages.SessionAndTransactionDontMatch);
        try {
            try {
                tx.commit();
            }
            catch (PersistenceException e) {
                if (s != null && s.equals(GeneralStorage.getInstance().getMasterSession())) {
                    PersistenceManager.handleDBExceptionForMasterSession(null, e);
                } else {
                    PersistenceManager.handleDBExceptionForAnySession(null, e, s);
                }
                this.removeLocks(s);
            }
        }
        finally {
            this.removeLocks(s);
        }
    }

    private void closeSession(EntityManager s, boolean dropLocks) throws PMException {
        block11: {
            Validate.notNull((Object)s);
            try {
                try {
                    if (!s.isOpen()) break block11;
                    try {
                        EntityTransaction tx = s.getTransaction();
                        if (tx.isActive()) {
                            this.rollbackTransaction(s, tx);
                        }
                    }
                    finally {
                        s.close();
                    }
                }
                catch (PersistenceException e) {
                    log.error(Messages.CloseSessionFailed, (Throwable)e);
                    if (dropLocks) {
                        this.removeLocks(s);
                    }
                    this.m_sessions.remove(s);
                }
            }
            finally {
                if (dropLocks) {
                    this.removeLocks(s);
                }
                this.m_sessions.remove(s);
            }
        }
    }

    public void dropSession(EntityManager s) {
        try {
            if (s != null) {
                this.closeSession(s, true);
            }
        }
        catch (PMException e) {
            log.error(Messages.CouldntDropSsession, (Throwable)((Object)e));
        }
    }

    public void dropSessionWithoutLockRelease(EntityManager s) {
        try {
            if (s != null) {
                this.closeSession(s, false);
            }
        }
        catch (PMException e) {
            log.error(Messages.CouldntDropSsession, (Throwable)((Object)e));
        }
    }

    public void refreshPO(EntityManager s, IPersistentObject po, LockModeType lockMode) throws PMDirtyVersionException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        Validate.notNull((Object)s, (String)Messages.NoNullValueAllowed);
        try {
            s.refresh((Object)po, lockMode);
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForMasterSession(po, e);
        }
    }

    private void removeLocks(EntityManager s) {
        LockManager.instance().unlockPOs(s);
    }

    public void lockPO(EntityManager s, IPersistentObject po) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        if (!LockManager.instance().lockPO(s, po, true)) {
            String poName = po != null ? po.getName() : "";
            long poId = po != null ? po.getId() : -1L;
            throw new PMAlreadyLockedException(po, "PO " + po + " (name=" + poName + "; id=" + poId + ") locked in db.", MessageIDs.E_OBJECT_IN_USE);
        }
    }

    public void lockPOSet(EntityManager sess, Set<? extends IPersistentObject> objectsToLock) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        boolean unlock = true;
        try {
            unlock = !LockManager.instance().lockPOs(sess, objectsToLock, true);
        }
        finally {
            if (unlock) {
                this.removeLocks(sess);
            }
        }
    }

    public void deletePO(EntityManager s, IPersistentObject po) throws PMException, PMAlreadyLockedException, PMDirtyVersionException, ProjectDeletedException, InterruptedException {
        Validate.notNull((Object)s);
        try {
            s.remove((Object)po);
        }
        catch (PersistenceException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw new InterruptedException();
            }
            PersistenceManager.handleDBExceptionForMasterSession(po, e);
        }
    }

    public static void setPw(String pwd) {
        pw = pwd;
    }

    public static void setUrl(String url) {
        dburl = url;
    }

    public static void setUser(String usr) {
        user = usr;
    }

    public static void setDbConnectionName(DatabaseConnectionInfo connectionName) {
        dbConnectionInfo = connectionName;
    }

    public static boolean isPoSubclass(IPersistentObject po, Class compClass) {
        boolean result = po == null || compClass == null ? false : compClass.isAssignableFrom(Persistor.getClass(po));
        return result;
    }

    public static boolean isPoClassSubclass(Class poClass, Class compClass) {
        boolean result = poClass == null || compClass == null ? false : compClass.isAssignableFrom(poClass);
        return result;
    }

    public static Class getClass(Object obj) {
        return obj == null ? null : obj.getClass();
    }

    public String getCurrentDBUser() {
        return Persistor.getFactoryProperty(this.m_sf, "javax.persistence.jdbc.user");
    }

    public String getCurrentDBPw() {
        return Persistor.getFactoryProperty(this.m_sf, "javax.persistence.jdbc.password");
    }

    public String getCurrentDBUrl() {
        return Persistor.getFactoryProperty(this.m_sf, "javax.persistence.jdbc.url");
    }

    private static String getFactoryProperty(EntityManagerFactory factory, String key) {
        if (factory != null && factory.isOpen()) {
            return ObjectUtils.toString(factory.getProperties().get(key));
        }
        return null;
    }

    public static boolean migrateDatabaseStructure() throws JBFatalException, JBException {
        boolean migrationSuccess = false;
        EntityManagerFactory migrationEntityManagerFactory = null;
        try {
            migrationEntityManagerFactory = Persistor.createEntityManagerFactory(dbConnectionInfo, user, pw, dburl);
            migrationSuccess = Persistor.installDbScheme(migrationEntityManagerFactory);
            instance = Persistor.instance(user, pw, dburl, (IProgressMonitor)new NullProgressMonitor());
            Persistor.instance.m_newDbSchemeInstalled = true;
        }
        finally {
            if (migrationEntityManagerFactory != null) {
                migrationEntityManagerFactory.close();
            }
        }
        return migrationSuccess;
    }

    private static EntityManagerFactory createEntityManagerFactory(DatabaseConnectionInfo connectionInfo, String username, String password, String url) {
        Validate.notNull((Object)connectionInfo);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.classloader", Persistor.class.getClassLoader());
        properties.put("javax.persistence.jdbc.driver", connectionInfo.getDriverClassName());
        properties.put("javax.persistence.jdbc.user", username);
        properties.put("javax.persistence.jdbc.password", password);
        properties.put("javax.persistence.jdbc.url", StringUtils.defaultString((String)url, (String)connectionInfo.getConnectionUrl()));
        properties.put("eclipselink.jdbc.batch-writing", connectionInfo.getBatchWriting());
        String batchWritingSize = connectionInfo.getBatchWritingSize();
        if (batchWritingSize != null) {
            properties.put("eclipselink.jdbc.batch-writing.size", batchWritingSize);
        }
        return new PersistenceProvider().createEntityManagerFactory(DEFAULT_PU_NAME, properties);
    }

    public void dispose() {
        if (this.m_sf != null) {
            try {
                for (EntityManager sess : this.m_sessions) {
                    if (!sess.isOpen()) continue;
                    sess.close();
                }
                this.m_sessions.clear();
                this.m_sf.close();
                DatabaseStateDispatcher.notifyListener(new DatabaseStateEvent(DatabaseStateEvent.DatabaseState.DB_LOGOUT_SUCCEEDED));
            }
            catch (Throwable e) {
                log.error(Messages.DisposeOfPersistorFailed, e);
            }
        }
        instance = null;
    }

    public String getCurrentDBDriverClass() {
        return Persistor.getFactoryProperty(this.m_sf, "javax.persistence.jdbc.driver");
    }

    public void lockDB() {
        this.m_dbLockCnt.incrementAndGet();
    }

    public void unlockDB() {
        if (this.m_dbLockCnt.decrementAndGet() < 0) {
            this.m_dbLockCnt.set(0);
        }
    }

    public boolean isDBLocked() {
        return this.m_dbLockCnt.get() > 0;
    }
}

