/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.ILockedObjects;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.views.JBPropertiesView;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBEditorHelper
implements ILockedObjects,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener {
    private EditableState m_editableState = EditableState.NotChecked;
    private boolean m_isDirty = false;
    private boolean m_isActive = false;
    private ActiveListener m_activeListener = null;
    private Clipboard m_clipboard;
    private IJBEditor m_editor;

    public JBEditorHelper(IJBEditor editor) {
        Validate.notNull((Object)editor);
        this.m_editor = editor;
    }

    public EditableState requestEditableState() {
        if (this.getEditSupport() == null) {
            return EditableState.Invalid;
        }
        if (this.m_editableState == EditableState.NotChecked || this.m_editableState == EditableState.Locked) {
            try {
                this.getEditSupport().lockWorkVersion();
                this.m_editableState = EditableState.OK;
            }
            catch (PMAlreadyLockedException e) {
                this.m_editableState = EditableState.Locked;
                PMExceptionHandler.handlePMExceptionForEditor((PMException)((Object)e), this.m_editor);
            }
            catch (PMDirtyVersionException e) {
                this.m_editableState = EditableState.NotChecked;
                PMExceptionHandler.handlePMExceptionForEditor((PMException)((Object)e), this.m_editor);
            }
            catch (PMException e) {
                this.m_editableState = EditableState.Invalid;
                PMExceptionHandler.handlePMExceptionForEditor(e, this.m_editor);
            }
        }
        return this.m_editableState;
    }

    public void resetEditableState() {
        this.m_editableState = EditableState.NotChecked;
    }

    public EditSupport getEditSupport() {
        return this.m_editor.getEditorInput() instanceof PersistableEditorInput ? ((PersistableEditorInput)this.m_editor.getEditorInput()).getEditSupport() : null;
    }

    public void dispose() {
        if (this.m_clipboard != null) {
            this.m_clipboard.dispose();
        }
        if (this.getEditSupport() != null) {
            this.getEditSupport().close();
        }
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this.m_editor);
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        ded.firePartClosed((IWorkbenchPart)this.m_editor);
        if (this.m_editor.getEditorInput() instanceof PersistableEditorInput) {
            ((PersistableEditorInput)this.m_editor.getEditorInput()).dispose();
        }
        if (this.m_activeListener != null) {
            this.m_editor.getSite().getPage().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.m_activeListener);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ILockedObjects.class || adapter == IJBEditor.class) {
            return this;
        }
        if (adapter.equals(IPropertySheetPage.class)) {
            return new JBPropertiesView(true, (IComponentNameMapper)this.getEditSupport().getCompMapper());
        }
        if (adapter.equals(IComponentNameMapper.class)) {
            return this.getEditSupport().getCompMapper();
        }
        return null;
    }

    @Override
    public List<IPersistentObject> getLockedObjects() {
        List result = this.getEditSupport().getLockedObjects();
        return result;
    }

    public static IEditorPart findEditor2LockedObj(IPersistentObject po) {
        IEditorPart[] dirtyEditors;
        IEditorPart[] iEditorPartArray = dirtyEditors = Plugin.getDefault().getDirtyEditors();
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            ILockedObjects lockedPOs = (ILockedObjects)editor.getAdapter(ILockedObjects.class);
            if (lockedPOs != null) {
                List<IPersistentObject> l = lockedPOs.getLockedObjects();
                for (IPersistentObject lpo : l) {
                    if (!lpo.getId().equals(po.getId())) continue;
                    return editor;
                }
            }
            ++n2;
        }
        return null;
    }

    public String getTitleToolTip() {
        return this.m_editor.getPartName();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.m_clipboard = new Clipboard(site.getShell().getDisplay());
        PersistableEditorInput editorInput = (PersistableEditorInput)input.getAdapter(PersistableEditorInput.class);
        if (editorInput == null) {
            String msg = Messages.EditorInitCreateError;
            throw new PartInitException(msg);
        }
        this.resetEditableState();
        this.m_editor.initTextAndInput(site, input);
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        IPersistentObject workVersion = this.getEditSupport().getWorkVersion();
        switch (dataState) {
            case Added: {
                break;
            }
            case Deleted: {
                if (!po.equals(workVersion)) break;
                this.m_editor.getSite().getPage().closeEditor((IEditorPart)this.m_editor, false);
                break;
            }
            case Renamed: {
                if (this.isDirty() || !this.editorContainsPo(po)) break;
                this.handleProjectLoaded();
                break;
            }
            case StructureModified: {
                if (!po.equals(workVersion) || po.getVersion().equals(workVersion.getVersion())) break;
                try {
                    this.m_editor.reOpenEditor(po);
                    break;
                }
                catch (PMException pMException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_REFRESH_FAILED, null, (String[])new String[]{org.eclipse.jubula.client.ui.rcp.i18n.Messages.ErrorMessageEDITOR_CLOSE});
                    this.m_editor.getSite().getPage().closeEditor((IEditorPart)this.m_editor, false);
                }
            }
        }
    }

    public final void handleProjectLoaded() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (!JBEditorHelper.this.isDirty()) {
                    IPersistentObject original = JBEditorHelper.this.getEditSupport().getOriginal();
                    if (original != null) {
                        try {
                            try {
                                Plugin.startLongRunning();
                                JBEditorHelper.this.m_editor.reOpenEditor(original);
                            }
                            catch (PMException pMException) {
                                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_REFRESH_FAILED, null, (String[])new String[]{org.eclipse.jubula.client.ui.rcp.i18n.Messages.ErrorMessageEDITOR_CLOSE});
                                JBEditorHelper.this.m_editor.getSite().getPage().closeEditor((IEditorPart)JBEditorHelper.this.m_editor, false);
                                Plugin.stopLongRunning();
                            }
                        }
                        finally {
                            Plugin.stopLongRunning();
                        }
                    } else {
                        JBEditorHelper.this.m_editor.getSite().getPage().closeEditor((IEditorPart)JBEditorHelper.this.m_editor, false);
                    }
                }
            }
        });
    }

    protected void addListeners() {
        this.m_activeListener = new ActiveListener();
        this.m_editor.getSite().getPage().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.m_activeListener);
        DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this.m_editor, true);
        DataEventDispatcher.getInstance().addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
    }

    protected boolean editorContainsPo(IPersistentObject po) {
        if (!(po instanceof INodePO) || !(this.getEditSupport().getWorkVersion() instanceof INodePO)) {
            return false;
        }
        INodePO compObj = (INodePO)this.getEditSupport().getWorkVersion();
        ArrayList<INodePO> nodeList = new ArrayList<INodePO>();
        nodeList.add((INodePO)po);
        List<INodePO> editorNodes = this.collectNodes(nodeList, compObj.getNodeListIterator());
        for (INodePO object : editorNodes) {
            if (!object.equals((Object)po)) continue;
            return true;
        }
        if (po instanceof ISpecTestCasePO) {
            ISpecTestCasePO specTc = (ISpecTestCasePO)po;
            List execTCs = NodePM.getInternalExecTestCases((String)specTc.getGuid(), (long)specTc.getParentProjectId());
            for (IExecTestCasePO execTc : execTCs) {
                for (INodePO object : editorNodes) {
                    if (!object.equals((Object)execTc)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<INodePO> collectNodes(List<INodePO> nodeList, Iterator<INodePO> it) {
        while (it.hasNext()) {
            INodePO node = it.next();
            nodeList.add(node);
            if (node.getNodeListSize() <= 0) continue;
            return this.collectNodes(nodeList, node.getNodeListIterator());
        }
        return nodeList;
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.m_isDirty = isDirty;
        this.m_editor.fireDirtyProperty(isDirty);
        GuiEventDispatcher.getInstance().fireEditorDirtyStateListener(this.m_editor, isDirty);
    }

    public EditableState getEditableState() {
        return this.m_editableState;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public Clipboard getClipboard() {
        return this.m_clipboard;
    }

    public void doEditorOperation(IEditorOperation operation) {
        if (this.requestEditableState() == EditableState.OK) {
            try {
                operation.run(this.getEditSupport().getWorkVersion());
            }
            finally {
                if (!this.m_editor.isDirty()) {
                    try {
                        this.resetEditableState();
                        this.getEditSupport().reloadEditSession();
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, this.m_editor);
                    }
                }
            }
        }
    }

    private class ActiveListener
    implements ISelectionListener {
        private ActiveListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part instanceof EditorPart) {
                JBEditorHelper.this.m_isActive = part == JBEditorHelper.this.m_editor;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditableState {
        NotChecked,
        OK,
        Locked,
        Stale,
        Invalid;

    }
}

