/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.model.IModifiableParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditParametersHandler
extends AbstractHandler {
    protected IJBEditor getEditor(ExecutionEvent event) {
        Object adapter;
        IWorkbenchPart activeEditor = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activeEditor != null && (adapter = activeEditor.getAdapter(IJBEditor.class)) != null) {
            return (IJBEditor)adapter;
        }
        return null;
    }

    protected static int getNewParamIndex(IParamDescriptionPO paramDesc, List<AbstractEditParametersDialog.Parameter> paramList) {
        int index = 0;
        for (AbstractEditParametersDialog.Parameter param : paramList) {
            if (param.getName().equals(paramDesc.getName())) {
                return index;
            }
            String paramGuid = param.getGuid();
            if (paramGuid != null && paramGuid.equals(paramDesc.getUniqueId())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean editParameters(IModifiableParameterInterfacePO paramIntObj, List<AbstractEditParametersDialog.Parameter> parameters, boolean isInterfaceLocked, ParamNameBPDecorator mapper, AbstractParamInterfaceBP paramInterfaceBP) {
        HashMap<String, IParamDescriptionPO> oldParams = new HashMap<String, IParamDescriptionPO>();
        List paramList = paramIntObj.getParameterList();
        for (IParamDescriptionPO oldDesc : paramList) {
            oldParams.put(oldDesc.getUniqueId(), oldDesc);
        }
        ArrayList<AbstractEditParametersDialog.Parameter> paramsToAdd = new ArrayList<AbstractEditParametersDialog.Parameter>();
        ArrayList<AbstractEditParametersDialog.Parameter> params = new ArrayList<AbstractEditParametersDialog.Parameter>(parameters);
        for (AbstractEditParametersDialog.Parameter parameter : parameters) {
            if (parameter.getGuid() != null) continue;
            paramsToAdd.add(parameter);
            params.remove(parameter);
        }
        HashMap<IParamDescriptionPO, String> paramsToRename = new HashMap<IParamDescriptionPO, String>();
        for (AbstractEditParametersDialog.Parameter param : params) {
            IParamDescriptionPO paramDescr = (IParamDescriptionPO)oldParams.get(param.getGuid());
            if (paramDescr != null) {
                if (paramDescr.getName().equals(param.getName())) continue;
                paramsToRename.put(paramDescr, param.getName());
                continue;
            }
            Assert.notReached((String)(String.valueOf(Messages.UnexpectedError) + ":" + " " + Messages.ModificationOfNonExistingParameter + "."));
        }
        ArrayList oldGuids = new ArrayList(oldParams.keySet());
        for (AbstractEditParametersDialog.Parameter parameter : parameters) {
            oldGuids.remove(parameter.getGuid());
        }
        ArrayList<IParamDescriptionPO> paramsToRemove = new ArrayList<IParamDescriptionPO>();
        for (String oldGuid : oldGuids) {
            paramsToRemove.add((IParamDescriptionPO)oldParams.get(oldGuid));
        }
        boolean isInterfaceLockedChanged = false;
        if (paramIntObj instanceof ISpecTestCasePO) {
            ISpecTestCasePO specTc = (ISpecTestCasePO)paramIntObj;
            isInterfaceLockedChanged = specTc.isInterfaceLocked() != isInterfaceLocked;
            TestCaseParamBP.setInterfaceLocked((ISpecTestCasePO)specTc, (boolean)isInterfaceLocked);
        }
        for (AbstractEditParametersDialog.Parameter addParam : paramsToAdd) {
            paramInterfaceBP.addParameter(addParam.getName(), addParam.getType(), paramIntObj, (IParamNameMapper)mapper);
        }
        for (IParamDescriptionPO desc : paramsToRemove) {
            List projLangs = GeneralStorage.getInstance().getProject().getLangHelper().getLanguageList();
            for (Locale locale : projLangs) {
                paramInterfaceBP.removeParameter(desc, (Object)paramIntObj, locale);
            }
        }
        for (IParamDescriptionPO desc : paramsToRename.keySet()) {
            paramInterfaceBP.renameParameters(desc, (String)paramsToRename.get(desc), mapper);
        }
        boolean moved = AbstractEditParametersHandler.moveParameters(paramIntObj, parameters);
        return !paramsToRemove.isEmpty() || !paramsToAdd.isEmpty() || !paramsToRename.isEmpty() || isInterfaceLockedChanged || moved;
    }

    private static boolean moveParameters(IModifiableParameterInterfacePO paramIntObj, List<AbstractEditParametersDialog.Parameter> parameters) {
        boolean moved = false;
        LinkedList paramList = new LinkedList(paramIntObj.getParameterList());
        for (IParamDescriptionPO paramDesc : paramList) {
            int newIdx;
            int currIdx = paramList.indexOf(paramDesc);
            if (currIdx == (newIdx = AbstractEditParametersHandler.getNewParamIndex(paramDesc, parameters))) continue;
            paramIntObj.moveParameter(paramDesc.getUniqueId(), newIdx);
            moved = true;
        }
        return moved;
    }

    public static boolean editParameters(IModifiableParameterInterfacePO paramIntObj, List<AbstractEditParametersDialog.Parameter> parameters, ParamNameBPDecorator mapper, AbstractParamInterfaceBP paramInterfaceBP) {
        return AbstractEditParametersHandler.editParameters(paramIntObj, parameters, false, mapper, paramInterfaceBP);
    }
}

