/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.osgi.util.NLS;

public class MapIntoCategoryHandler
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        this.setCategoryToMapInto(this.getSelection());
        return null;
    }

    private void setCategoryToMapInto(IStructuredSelection selection) {
        ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)Plugin.getActivePart();
        if (editor.getAut().equals(TestExecution.getInstance().getConnectedAut())) {
            IObjectMappingCategoryPO category = null;
            if (selection.size() == 1) {
                String strCat;
                IObjectMappingAssoziationPO assocNode;
                Object node = selection.getFirstElement();
                IObjectMappingCategoryPO unmappedTechNames = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
                if (node instanceof IObjectMappingCategoryPO) {
                    IObjectMappingCategoryPO catNode = (IObjectMappingCategoryPO)node;
                    if (unmappedTechNames.equals(OMEditorDndSupport.getSection(catNode))) {
                        category = catNode;
                    }
                } else if (node instanceof IObjectMappingAssoziationPO && unmappedTechNames.equals(OMEditorDndSupport.getSection(assocNode = (IObjectMappingAssoziationPO)node))) {
                    category = assocNode.getCategory();
                }
                editor.getOmEditorBP().setCategoryToCreateIn(category);
                IObjectMappingCategoryPO cat = ObjectMappingEventDispatcher.getCategoryToCreateIn();
                if (cat != null) {
                    strCat = cat.getName();
                    if (OMEditorTreeLabelProvider.getTopLevelCategoryName(strCat) != null) {
                        strCat = OMEditorTreeLabelProvider.getTopLevelCategoryName(strCat);
                    }
                } else {
                    strCat = Messages.TestExecutionContributorCatUnassigned;
                }
                String message = NLS.bind((String)Messages.TestExecutionContributorAUTStartedMapping, (Object)strCat);
                Plugin.showStatusLine(5, message);
            }
        }
    }
}

