/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.CollectComponentNameUsersOp;
import org.eclipse.jubula.client.core.datastructure.CompNameUsageMap;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.dialogs.ReusedProjectSelectionDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.messagehandling.MessageInfo;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveTestCaseHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        TestCaseBrowser tcb = MultipleTCBTracker.getInstance().getMainTCB();
        if (!(tcb.getSelection() instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection sel = (IStructuredSelection)tcb.getSelection();
        List selectionList = sel.toList();
        if (!this.closeRelatedEditors(selectionList)) {
            return null;
        }
        ProblemSet moveProblems = this.getMoveProblem(selectionList);
        if (moveProblems.getProblems().isEmpty()) {
            Set reusedProjects = GeneralStorage.getInstance().getProject().getUsedProjects();
            ArrayList<String> projectNamesList = new ArrayList<String>();
            for (IReusedProjectPO project : reusedProjects) {
                projectNamesList.add(project.getName());
            }
            String[] projectNames = projectNamesList.toArray(new String[projectNamesList.size()]);
            ReusedProjectSelectionDialog dialog = new ReusedProjectSelectionDialog(Plugin.getShell(), projectNames, Messages.MoveTestCaseDialogShellTitle, Messages.MoveTestCaseDialogMessage, "moveTestCaseDialog.gif", Messages.MoveTestCaseDialogShellTitle);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testCaseMoveExternalContextId");
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                String selectedName = dialog.getSelectedName();
                IReusedProjectPO selectedProject = null;
                for (IReusedProjectPO project : reusedProjects) {
                    if (!selectedName.equals(project.getName())) continue;
                    selectedProject = project;
                    break;
                }
                this.doMove(tcb, selectionList, selectedProject);
            }
        } else {
            this.showProblems(moveProblems);
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        boolean projectAvailable = currentProject == null ? false : !currentProject.getUsedProjects().isEmpty();
        super.setEnabled((Object)(enabled && projectAvailable ? 1 : 0));
    }

    private boolean closeRelatedEditors(List<INodePO> selectionList) {
        ArrayList<IEditorReference> editorsToClose = new ArrayList<IEditorReference>();
        for (INodePO node : selectionList) {
            IEditorReference editor = Utils.getEditorRefByPO((IPersistentObject)node);
            if (editor == null) continue;
            editorsToClose.add(editor);
        }
        return Plugin.getActivePage().closeEditors(editorsToClose.toArray(new IEditorReference[editorsToClose.size()]), true);
    }

    private void doMove(TestCaseBrowser tcb, List<INodePO> selectionList, IReusedProjectPO selectedProject) {
        IProjectPO extProject;
        EntityManager sess;
        block9: {
            sess = null;
            extProject = ProjectPM.loadReusedProject((IReusedProjectPO)selectedProject);
            sess = Persistor.instance().openSession();
            extProject = (IProjectPO)sess.find(NodeMaker.getProjectPOClass(), (Object)extProject.getId());
            List<ICapPO> moveProblem = this.getMoveProblem(extProject, selectionList);
            if (moveProblem.isEmpty()) break block9;
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_MOVE_TO_EXT_PROJ_ERROR_TOOLKITLEVEL, null, null);
            Persistor.instance().dropSession(sess);
            return;
        }
        try {
            ISpecObjContPO newParent = extProject.getSpecObjCont();
            List<MultipleNodePM.AbstractCmdHandle> commands = this.createCommands(selectionList, newParent, extProject);
            MessageInfo errorMessageInfo = MultipleNodePM.getInstance().executeCommands(commands, sess);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newParent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
            if (errorMessageInfo == null) {
                GeneralStorage.getInstance().getMasterSession().refresh((Object)GeneralStorage.getInstance().getProject().getSpecObjCont());
                tcb.getTreeViewer().refresh();
            } else {
                ErrorHandlingUtil.createMessageDialog((Integer)errorMessageInfo.getMessageId(), (Object[])errorMessageInfo.getParams(), null);
            }
        }
        catch (JBException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
            Persistor.instance().dropSession(sess);
        }
        catch (ToolkitPluginException toolkitPluginException) {
            try {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_GENERAL_TOOLKIT_ERROR);
            }
            catch (Throwable throwable) {
                Persistor.instance().dropSession(sess);
                throw throwable;
            }
            Persistor.instance().dropSession(sess);
        }
        Persistor.instance().dropSession(sess);
    }

    private List<ICapPO> getMoveProblem(IProjectPO extProject, List<INodePO> selectionList) throws ToolkitPluginException {
        ArrayList<ICapPO> problemCaps = new ArrayList<ICapPO>();
        String extToolkitId = extProject.getToolkit();
        String extToolkitLevel = ToolkitSupportBP.getToolkitLevel((String)extToolkitId);
        List<ICapPO> caps = this.getCaps(selectionList);
        for (ICapPO cap : caps) {
            String capLevel = UsedToolkitBP.getInstance().getToolkitLevel((INodePO)cap);
            boolean capLessConcrete = !ToolkitUtils.isToolkitMoreConcrete((String)capLevel, (String)extToolkitLevel);
            Component component = CapBP.getComponent((ICapPO)cap);
            String capToolkitID = component.getToolkitDesriptor().getToolkitID();
            if (capLessConcrete || capToolkitID.equals(extToolkitId)) continue;
            problemCaps.add(cap);
        }
        return problemCaps;
    }

    private List<ICapPO> getCaps(List<INodePO> selectionList) {
        ArrayList<ICapPO> caps = new ArrayList<ICapPO>();
        for (INodePO node : selectionList) {
            CapBP.getCaps((INodePO)node, caps);
        }
        return caps;
    }

    private void showProblems(ProblemSet moveProblems) {
        StringBuilder sb = new StringBuilder();
        for (MoveProblem moveProblem : moveProblems.getProblems()) {
            sb.append(moveProblem.getCause().getName());
            sb.append("\n");
        }
        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_CANNOT_MOVE_TC, null, (String[])new String[]{NLS.bind((String)Messages.InfoDetailCannotMoveTc, (Object)sb.toString())});
    }

    private List<MultipleNodePM.AbstractCmdHandle> createCommands(List<INodePO> selectionList, ISpecObjContPO newParent, IProjectPO extProject) throws JBException {
        ArrayList<MultipleNodePM.AbstractCmdHandle> commands = new ArrayList<MultipleNodePM.AbstractCmdHandle>();
        CompNameUsageMap usageMap = new CompNameUsageMap();
        String projGuid = GeneralStorage.getInstance().getProject().getGuid();
        Long projId = GeneralStorage.getInstance().getProject().getId();
        for (INodePO selNode : selectionList) {
            commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.MoveNodeHandle(selNode, (IPersistentObject)selNode.getParentNode(), (IPersistentObject)newParent));
            ArrayList<INodePO> specTcs = new ArrayList<INodePO>();
            ArrayList<ISpecTestCasePO> specTcPOs = new ArrayList<ISpecTestCasePO>();
            MoveTestCaseHandler.addCatChildren(selNode, specTcs);
            for (INodePO spec : specTcs) {
                ISpecTestCasePO specTestCasePo = (ISpecTestCasePO)spec;
                specTcPOs.add(specTestCasePo);
                CollectComponentNameUsersOp op = new CollectComponentNameUsersOp(projGuid, projId);
                TreeTraverser trav = new TreeTraverser((INodePO)specTestCasePo, (ITreeNodeOperation)op, true, 2);
                trav.traverse();
                usageMap.addAll(op.getUsageMap());
                for (IExecTestCasePO execTc : NodePM.getInternalExecTestCases((String)specTestCasePo.getGuid(), (long)specTestCasePo.getParentProjectId())) {
                    commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.UpdateTestCaseRefHandle(execTc, specTestCasePo));
                }
            }
            commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.UpdateParamNamesHandle(specTcPOs, extProject));
        }
        commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.TransferCompNameHandle(usageMap, GeneralStorage.getInstance().getProject().getId(), extProject));
        return commands;
    }

    private ProblemSet getMoveProblem(List<INodePO> selectionList) {
        ProblemSet problems = new ProblemSet(selectionList);
        this.getMoveProblem(selectionList, problems);
        return problems;
    }

    private void getMoveProblem(List<INodePO> selectionList, ProblemSet problems) {
        for (INodePO node : selectionList) {
            if (node instanceof IExecTestCasePO) {
                ISpecTestCasePO refTestCase = ((IExecTestCasePO)node).getSpecTestCase();
                if (refTestCase == null) continue;
                Long curProjectId = GeneralStorage.getInstance().getProject().getId();
                if (!refTestCase.getParentProjectId().equals(curProjectId)) continue;
                problems.addProblem(node);
                continue;
            }
            this.getMoveProblem(node.getUnmodifiableNodeList(), problems);
        }
    }

    private static void addCatChildren(INodePO parentNode, Collection<INodePO> nodeList) {
        if (parentNode instanceof ICategoryPO) {
            for (INodePO node : parentNode.getUnmodifiableNodeList()) {
                MoveTestCaseHandler.addCatChildren(node, nodeList);
            }
        } else if (parentNode instanceof ISpecTestCasePO) {
            nodeList.add(parentNode);
        }
    }

    private static class MoveProblem {
        private INodePO m_problemNode;

        public MoveProblem(INodePO problemNode) {
            this.m_problemNode = problemNode;
        }

        public INodePO getCause() {
            return this.m_problemNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProblemSet {
        private List<MoveProblem> m_problems = new ArrayList<MoveProblem>();
        private List<INodePO> m_nodesToMove = new ArrayList<INodePO>();

        public ProblemSet(List<INodePO> nodesToMove) {
            for (INodePO node : nodesToMove) {
                MoveTestCaseHandler.addCatChildren(node, this.m_nodesToMove);
            }
        }

        public void addProblem(INodePO problemNode) {
            if (!this.m_nodesToMove.contains(problemNode)) {
                this.m_problems.add(new MoveProblem(problemNode.getParentNode()));
            }
        }

        public List<MoveProblem> getProblems() {
            return this.m_problems;
        }
    }
}

