/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.ProjectDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteProjectHandler
extends AbstractProjectHandler {
    private static final int NUM_HBM_PROGRESS_EVENT_TYPES = 1;

    void selectProject() {
        block17: {
            boolean deleteCurrentProject = false;
            try {
                List projList = ProjectPM.findAllProjects();
                if (projList.isEmpty()) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_PROJECT_IN_DB);
                    return;
                }
                ProjectDialog dialog = this.getComboSelectionDialog(projList);
                if (dialog.getReturnCode() == 1) {
                    return;
                }
                ProjectDialog.ProjectData project = dialog.getSelection();
                IProjectPO projectToDelete = null;
                for (IProjectPO projToDelete : projList) {
                    if (!projToDelete.getGuid().equals(project.getGUID()) || !projToDelete.getVersionString().equals(project.getVersionString())) continue;
                    projectToDelete = projToDelete;
                }
                if (projectToDelete == null) {
                    Plugin.stopLongRunning();
                    return;
                }
                try {
                    boolean keepTestresults = dialog.keepTestresultSummary();
                    Integer questionID = null;
                    Object[] param = null;
                    IProjectPO actProj = GeneralStorage.getInstance().getProject();
                    if (actProj != null && actProj.getId().equals(projectToDelete.getId())) {
                        questionID = MessageIDs.Q_DELETE_ACTUAL_PROJECT;
                        deleteCurrentProject = true;
                    } else {
                        questionID = MessageIDs.Q_DELETE_PROJECT;
                        param = new Object[]{projectToDelete.getName()};
                    }
                    Plugin.startLongRunning(Messages.DeleteProjectActionWaitWhileDeleting);
                    Dialog qDialog = ErrorHandlingUtil.createMessageDialog((Integer)questionID, (Object[])param, null);
                    if (qDialog.getReturnCode() != 0) break block17;
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new DeleteProjectOperation(projectToDelete, deleteCurrentProject, keepTestresults));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (JBException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                }
            }
            finally {
                Plugin.stopLongRunning();
            }
        }
    }

    private boolean isRefreshRequired(String deletedGuid, Integer deletedMajor, Integer deletedMinor) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject == null) {
            return false;
        }
        for (IReusedProjectPO reused : currentProject.getUsedProjects()) {
            String guid = reused.getProjectGuid();
            Integer majorVersion = reused.getMajorNumber();
            Integer minorVersion = reused.getMinorNumber();
            if (!deletedGuid.equals(guid) || !deletedMajor.equals(majorVersion) || !deletedMinor.equals(minorVersion)) continue;
            return true;
        }
        return false;
    }

    private ProjectDialog getComboSelectionDialog(List<IProjectPO> projList) {
        ProjectDialog dialog = new ProjectDialog(this.getActiveShell(), projList, Messages.DeleteProjectActionMessage, Messages.OpenProjectActionTitle, IconConstants.DELETE_PROJECT_DIALOG_IMAGE, Messages.DeleteProjectActionCaption, true);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.deleteProjectDialogContextId");
        dialog.open();
        return dialog;
    }

    public Object executeImpl(ExecutionEvent event) {
        this.selectProject();
        return null;
    }

    private class DeleteProjectOperation
    implements IRunnableWithProgress {
        private IProjectPO m_project;
        private boolean m_deleteCurrentProject;
        private boolean m_keepTestresultSummary = false;

        public DeleteProjectOperation(IProjectPO project, boolean deleteCurrentProject, boolean keepTestresultSummary) {
            this.m_project = project;
            this.m_deleteCurrentProject = deleteCurrentProject;
            this.m_keepTestresultSummary = keepTestresultSummary;
        }

        /*
         * Loose catch block
         */
        public void run(IProgressMonitor monitor) throws InterruptedException {
            monitor.beginTask(NLS.bind((String)Messages.DeleteProjectActionDeleting, (Object[])new Object[]{this.m_project.getName(), this.m_project.getMajorProjectVersion(), this.m_project.getMinorProjectVersion()}), this.getTotalWork());
            try {
                try {
                    boolean isRefreshRequired = false;
                    if (!this.m_deleteCurrentProject) {
                        isRefreshRequired = DeleteProjectHandler.this.isRefreshRequired(this.m_project.getGuid(), this.m_project.getMajorProjectVersion(), this.m_project.getMinorProjectVersion());
                    }
                    if (this.m_deleteCurrentProject) {
                        Plugin.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                Plugin.closeAllOpenedJubulaEditors(false);
                            }
                        });
                    }
                    ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
                    ProjectPM.deleteProject((IProjectPO)this.m_project, (boolean)this.m_deleteCurrentProject);
                    final String jobName = Messages.UIJobDeletingTestResultDetails;
                    Job job = new Job(jobName){

                        public IStatus run(IProgressMonitor mon) {
                            mon.beginTask(jobName, -1);
                            if (DeleteProjectOperation.this.m_keepTestresultSummary) {
                                TestResultSummaryPM.deleteTestrunsByProject((String)DeleteProjectOperation.this.m_project.getGuid(), (int)DeleteProjectOperation.this.m_project.getMajorProjectVersion(), (int)DeleteProjectOperation.this.m_project.getMinorProjectVersion(), (boolean)true);
                            } else {
                                TestResultSummaryPM.deleteTestrunsByProject((String)DeleteProjectOperation.this.m_project.getGuid(), (int)DeleteProjectOperation.this.m_project.getMajorProjectVersion(), (int)DeleteProjectOperation.this.m_project.getMinorProjectVersion(), (boolean)false);
                            }
                            mon.done();
                            DataEventDispatcher.getInstance().fireTestresultChanged(DataEventDispatcher.TestresultState.Refresh);
                            return Status.OK_STATUS;
                        }
                    };
                    if (this.m_deleteCurrentProject) {
                        Utils.clearClient();
                        GeneralStorage.getInstance().setProject(null);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.m_project, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
                    } else if (isRefreshRequired) {
                        GeneralStorage.getInstance().reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
                    }
                    job.schedule();
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                    monitor.done();
                    Plugin.stopLongRunning();
                    return;
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleGDProjectDeletedException();
                    ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                    monitor.done();
                    Plugin.stopLongRunning();
                    return;
                }
                catch (JBException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                    monitor.done();
                    Plugin.stopLongRunning();
                }
            }
            finally {
                ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                monitor.done();
                Plugin.stopLongRunning();
            }
        }

        private int getTotalWork() {
            int totalWork = 0;
            ++totalWork;
            EntityManager getNumNodesSession = Persistor.instance().openSession();
            totalWork = (int)((long)totalWork + NodePM.getNumNodes((long)this.m_project.getId(), (EntityManager)getNumNodesSession));
            Persistor.instance().dropSessionWithoutLockRelease(getNumNodesSession);
            return totalWork *= 1;
        }
    }
}

