/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class ListSelectionVerifier {
    private List m_itemList = new ArrayList();

    public void addItem(int index, String value, boolean isSelected) {
        this.m_itemList.add(index, new SelectionItem(value, isSelected));
    }

    public void verifySelection(String patternString, String op, boolean isSelected) throws StepExecutionException {
        String hit = null;
        Iterator iter = this.m_itemList.iterator();
        while (hit == null && iter.hasNext()) {
            SelectionItem item = (SelectionItem)iter.next();
            String itemValue = item.getValue();
            if (!MatchUtil.getInstance().match(itemValue, patternString, op)) continue;
            hit = itemValue;
        }
        if (hit == null && isSelected) {
            throw new StepExecutionException("No selected list element matches " + patternString, EventFactory.createVerifyFailed((String)this.toString(), (String)patternString, (String)op));
        }
        if (hit != null && !isSelected) {
            throw new StepExecutionException("Selected list element matches " + patternString, EventFactory.createVerifyFailed((String)hit, (String)patternString, (String)op));
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        Iterator iter = this.m_itemList.iterator();
        while (iter.hasNext()) {
            SelectionItem element = (SelectionItem)iter.next();
            if (!element.isSelected()) continue;
            res.append(element.getValue());
            res.append(',');
        }
        if (res.length() > 0) {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    private class SelectionItem {
        private String m_value;
        private boolean m_selected;

        public SelectionItem(String value, boolean selected) {
            this.m_value = value;
            this.m_selected = selected;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

