/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses.tree;

import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.DistanceBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;

public class SiblingTraverser
extends DistanceBasedTraverser {
    private boolean m_isSearchForward;

    public SiblingTraverser(AbstractTreeOperationContext context, int distance, boolean searchForward) {
        super(context, distance);
        this.m_isSearchForward = searchForward;
    }

    public SiblingTraverser(AbstractTreeOperationContext context, int distance, boolean searchForward, TreeNodeOperationConstraint constraint) {
        super(context, distance, constraint);
        this.m_isSearchForward = searchForward;
    }

    public void traversePath(TreeNodeOperation operation, Object startNode) throws StepExecutionException {
        operation.setContext(this.getContext());
        int modifier = this.m_isSearchForward ? 1 : -1;
        Object node = startNode;
        Object parent = this.getContext().getParent(node);
        int curIndex = this.getContext().getIndexOfChild(parent, node);
        if (this.isOperable(-1, this.getDistance())) {
            this.callOperation(startNode, operation);
        }
        int i = 0;
        while (i < this.getDistance()) {
            if ((curIndex += modifier) < 0 || curIndex >= this.getContext().getNumberOfChildren(parent)) {
                this.throwTreeNodeNotFound(node);
            }
            node = this.getContext().getChild(parent, curIndex);
            if (this.isOperable(i, this.getDistance())) {
                this.callOperation(node, operation);
            }
            ++i;
        }
    }

    private void throwTreeNodeNotFound(Object startNode) throws StepExecutionException {
        TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.TreeNodeNotFound");
        throw new StepExecutionException("Tree node not found: Sibling of " + startNode.toString(), event);
    }
}

