/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.accessor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.listener.IAutListenerAppender;
import org.eclipse.jubula.rc.rcp.gef.inspector.GefInspectorListenerAppender;
import org.eclipse.jubula.rc.rcp.gef.listener.GefPartListener;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class Startup
implements IStartup {
    public static final String TEST_GEF_VIEWER_DATA_KEY = "TEST_GEF_VIEWER";
    public static final String GEF_BUNDLE_ID = "org.eclipse.gef";
    private static final String TEST_RCP_DATA_KEY = "TEST_RCP_COMP_NAME";
    private static final String TOOLBAR_ID_SUFFIX = ".toolbar";
    private static IPartListener2 partNamingListener = new PartNamingListener();
    private IPartListener2 m_gefListener = null;
    static /* synthetic */ Class class$0;

    public void earlyStartup() {
        Properties envVars = EnvironmentUtils.getProcessEnvironment();
        if (this.getValue("com.bredexsw.guidancer.aut.register.autAgentHost", envVars) != null) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            final Display display = workbench.getDisplay();
            this.initAutServer(display, envVars);
            display.syncExec(new Runnable(){

                public void run() {
                    if (Platform.getBundle((String)Startup.GEF_BUNDLE_ID) != null) {
                        Startup.this.m_gefListener = new GefPartListener();
                        AUTServer.getInstance().addInspectorListenerAppender((IAutListenerAppender)new GefInspectorListenerAppender());
                    }
                    ComponentNamer namer = new ComponentNamer();
                    display.addFilter(9, (Listener)namer);
                    display.addFilter(26, (Listener)namer);
                    Startup.this.addWindowListener(workbench);
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        Startup.this.addPartListeners(window);
                        IWorkbenchPage[] pages = window.getPages();
                        int i = 0;
                        while (i < pages.length) {
                            IEditorReference[] editorRefs = pages[i].getEditorReferences();
                            IViewReference[] viewRefs = pages[i].getViewReferences();
                            int j = 0;
                            while (j < editorRefs.length) {
                                partNamingListener.partOpened((IWorkbenchPartReference)editorRefs[j]);
                                if (Startup.this.m_gefListener != null) {
                                    Startup.this.m_gefListener.partOpened((IWorkbenchPartReference)editorRefs[j]);
                                }
                                ++j;
                            }
                            int k = 0;
                            while (k < viewRefs.length) {
                                partNamingListener.partOpened((IWorkbenchPartReference)viewRefs[k]);
                                if (Startup.this.m_gefListener != null) {
                                    Startup.this.m_gefListener.partOpened((IWorkbenchPartReference)viewRefs[k]);
                                }
                                ++k;
                            }
                            ++i;
                        }
                        Shell mainShell = window.getShell();
                        if (mainShell != null && !mainShell.isDisposed()) {
                            Startup.repaintToolbars(mainShell);
                        }
                    }
                }
            });
            AUTServer.getInstance().addToolKitEventListenerToAUT();
        }
    }

    private void initAutServer(Display display, Properties envVars) {
        ((SwtAUTServer)AUTServer.getInstance((String)"org.eclipse.jubula.rc.swt.SwtAUTServer")).setDisplay(display);
        AUTServer.getInstance().setAutAgentHost(this.getValue("com.bredexsw.guidancer.aut.register.autAgentHost", envVars));
        AUTServer.getInstance().setAutAgentPort(this.getValue("com.bredexsw.guidancer.aut.register.autAgentPort", envVars));
        AUTServer.getInstance().setAutID(this.getValue("com.bredexsw.guidancer.aut.register.autName", envVars));
        AUTServer.getInstance().start(true);
    }

    private void addWindowListener(IWorkbench workbench) {
        workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
                Startup.this.addPartListeners(window);
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
                Startup.this.addPartListeners(window);
            }
        });
    }

    public static void repaintToolbars(Shell mainShell) {
        ArrayList toolbarList = new ArrayList();
        Startup.getToolbars((Composite)mainShell, toolbarList);
        Iterator iter = toolbarList.iterator();
        while (iter.hasNext()) {
            Control toolbar = (Control)iter.next();
            toolbar.update();
            toolbar.redraw();
            toolbar.update();
        }
    }

    public static void getToolbars(Composite composite, List toolbarList) {
        if (composite != null && !composite.isDisposed()) {
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Composite) {
                    Startup.getToolbars((Composite)children[i], toolbarList);
                }
                try {
                    if (children[i] instanceof ToolBar || children[i] instanceof CoolBar) {
                        toolbarList.add(children[i]);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
                ++i;
            }
        }
    }

    private void addPartListeners(IWorkbenchWindow window) {
        window.getPartService().addPartListener(partNamingListener);
        if (this.m_gefListener != null) {
            window.getPartService().addPartListener(this.m_gefListener);
        }
    }

    private String getValue(String propName, Properties envVars) {
        String value = envVars.getProperty(propName);
        if (value == null) {
            value = System.getProperty(propName);
        }
        return value;
    }

    private static class ComponentNamer
    implements Listener {
        private static Map componentNAMES = new HashMap();
        private static boolean generateNames = false;

        static {
            generateNames = Boolean.valueOf(EnvironmentUtils.getProcessEnvironment().getProperty("GD_GENERATE_NAMES_PROPERTY"));
            ComponentNamer.addCompName(7, "abort");
            ComponentNamer.addCompName(14, "back");
            ComponentNamer.addCompName(1, "cancel");
            ComponentNamer.addCompName(1024, "client");
            ComponentNamer.addCompName(12, "close");
            ComponentNamer.addCompName(19, "deselectAll");
            ComponentNamer.addCompName(13, "details");
            ComponentNamer.addCompName(16, "finish");
            ComponentNamer.addCompName(17, "help");
            ComponentNamer.addCompName(9, "ignore");
            ComponentNamer.addCompName(256, "internal");
            ComponentNamer.addCompName(15, "next");
            ComponentNamer.addCompName(3, "no");
            ComponentNamer.addCompName(21, "noToAll");
            ComponentNamer.addCompName(0, "ok");
            ComponentNamer.addCompName(11, "open");
            ComponentNamer.addCompName(10, "proceed");
            ComponentNamer.addCompName(8, "retry");
            ComponentNamer.addCompName(18, "selectAll");
            ComponentNamer.addCompName(20, "selectTypes");
            ComponentNamer.addCompName(5, "skip");
            ComponentNamer.addCompName(6, "stop");
            ComponentNamer.addCompName(2, "yes");
            ComponentNamer.addCompName(4, "yesToAll");
        }

        private ComponentNamer() {
        }

        private static void addCompName(int compID, String compName) {
            String staticNamePreafix = "dialog.button.";
            componentNAMES.put(new Integer(compID), String.valueOf(staticNamePreafix) + compName);
        }

        public void handleEvent(Event event) {
            this.addNameData(event.widget);
            Item[] items = new Item[]{};
            if (event.widget instanceof ToolBar) {
                items = ((ToolBar)event.widget).getItems();
            } else if (event.widget instanceof CoolBar) {
                items = ((CoolBar)event.widget).getItems();
            }
            int i = 0;
            while (i < items.length) {
                this.addNameData((Widget)items[i]);
                ++i;
            }
        }

        private void addNameData(Widget widget) {
            if (widget != null && !widget.isDisposed()) {
                if (widget.getData(Startup.TEST_RCP_DATA_KEY) != null) {
                    return;
                }
                Object data = this.getWidgetData(widget);
                if (data instanceof IContributionItem) {
                    String actionId = ((IContributionItem)data).getId();
                    if (actionId != null && actionId.trim().length() > 0) {
                        widget.setData(Startup.TEST_RCP_DATA_KEY, (Object)actionId);
                        ComponentHandler.getAutHierarchy().refreshComponentName(widget);
                    }
                } else if (data instanceof PreferenceDialog) {
                    PreferenceDialog prefDialog = (PreferenceDialog)data;
                    prefDialog.addPageChangedListener(new IPageChangedListener(this){
                        final /* synthetic */ ComponentNamer this$1;
                        {
                            this.this$1 = componentNamer;
                        }

                        public void pageChanged(PageChangedEvent event) {
                            ComponentNamer.access$0(this.this$1, event.getSelectedPage());
                        }
                    });
                    this.addNameDataToPrefPage(prefDialog.getSelectedPage());
                }
                if (generateNames && data instanceof Dialog) {
                    Dialog dialog = (Dialog)data;
                    this.setNameForDialogButtonBarButtons(dialog);
                }
            }
        }

        private Object getWidgetData(Widget widget) {
            Object data = widget.getData();
            try {
                Composite toolbarParent;
                if (widget instanceof ToolBar && (toolbarParent = ((ToolBar)widget).getParent()) instanceof CoolBar) {
                    CoolItem[] coolItems = ((CoolBar)toolbarParent).getItems();
                    int i = 0;
                    while (i < coolItems.length) {
                        CoolItem item = coolItems[i];
                        if (item != null && item.getControl() == widget) {
                            data = item.getData();
                        }
                        ++i;
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            return data;
        }

        private void setNameForDialogButtonBarButtons(Dialog dialog) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.dialogs.Dialog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method getButtonMethod = clazz.getDeclaredMethod("getButton", Integer.TYPE);
                getButtonMethod.setAccessible(true);
                Iterator components = componentNAMES.keySet().iterator();
                while (components.hasNext()) {
                    Integer componentID = (Integer)components.next();
                    this.invokeNameSetting(dialog, getButtonMethod, componentID, componentNAMES.get(componentID));
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }

        private void invokeNameSetting(Object useObject, Method methodToInvoke, Integer buttonID, Object buttonName) {
            Button button;
            Object ret = null;
            try {
                ret = methodToInvoke.invoke(useObject, buttonID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            if (ret instanceof Button && (button = (Button)ret).getData(Startup.TEST_RCP_DATA_KEY) == null) {
                button.setData(Startup.TEST_RCP_DATA_KEY, buttonName);
            }
        }

        private void addNameDataToPrefPage(Object selectedPage) {
            if (selectedPage == null) {
                return;
            }
            PreferenceManager prefMan = PlatformUI.getWorkbench().getPreferenceManager();
            Iterator iter = prefMan.getElements(0).iterator();
            while (iter.hasNext()) {
                IPreferenceNode prefNode = (IPreferenceNode)iter.next();
                if (!selectedPage.equals(prefNode.getPage())) continue;
                Control pageControl = prefNode.getPage().getControl();
                String prefNodeId = prefNode.getId();
                if (pageControl == null || pageControl.isDisposed() || pageControl.getData(Startup.TEST_RCP_DATA_KEY) != null || prefNodeId == null || prefNodeId.trim().length() <= 0) break;
                pageControl.setData(Startup.TEST_RCP_DATA_KEY, (Object)prefNodeId);
                Shell prefShell = pageControl.getDisplay().getActiveShell();
                Event activateEvent = new Event();
                activateEvent.time = (int)System.currentTimeMillis();
                activateEvent.type = 26;
                activateEvent.widget = prefShell;
                prefShell.notifyListeners(26, activateEvent);
                break;
            }
        }

        static /* synthetic */ void access$0(ComponentNamer componentNamer, Object object) {
            componentNamer.addNameDataToPrefPage(object);
        }
    }

    static class PartNamingListener
    implements IPartListener2 {
        PartNamingListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            WorkbenchPartReference workbenchPartRef;
            Control partContent;
            if (partRef instanceof WorkbenchPartReference && (partContent = (workbenchPartRef = (WorkbenchPartReference)partRef).getPane().getControl()) != null && !partContent.isDisposed() && partContent.getData(Startup.TEST_RCP_DATA_KEY) == null) {
                String secondaryId;
                String partId = workbenchPartRef.getId();
                if (partRef instanceof IViewReference && (secondaryId = ((IViewReference)partRef).getSecondaryId()) != null) {
                    partId = String.valueOf(partId) + "_" + secondaryId;
                }
                if (partId == null || partId.trim().length() == 0) {
                    return;
                }
                partContent.setData(Startup.TEST_RCP_DATA_KEY, (Object)partId);
                Control partToolbar = workbenchPartRef.getPane().getToolBar();
                if (partToolbar != null) {
                    partToolbar.setData(Startup.TEST_RCP_DATA_KEY, (Object)(String.valueOf(partId) + Startup.TOOLBAR_ID_SUFFIX));
                }
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Startup.repaintToolbars(shell);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            this.partOpened(partRef);
        }
    }
}

