/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.swt.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swt.driver.RobotFactorySwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotSwtImpl;
import org.eclipse.jubula.rc.swt.listener.AbstractAutSwtEventListener;
import org.eclipse.jubula.rc.swt.listener.CheckListener;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.FocusTracker;
import org.eclipse.jubula.rc.swt.listener.MappingListener;
import org.eclipse.jubula.rc.swt.listener.RecordListener;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtAUTServer
extends AUTServer {
    private static final Logger LOG;
    private Display m_display = null;
    private RobotSwtImpl m_robot = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.SwtAUTServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LoggerFactory.getLogger((Class)clazz);
    }

    public SwtAUTServer() {
        super((AUTEventListener)new MappingListener(), (AUTEventListener)new RecordListener(), (AUTEventListener)new CheckListener());
    }

    public void startAUT() {
        if (this.isRcpAccessible()) {
            return;
        }
        super.startAUT();
        this.getAutDisplay();
        if (!this.isAgentSet()) {
            super.addToolKitEventListenerToAUT();
        }
    }

    public Display getAutDisplay() {
        if (this.isRcpAccessible()) {
            while (this.m_display == null) {
                this.m_display = Display.findDisplay((Thread)Thread.currentThread());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            return this.getSwtAutDisplay();
        }
        return this.m_display;
    }

    private Display getSwtAutDisplay() {
        Display display;
        ClassLoader oldCL;
        block6: {
            oldCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getAutThread().getContextClassLoader());
                while (this.m_display == null) {
                    this.m_display = Display.findDisplay((Thread)this.getAutThread());
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                display = this.m_display;
                Object var2_3 = null;
                if (this.m_display != null) break block6;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (this.m_display == null) {
                    LOG.error("SWT Display not found");
                }
                Thread.currentThread().setContextClassLoader(oldCL);
                throw throwable;
            }
            LOG.error("SWT Display not found");
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        return display;
    }

    protected void addToolkitEventListeners() {
        this.addToolkitEventListener(new ComponentHandler());
        this.addToolkitEventListener(new FocusTracker());
        this.addToolkitEventListener(TableSelectionTracker.getInstance());
    }

    protected void addToolkitEventListener(final BaseAUTListener listener) {
        try {
            this.getAutDisplay().syncExec(new Runnable(){

                public void run() {
                    long[] mask = listener.getEventMask();
                    int i = 0;
                    while (i < mask.length) {
                        SwtAUTServer.this.getAutDisplay().addFilter((int)mask[i], (Listener)listener);
                        ++i;
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("installing SWTEventListener " + listener.toString());
                    }
                }
            });
        }
        catch (NullPointerException se) {
            LOG.error("An error occured: ", (Throwable)se);
            System.exit(21);
        }
    }

    protected void removeToolkitEventListener(final BaseAUTListener listener) {
        try {
            this.getAutDisplay().syncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < ((AbstractAutSwtEventListener)listener).getEventMask().length) {
                        SwtAUTServer.this.getAutDisplay().removeFilter((int)((AbstractAutSwtEventListener)listener).getEventMask()[i], (Listener)((AbstractAutSwtEventListener)listener));
                        if (LOG.isInfoEnabled()) {
                            LOG.info("uninstalling SWTEventListener " + listener.toString());
                        }
                        ++i;
                    }
                }
            });
        }
        catch (NullPointerException se) {
            LOG.error("An error occured: ", (Throwable)se);
            System.exit(21);
        }
    }

    protected void startTasks() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException {
        super.invokeAUT();
        if (this.getCommunicator() != null) {
            this.getCommunicator().close();
        }
    }

    public synchronized IRobot getRobot() {
        if (this.m_robot == null) {
            RobotFactorySwtImpl robotFactory = new RobotFactoryConfig().getRobotFactory();
            this.m_robot = (RobotSwtImpl)robotFactory.getRobot();
        }
        return this.m_robot;
    }

    public void setDisplay(Display display) {
        this.m_display = display;
    }
}

