/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import org.eclipse.jubula.communication.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.listener.BaseSwtEventListener;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.KeyAcceptor;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutSwtEventListener
extends BaseSwtEventListener
implements AUTEventListener {
    private static final Logger LOG;
    private Object m_componentLock = new Object();
    private Widget m_currentComponent = null;
    private KeyAcceptor m_acceptor = new KeyAcceptor();
    private Event m_lastEvent;
    private Shell m_borderShell;
    private Widget m_oldWidget;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.listener.AbstractAutSwtEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LoggerFactory.getLogger((Class)clazz);
    }

    protected AbstractAutSwtEventListener() {
    }

    public long[] getEventMask() {
        return new long[]{5L, 4L, 3L, 6L, 1L, 18L, 17L, 35L, 22L, 13L, 15L, 16L, 31L};
    }

    protected Event getLastEvent() {
        return this.m_lastEvent;
    }

    protected void setLastEvent(Event lastEvent) {
        this.m_lastEvent = lastEvent;
    }

    protected Object getComponentLock() {
        return this.m_componentLock;
    }

    protected Widget getCurrentComponent() {
        return this.m_currentComponent;
    }

    protected void setCurrentComponent(Widget currentComponent) {
        this.m_currentComponent = currentComponent;
    }

    protected KeyAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    public void cleanUp() {
        Display d = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        if (d != null) {
            d.syncExec(new Runnable(){

                public void run() {
                    if (AbstractAutSwtEventListener.this.m_borderShell != null) {
                        AbstractAutSwtEventListener.this.m_borderShell.getRegion().dispose();
                        AbstractAutSwtEventListener.this.m_borderShell.close();
                        AbstractAutSwtEventListener.this.m_borderShell.dispose();
                        AbstractAutSwtEventListener.this.m_borderShell = null;
                    }
                }
            });
        }
    }

    public abstract void handleEvent(Event var1);

    protected void highlightComponent() {
        Widget widget;
        try {
            Class componentClass = AbstractAutSwtEventListener.getComponentClass(this.getCurrentComponent());
            if (componentClass != null) {
                AUTServerConfiguration.getInstance().getImplementationClass(componentClass);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("An error occured: ", (Throwable)e);
        }
        catch (UnsupportedComponentException unsupportedComponentException) {
            this.closeBorderShell();
            return;
        }
        if ((widget = this.getCurrentComponent()) == null || widget == this.m_oldWidget) {
            return;
        }
        Rectangle widgetBounds = SwtUtils.getWidgetBounds(widget);
        if (widgetBounds == null) {
            return;
        }
        this.setCurrentComponent(widget);
        this.closeBorderShell();
        int wX = widgetBounds.x;
        int wY = widgetBounds.y;
        int wW = widgetBounds.width;
        int wH = widgetBounds.height;
        Region region = new Region();
        region.add(new Rectangle(0, 0, wW + 4, wH + 4));
        region.subtract(new Rectangle(2, 2, wW, wH));
        Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        this.m_borderShell = new Shell(display, 540680);
        this.m_borderShell.setBackground(this.getBorderColor());
        this.m_borderShell.setRegion(region);
        Rectangle size = region.getBounds();
        this.m_borderShell.setSize(size.width, size.height);
        this.m_borderShell.setLocation(wX - 2, wY - 2);
        this.m_borderShell.setVisible(true);
        this.m_oldWidget = widget;
    }

    private void closeBorderShell() {
        if (this.m_borderShell != null) {
            this.m_borderShell.getRegion().dispose();
            this.m_borderShell.close();
            this.m_borderShell.dispose();
            this.m_borderShell = null;
            this.setCurrentComponent(null);
            this.m_oldWidget = null;
        }
    }

    protected void changeCheckModeState(int mode) {
        ChangeAUTModeMessage msg = new ChangeAUTModeMessage();
        msg.setMode(mode);
        msg.setKey(AUTServerConfiguration.getInstance().getKey());
        msg.setKeyModifier(AUTServerConfiguration.getInstance().getKeyMod());
        msg.setKey2(AUTServerConfiguration.getInstance().getKey2());
        msg.setKey2Modifier(AUTServerConfiguration.getInstance().getKey2Mod());
        msg.setCheckModeKey(AUTServerConfiguration.getInstance().getCheckModeKey());
        msg.setCheckModeKeyModifier(AUTServerConfiguration.getInstance().getCheckModeKeyMod());
        msg.setCheckCompKey(AUTServerConfiguration.getInstance().getCheckCompKey());
        msg.setCheckCompKeyModifier(AUTServerConfiguration.getInstance().getCheckCompKeyMod());
        msg.setSingleLineTrigger(AUTServerConfiguration.getInstance().getSingleLineTrigger());
        msg.setMultiLineTrigger(AUTServerConfiguration.getInstance().getMultiLineTrigger());
        ChangeAUTModeCommand cmd = new ChangeAUTModeCommand();
        cmd.setMessage((Message)msg);
        try {
            AUTServer.getInstance().getCommunicator().send(cmd.execute());
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
    }

    protected void setCurrentWidget() {
        Widget widget = SwtUtils.getWidgetAtCursorLocation();
        this.setCurrentComponent(widget);
    }

    protected abstract void handleKeyEvent(Event var1);

    public void update() {
    }

    public boolean highlightComponent(IComponentIdentifier comp) {
        Widget component = null;
        try {
            component = ComponentHandler.findComponent(comp, true, 10000);
            this.setCurrentComponent(component);
            ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay().syncExec(new Runnable(){

                public void run() {
                    AbstractAutSwtEventListener.this.highlightComponent();
                }
            });
        }
        catch (ComponentNotFoundException e) {
            LOG.debug("Component with IComponentIdentifier '" + String.valueOf(comp) + "' not found!", (Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            LOG.debug("An error occured: ", (Throwable)e);
            return false;
        }
        return component != null;
    }

    protected abstract Color getBorderColor();
}

