/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.properties.nodes;

import java.util.ArrayList;
import java.util.Collections;
import javax.persistence.EntityManager;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.Category;
import org.eclipse.jubula.client.teststyle.properties.nodes.CheckNode;
import org.eclipse.jubula.client.teststyle.properties.nodes.INode;

public class CategoryNode
implements INode {
    private Category m_category;
    private INode[] m_children;

    public CategoryNode(Category category) {
        this.m_category = category;
        ArrayList<CheckNode> nodes = new ArrayList<CheckNode>();
        for (BaseCheck check : category.getChecks()) {
            nodes.add(new CheckNode(this, check));
        }
        Collections.sort(nodes);
        this.m_children = nodes.toArray(new INode[nodes.size()]);
    }

    public INode[] getChildren() {
        return this.m_children;
    }

    public INode getParent() {
        return null;
    }

    public void save(EntityManager s) {
        INode[] iNodeArray = this.m_children;
        int n = this.m_children.length;
        int n2 = 0;
        while (n2 < n) {
            INode node = iNodeArray[n2];
            node.save(s);
            ++n2;
        }
    }

    public void setState(INode.TreeState state) {
        INode[] iNodeArray = this.m_children;
        int n = this.m_children.length;
        int n2 = 0;
        while (n2 < n) {
            INode node = iNodeArray[n2];
            node.setState(state);
            ++n2;
        }
    }

    public String getText() {
        return this.m_category.getName();
    }

    public INode.TreeState getState() {
        if (this.m_children.length == 0) {
            return INode.TreeState.EMPTY;
        }
        INode.TreeState state = INode.TreeState.EMPTY;
        boolean allChecked = true;
        INode[] iNodeArray = this.m_children;
        int n = this.m_children.length;
        int n2 = 0;
        while (n2 < n) {
            INode node = iNodeArray[n2];
            if (node.getState().equals((Object)INode.TreeState.CHECKED)) {
                state = INode.TreeState.GRAYED;
            } else {
                allChecked = false;
            }
            ++n2;
        }
        if (allChecked) {
            return INode.TreeState.CHECKED;
        }
        return state;
    }

    public int compareTo(INode o) {
        return this.getText().compareTo(o.getText());
    }

    public boolean hasSeverity() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryNode) {
            CategoryNode other = (CategoryNode)obj;
            return this.m_category.equals(other.m_category);
        }
        return false;
    }

    public int hashCode() {
        return this.m_category.hashCode();
    }

    public String getTooltip() {
        return this.m_category.getDescription();
    }
}

