/*******************************************************************************
 * Copyright (c) 2004, 2010 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.client.ui.rcp.handlers.open;

import java.util.Iterator;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * Handler to open the SpecTestCaseEditor.
 * 
 * @author BREDEX GmbH
 * @created 05.09.2005
 */
public class OpenTestCaseEditorHandler extends AbstractOpenHandler {
    /**
     * {@inheritDoc}
     */
    public Object executeImpl(ExecutionEvent event) {
        ISelection currentSelection = HandlerUtil.getCurrentSelection(event);
        if (!(currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        Iterator iter = ((IStructuredSelection) currentSelection).iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof INodePO) {
                INodePO selectedNode = (INodePO) obj;
                INodePO editableNode = findEditableNode(selectedNode);
                if (editableNode == null) {
                    return null;
                }
                openEditor(editableNode);
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    protected boolean isEditableImpl(INodePO selected) {
        return selected instanceof ISpecTestCasePO
                && NodeBP.isEditable(selected);
    }
}