/*******************************************************************************
 * Copyright (c) 2004, 2010 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.client.ui.rcp.handlers.open;

import java.util.Iterator;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.ui.constants.Constants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;


/**
 * @author BREDEX GmbH
 * @created Mar 17, 2010
 */
public class OpenTestJobEditorHandler extends AbstractOpenHandler {

    /**
     * {@inheritDoc}
     */
    protected boolean isEditableImpl(INodePO selected) {
        return (selected instanceof ITestJobPO);
    }

    /**
     * {@inheritDoc}
     */
    public Object executeImpl(ExecutionEvent event) {
        TestSuiteBrowser testExecTreeView = (TestSuiteBrowser)Plugin
                .getView(Constants.TS_BROWSER_ID);
        if (testExecTreeView == null) {
            return null;
        }
        if (!(testExecTreeView.getTreeViewer().getSelection() 
                instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)testExecTreeView
                .getTreeViewer().getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            INodePO selectedNode = (INodePO)iter.next();
            INodePO editableNode = findEditableNode(selectedNode);
            if (editableNode == null) {
                return null;
            }
            openEditor(editableNode);
        }
        return null;
    }

}
