/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.newcap;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.NewCAPDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewCAP
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractTestCaseEditor) {
            final AbstractTestCaseEditor tce = (AbstractTestCaseEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                public void run(IPersistentObject workingPo) {
                    ISpecTestCasePO workTC = (ISpecTestCasePO)workingPo;
                    IStructuredSelection selection = NewCAP.this.getSelection();
                    INodePO selectedNode = (INodePO)selection.getFirstElement();
                    if (selectedNode != null) {
                        ISpecTestCasePO specTcGUI = null;
                        int posistionToAdd = workTC.indexOf(selectedNode);
                        while (!(selectedNode instanceof ISpecTestCasePO)) {
                            selectedNode = selectedNode.getParentNode();
                        }
                        specTcGUI = (ISpecTestCasePO)selectedNode;
                        NewCAP.this.addCap(specTcGUI, workTC, posistionToAdd, tce);
                    }
                }
            });
        }
        return null;
    }

    private void addCap(ISpecTestCasePO specTcGUI, ISpecTestCasePO workTC, Integer position, AbstractTestCaseEditor tse) {
        NewCAPDialog dialog = new NewCAPDialog(this.getActiveShell(), specTcGUI, (IComponentNameMapper)tse.getEditorHelper().getEditSupport().getCompMapper());
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String componentType = dialog.getComponentType();
        String capName = dialog.getCapName();
        String action = dialog.getActionName();
        String componentName = dialog.getComponentName();
        ICapPO cap = CapBP.createCapWithDefaultParams((String)capName, (String)componentName, (String)componentType, (String)action);
        IWritableComponentNameMapper compMapper = tse.getEditorHelper().getEditSupport().getCompMapper();
        try {
            cap.setComponentName(null);
            ComponentNamesBP.getInstance().setCompName(cap, componentName, ComponentNamesBP.CompNameCreationContext.STEP, compMapper);
            workTC.addNode(position.intValue(), (INodePO)cap);
            tse.getEditorHelper().setDirty(true);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)cap, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        }
        catch (IncompatibleTypeException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
        }
        catch (PMException pme) {
            PMExceptionHandler.handlePMExceptionForEditor(pme, tse);
        }
    }
}

