/*******************************************************************************
 * Copyright (c) 2012 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation 
 *******************************************************************************/
package org.eclipse.jubula.rc.common.uiadapter.interfaces;

/**
 * Interface for all necessary methods for testing menuitems.
 * 
 * @author BREDEX GmbH
 */
public interface IMenuItemAdapter extends IComponentAdapter {

    /**
     * 
     * @return the text which is saved in the item
     */
    public String getText();
    /**
     * 
     * @return <code>true</code> if the component is visible
     */
    public boolean isEnabled();
    /**
     * 
     * @return <code>true</code> if the component exists
     *         that means there is an item in this wrapper 
     */
    public boolean isExisting();
    /**
     * 
     * @return <code>true</code> if the component is selected
     * 
     */
    public boolean isSelected();
    /**
     * 
     * @return <code>true</code> if the component is Showing
     */
    public boolean isShowing();
    
    /** Gets the menu of the menuitem 
     * @return the menu which is attached to the item
     */
    public IMenuAdapter getMenu();
    
    /**
     * 
     * @return <code>true</code> if the menuitem has a menu
     */
    public boolean hasSubMenu();
    /**
     * Checks whether the given menu item is a separator. 
     * This method runs in the GUI thread.
     * @return <code>true</code> if <code>menuItem</code> is a separator item.
     *         Otherwise <code>false</code>.
     */
    public boolean isSeparator();
    
    /**
     * This Methods selects the specific menuItem with an click
     * or in another toolkit specitif way
     */
    public void selectMenuItem();
    
    /**
     * This method trys to open the the next Menu in the cascade
     * 
     * @return the next SubMenu in the Menu
     */
    public IMenuAdapter openSubMenu();
   
    
}
