/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.caps;

import org.eclipse.jubula.rc.common.caps.AbstractTextInputSupport;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IComboBoxAdapter;
import org.eclipse.jubula.tools.utils.StringParsing;

public class AbstractComboBoxCAPs
extends AbstractTextInputSupport {
    public static final char VALUE_SEPARATOR = ',';

    private IComboBoxAdapter getCBAdapter() {
        return (IComboBoxAdapter)this.getComponent();
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    public void gdVerifyEditable(boolean editable) {
        Verifier.equals(editable, this.getCBAdapter().isEditable());
    }

    public void gdVerifyContainsValue(String text) {
        Verifier.equals(true, this.getCBAdapter().containsValue(text));
    }

    public void gdVerifyContainsValue(String value, String operator, boolean exists) {
        boolean contains = this.getCBAdapter().containsValue(value, operator);
        Verifier.equals(exists, contains);
    }

    protected String getText() {
        return this.getCBAdapter().getText();
    }

    public void gdInputText(String text) {
        this.getCBAdapter().input(text, false);
    }

    public void gdReplaceText(String text) throws StepExecutionException {
        this.getCBAdapter().input(text, true);
    }

    public void gdSelectIndex(String index) {
        int implIdx = IndexConverter.toImplementationIndex(IndexConverter.intValue(index));
        this.getCBAdapter().select(implIdx);
    }

    public void gdSelectValue(String valueList, String operator, String searchType) {
        this.gdSelectValue(valueList, String.valueOf(','), operator, searchType);
    }

    private void gdSelectValue(String valueList, String separator, String operator, String searchType) {
        String[] values = this.split(valueList, separator);
        this.getCBAdapter().select(values, operator, searchType);
    }

    public void gdVerifySelectedIndex(String index, boolean isSelected) {
        int implIdx = IndexConverter.toImplementationIndex(IndexConverter.intValue(index));
        int actual = this.getCBAdapter().getSelectedIndex();
        Verifier.equals(implIdx, actual, isSelected);
    }

    public void gdVerifyText(String text) {
        this.gdVerifyText(text, "equals");
    }

    private String[] split(String values, String separator) {
        String[] list = StringParsing.splitToArray((String)values, (char)(separator == null || separator.length() == 0 ? (char)',' : separator.charAt(0)), (char)'\\');
        return list;
    }
}

