/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.caps;

import java.util.StringTokenizer;
import org.eclipse.jubula.rc.common.caps.AbstractMenuCAPs;
import org.eclipse.jubula.rc.common.caps.AbstractUICAPs;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IWidgetAdapter;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.tools.utils.TimeUtil;

public abstract class AbstractWidgetCAPs
extends AbstractUICAPs {
    private IWidgetAdapter getWidgetAdapter() {
        return (IWidgetAdapter)this.getComponent();
    }

    public void gdVerifyExists(boolean exists) {
        Verifier.equals(exists, this.getWidgetAdapter().isShowing());
    }

    public void gdVerifyFocus(boolean hasFocus) {
        Verifier.equals(hasFocus, this.getWidgetAdapter().hasFocus());
    }

    public void gdVerifyEnabled(boolean enabled) {
        Verifier.equals(enabled, this.getWidgetAdapter().isEnabled());
    }

    public void gdVerifyProperty(String name, String value, String operator) {
        IWidgetAdapter bean = (IWidgetAdapter)this.getComponent();
        bean.getPropteryValue(name);
        String propToStr = bean.getPropteryValue(name);
        Verifier.match(propToStr, value, operator);
    }

    public void gdClick(int count, int button) {
        this.getRobot().click(this.getComponent().getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button));
    }

    public void gdclick(int count) {
        this.gdClick(count, 1);
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click(this.getComponent().getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase("Pixel"), yPos, yUnits.equalsIgnoreCase("Pixel"));
    }

    public void gdDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        this.getWidgetAdapter().gdDrag(mouseButton, modifier, xPos, xUnits, yPos, yUnits);
    }

    public void gdDrop(int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) {
        this.getWidgetAdapter().gdDrop(xPos, xUnits, yPos, yUnits, delayBeforeDrop);
    }

    public void gdWaitForComponent(int timeout, int delay) {
    }

    public String gdStorePropertyValue(String variableName, String propertyName) {
        IWidgetAdapter bean = (IWidgetAdapter)this.getComponent();
        return bean.getPropteryValue(propertyName);
    }

    public void gdPopupSelectByIndexPath(String indexPath, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.selectMenuItemByIndexpath(indexPath);
    }

    public void gdPopupSelectByTextPath(String textPath, String operator, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.selectMenuItem(textPath, operator);
    }

    public void gdPopupSelectByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.selectMenuItem(textPath, operator);
    }

    public void gdPopupSelectByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.selectMenuItemByIndexpath(indexPath);
    }

    public void gdPopupVerifyEnabledByIndexPath(String indexPath, boolean enabled, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.verifyEnabledByIndexpath(indexPath, enabled);
    }

    public void gdPopupVerifyEnabledByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean enabled, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.verifyEnabledByIndexpath(indexPath, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.verifyEnabled(textPath, operator, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.verifyEnabled(textPath, operator, enabled);
    }

    public void gdPopupVerifySelectedByIndexPath(String indexPath, boolean selected, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.verifySelectedByIndexpath(indexPath, selected);
    }

    public void gdPopupVerifySelectedByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean selected, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.verifySelectedByIndexpath(indexPath, selected);
    }

    public void gdPopupVerifySelectedByTextPath(String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.verifySelected(textPath, operator, selected);
    }

    public void gdPopupVerifySelectedByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.verifySelected(textPath, operator, selected);
    }

    public void gdPopupVerifyExistsByIndexPath(String indexPath, boolean exists, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.verifyExistsByIndexpath(indexPath, exists);
    }

    public void gdPopupVerifyExistsByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean exists, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.verifyExistsByIndexpath(indexPath, exists);
    }

    public void gdPopupVerifyExistsByTextPath(String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(button);
        popup.verifyExists(textPath, operator, exists);
    }

    public void gdPopupVerifyExistsByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        AbstractMenuCAPs popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.verifyExists(textPath, operator, exists);
    }

    protected ClickOptions.ClickModifier getClickModifier(String extendSelection) {
        ClickOptions.ClickModifier cm = ClickOptions.ClickModifier.create();
        if ("yes".equalsIgnoreCase(extendSelection)) {
            cm.add(1);
        }
        return cm;
    }

    public void gdShowText(String text, int textSize, int timePerWord, int windowWidth) {
        this.getWidgetAdapter().showToolTip(text, textSize, timePerWord, windowWidth);
    }

    protected void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString(modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = this.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    protected int getKeyCode(String mod) {
        return this.getWidgetAdapter().getKeyCode(mod);
    }

    public static void waitBeforeDrop(int delayBeforeDrop) {
        TimeUtil.delay((long)delayBeforeDrop);
    }
}

