/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.caps;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.jubula.rc.common.caps.AbstractTableCAPs;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.utils.SwingUtils;

public class JTableCAPs
extends AbstractTableCAPs {
    private static AutServerLogger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.caps.JTableCAPs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public static AutServerLogger getLog() {
        return log;
    }

    private JTable getTable() {
        return (JTable)this.getComponent().getRealComponent();
    }

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public String[] getTextArrayFromComponent() {
        String[] componentTextArray;
        TableColumnModel columnModel = this.getTable().getColumnModel();
        if (columnModel == null) {
            componentTextArray = null;
        } else {
            componentTextArray = new String[columnModel.getColumnCount()];
            int i = 0;
            while (i < componentTextArray.length) {
                Object headerValue;
                TableColumn tableColumn = columnModel.getColumn(i);
                componentTextArray[i] = tableColumn == null ? null : ((headerValue = tableColumn.getHeaderValue()) == null ? null : headerValue.toString());
                ++i;
            }
        }
        return componentTextArray;
    }

    protected int getExtendSelectionModifier() {
        return SwingUtils.getSystemDefaultModifier();
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        JTable table = this.getTable();
        Point mousePos = this.getRobot().getCurrentMousePosition();
        Point tablePos = table.getLocationOnScreen();
        Point relativePos = new Point(mousePos.x - tablePos.x, mousePos.y - tablePos.y);
        int column = table.columnAtPoint(relativePos);
        int row = table.rowAtPoint(relativePos);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected row, col: " + row + ", " + column));
        }
        this.checkRowColBounds(row, column);
        return new Cell(row, column);
    }

    protected boolean isMouseOnHeader() {
        JTable table = this.getTable();
        if (table.getTableHeader() == null || !table.getTableHeader().isShowing()) {
            return false;
        }
        JTableHeader header = table.getTableHeader();
        Point mousePos = this.getRobot().getCurrentMousePosition();
        try {
            Point headerPos = header.getLocationOnScreen();
            Point relativePos = new Point(mousePos.x - headerPos.x, mousePos.y - headerPos.y);
            return header.getBounds().contains(relativePos);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return false;
        }
    }

    protected Object setEditorToReplaceMode(Object editor, boolean replace) {
        Object returnvalue = editor;
        if (replace) {
            this.getRobot().clickAtCurrentPosition(editor, 3, 1);
        } else {
            returnvalue = this.getComponent().getRealComponent();
        }
        return returnvalue;
    }

    protected Object activateEditor(Cell cell, Rectangle rectangle) {
        Object table = this.getComponent().getRealComponent();
        this.getRobot().click(table, (Object)rectangle);
        Component editor = this.getTableCellEditor(cell);
        if (editor == null) {
            ClickOptions co = ClickOptions.create().setClickCount(2);
            this.getRobot().click(table, (Object)rectangle, co);
            editor = this.getTableCellEditor(cell);
        }
        return editor;
    }

    private Component getTableCellEditor(final Cell cell) {
        final JTable table = (JTable)this.getComponent().getRealComponent();
        return (Component)this.getEventThreadQueuer().invokeAndWait("getCellEditor", new IRunnable(){

            public Object run() {
                Object value = table.getValueAt(cell.getRow(), cell.getCol());
                boolean selected = table.isCellSelected(cell.getRow(), cell.getCol());
                return table.getCellEditor(cell.getRow(), cell.getCol()).getTableCellEditorComponent(table, value, selected, cell.getRow(), cell.getCol());
            }
        });
    }
}

