/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.caps;

import java.awt.Point;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.eclipse.jubula.rc.common.caps.AbstractTreeCAPs;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JTreeCAPs
extends AbstractTreeCAPs {
    public void gdDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelect(pathType, preAscend, treeTextPath, operator, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        try {
            this.gdSelect(pathType, preAscend, treeTextPath, operator, 0, 1, "no");
            JTreeCAPs.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        try {
            this.gdSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, "no");
            JTreeCAPs.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdVerifyTextAtMousePosition(String text, String operator) {
        this.checkNodeText(this.getNodeAtMousePosition(), text, operator);
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getEventThreadQueuer().invokeAndWait("getNodeAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                TreePath treePath;
                Point mousePosition = JTreeCAPs.this.getRobot().getCurrentMousePosition();
                Point treeLocation = JTreeCAPs.this.getTreeComponent().getLocationOnScreen();
                Point relativePos = new Point(mousePosition.x - treeLocation.x, mousePosition.y - treeLocation.y);
                int rowAtMousePosition = JTreeCAPs.this.getTreeComponent().getRowForLocation(relativePos.x, relativePos.y);
                if (rowAtMousePosition != -1 && (treePath = JTreeCAPs.this.getTreeComponent().getPathForLocation(relativePos.x, relativePos.y)) != null && treePath.getLastPathComponent() != null) {
                    return treePath.getLastPathComponent();
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    private JTree getTreeComponent() {
        return (JTree)this.getComponent().getRealComponent();
    }

    protected IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }
}

