/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.ListSelectionVerifier;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.JListHelper;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJList;
import org.eclipse.jubula.rc.swing.utils.SwingUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.StringParsing;

public class JListImplClass
extends AbstractSwingImplClass
implements IJList {
    private JList m_list;
    private JListHelper m_listHelper;

    public JComponent getComponent() {
        return this.m_list;
    }

    public void setComponent(Object graphicsComponent) {
        this.m_list = (JList)graphicsComponent;
        this.m_listHelper = new JListHelper(this);
    }

    private String[] split(String values, String separator) {
        String[] list = StringParsing.splitToArray((String)values, (char)(separator == null || separator.length() == 0 ? (char)',' : separator.charAt(0)), (char)'\\');
        list = StringUtils.stripAll((String[])list);
        return list;
    }

    private int[] parseIndices(String indexList) {
        String[] list = StringParsing.splitToArray((String)indexList, (char)',', (char)'\\');
        int[] indices = new int[list.length];
        int i = 0;
        while (i < list.length) {
            indices[i] = IndexConverter.intValue((String)list[i]);
            ++i;
        }
        return indices;
    }

    private int[] getCheckedSelectedIndices() throws StepExecutionException {
        int[] selected = this.m_listHelper.getSelectedIndices(this.m_list);
        if (selected.length == 0) {
            throw new StepExecutionException("No list element selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return selected;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectIndices(int[] indices, ClickOptions co, boolean isExtendSelection) {
        block8: {
            if (indices.length <= 0) break block8;
            try {
                if (isExtendSelection) {
                    this.getRobot().keyPress((Object)this.m_list, SwingUtils.getSystemDefaultModifier());
                }
                this.m_listHelper.clickOnIndex(this.m_list, new Integer(indices[0]), co);
            }
            catch (Throwable var5_4) {
                var4_7 = null;
                if (isExtendSelection == false) throw var5_4;
                this.getRobot().keyRelease((Object)this.m_list, SwingUtils.getSystemDefaultModifier());
                throw var5_4;
            }
            {
                var4_8 = null;
                if (!isExtendSelection) break block8;
            }
            this.getRobot().keyRelease((Object)this.m_list, SwingUtils.getSystemDefaultModifier());
            ** GOTO lbl-1000
        }
        try lbl-1000:
        // 2 sources

        {
            this.getRobot().keyPress((Object)this.m_list, SwingUtils.getSystemDefaultModifier());
            i = 1;
            while (i < indices.length) {
                this.m_listHelper.clickOnIndex(this.m_list, new Integer(indices[i]), co);
                ++i;
            }
        }
        catch (Throwable var6_10) {
            var5_5 = null;
            this.getRobot().keyRelease((Object)this.m_list, SwingUtils.getSystemDefaultModifier());
            throw var6_10;
        }
        {
            var5_6 = null;
        }
        this.getRobot().keyRelease((Object)this.m_list, SwingUtils.getSystemDefaultModifier());
    }

    public void gdVerifySelectedIndex(String index, boolean expectSelected) {
        int implIndex;
        int[] selected = this.getCheckedSelectedIndices();
        boolean isSelected = ArrayUtils.contains((int[])selected, (int)(implIndex = IndexConverter.toImplementationIndex((int)Integer.parseInt(index))));
        if (expectSelected != isSelected) {
            throw new StepExecutionException("Selection check failed for index: " + index, EventFactory.createVerifyFailed((String)String.valueOf(expectSelected), (String)String.valueOf(isSelected)));
        }
    }

    public void gdVerifySelectedValue(String valueList) {
        this.gdVerifySelectedValue(valueList, "equals", true);
    }

    public void gdVerifySelectedValue(String value, String operator, boolean isSelected) {
        String[] current = this.m_listHelper.getSelectedValues(this.m_list);
        ListSelectionVerifier listSelVerifier = new ListSelectionVerifier();
        int i = 0;
        while (i < current.length) {
            listSelVerifier.addItem(i, current[i], true);
            ++i;
        }
        listSelVerifier.verifySelection(value, operator, isSelected);
    }

    public void gdVerifyText(String text, String operator) {
        String[] selected = this.m_listHelper.getSelectedValues(this.m_list);
        int selCount = selected.length;
        if (selCount < 1) {
            throw new StepExecutionException("No selection", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        int i = 0;
        while (i < selCount) {
            Verifier.match((String)selected[i], (String)text, (String)operator);
            ++i;
        }
    }

    public void gdSelectIndex(String indexList, String extendSelection, int button) {
        boolean isExtendSelection = extendSelection.equals("yes");
        this.selectIndices(IndexConverter.toImplementationIndices((int[])this.parseIndices(indexList)), ClickOptions.create().setClickCount(1).setMouseButton(button), isExtendSelection);
    }

    public void gdSelectValue(String valueList, String operator, String searchType, String isExtendSelection, int button) {
        this.selectValue(valueList, String.valueOf(','), operator, searchType, ClickOptions.create().setClickCount(1).setMouseButton(button), isExtendSelection);
    }

    public void gdDragValue(int mouseButton, String modifier, String value, String operator, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        Integer[] indices = this.m_listHelper.findIndicesOfValues(this.m_list, new String[]{value}, operator, searchType);
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0), false);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropValue(String value, String operator, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            Integer[] indices = this.m_listHelper.findIndicesOfValues(this.m_list, new String[]{value}, operator, searchType);
            this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0), false);
            JListImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragIndex(int mouseButton, String modifier, int index) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.selectIndices(new int[]{IndexConverter.toImplementationIndex((int)index)}, ClickOptions.create().setClickCount(0), false);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropIndex(int index, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.selectIndices(new int[]{IndexConverter.toImplementationIndex((int)index)}, ClickOptions.create().setClickCount(0), false);
            JListImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdSelectValue(String valueList, String separator, String operator, String searchType, int clickCount, String extendSelection) {
        this.selectValue(valueList, separator, operator, searchType, ClickOptions.create().setClickCount(clickCount), extendSelection);
    }

    private void selectValue(String valueList, String separator, String operator, String searchType, ClickOptions co, String extendSelection) {
        String[] values = null;
        boolean isExtendSelection = extendSelection.equals("yes");
        values = "".equals(valueList) ? new String[]{""} : this.split(valueList, separator);
        Object[] indices = this.m_listHelper.findIndicesOfValues(this.m_list, values, operator, searchType);
        Arrays.sort(indices);
        if (!operator.equals("not equals") && indices.length < values.length) {
            throw new StepExecutionException("One or more values not found of set: " + Arrays.asList(values).toString(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), co, isExtendSelection);
    }

    public void gdVerifyContainsValue(String value) {
        Verifier.equals((boolean)true, (boolean)this.m_listHelper.containsValue(this.m_list, value));
    }

    public void gdVerifyContainsValue(String value, String operator, boolean exists) {
        Verifier.equals((boolean)exists, (boolean)this.m_listHelper.containsValue(this.m_list, value, operator));
    }

    public String gdReadValue(String variable) {
        String[] selected = this.m_listHelper.getSelectedValues(this.m_list);
        if (selected.length > 0) {
            return selected[0];
        }
        throw new StepExecutionException("No list item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected String getText() {
        return null;
    }
}

