/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJTextComponent;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JTextComponentImplClass
extends AbstractSwingImplClass
implements IJTextComponent {
    private JTextComponent m_textComponent;

    protected JTextComponent getTextComponent() {
        return (JTextComponent)this.getComponent();
    }

    public JComponent getComponent() {
        return this.m_textComponent;
    }

    public void setComponent(Object graphicsComponent) {
        this.m_textComponent = (JTextComponent)graphicsComponent;
    }

    private void setCaretPosition(final int index) {
        if (index < 0) {
            throw new StepExecutionException("Invalid position: " + index, EventFactory.createActionError());
        }
        this.getEventThreadQueuer().invokeAndWait("setCaretPosition", new IRunnable(){

            public Object run() {
                int index2 = 0;
                String text = JTextComponentImplClass.this.getTextComponent().getText();
                if (text != null) {
                    index2 = index > text.length() ? text.length() : index;
                }
                JTextComponentImplClass.this.getTextComponent().setCaretPosition(index2);
                return null;
            }
        });
    }

    protected String getText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return JTextComponentImplClass.this.getTextComponent().getText();
            }
        });
        return actual;
    }

    public String gdReadValue(String variable) {
        return this.getText();
    }

    private void insertText(String text) {
        this.getRobot().scrollToVisible((Object)this.getTextComponent(), null);
        this.getRobot().type((Object)this.getTextComponent(), text);
    }

    public void gdVerifyText(String text, String operator) {
        Verifier.match((String)this.getText(), (String)text, (String)operator);
    }

    public void gdVerifyText(String text) {
        this.gdVerifyText(text, "equals");
    }

    public void gdReplaceText(String text) {
        this.gdSelect();
        if ("".equals(text)) {
            this.getRobot().keyStroke("DELETE");
        }
        this.insertText(text);
    }

    public void gdInputText(String text) {
        if (!this.hasFocus()) {
            this.gdClick(1);
        }
        this.insertText(text);
    }

    public void gdInsertText(String text, int index) {
        this.gdClick(1);
        this.setCaretPosition(index);
        this.insertText(text);
    }

    public void gdInsertText(String text, String pattern, String operator, boolean after) throws StepExecutionException {
        if (text == null) {
            throw new StepExecutionException("The text to be inserted must not be null", EventFactory.createActionError());
        }
        MatchUtil.FindResult matchedText = MatchUtil.getInstance().find(this.getText(), pattern, operator);
        if (matchedText == null || matchedText.getStr() == null || matchedText.getStr().length() == 0) {
            throw new StepExecutionException("The pattern '" + pattern + "' could not be found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        int index = matchedText.getPos();
        int insertPos = after ? index + matchedText.getStr().length() : index;
        this.gdInsertText(text, insertPos);
    }

    public void gdVerifyEditable(boolean editable) {
        this.verify(editable, "isEditable", new IRunnable(){

            public Object run() {
                return JTextComponentImplClass.this.getTextComponent().isEditable() && JTextComponentImplClass.this.getTextComponent().isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdSelect() {
        this.gdClick(1);
        this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
        if (!this.getText().equals(this.getSelectionText())) {
            this.getEventThreadQueuer().invokeAndWait("selectAll", new IRunnable(){

                public Object run() {
                    JTextComponentImplClass.this.getTextComponent().selectAll();
                    return null;
                }
            });
        }
    }

    protected String getSelectionText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getSelectionText", new IRunnable(){

            public Object run() {
                return JTextComponentImplClass.this.getTextComponent().getSelectedText();
            }
        });
        return actual;
    }

    public void gdSelect(final String pattern, String operator) throws StepExecutionException {
        this.gdClick(1);
        final MatchUtil.FindResult matchedText = MatchUtil.getInstance().find(this.getText(), pattern, operator);
        if (matchedText == null || matchedText.getStr().length() == 0) {
            throw new StepExecutionException("Invalid pattern for insertion", EventFactory.createActionError());
        }
        final int index = matchedText.getPos();
        if (operator.startsWith("not")) {
            this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

                public Object run() {
                    if (pattern.equals(JTextComponentImplClass.this.getText())) {
                        String msg = "The pattern '" + pattern + "' is equal to current text";
                        throw new StepExecutionException(msg, EventFactory.createActionError((String)"TestErrorEvent.ExecutionError", (Object[])new String[]{msg}));
                    }
                    if (index > 0) {
                        JTextComponentImplClass.this.getTextComponent().setSelectionStart(0);
                        JTextComponentImplClass.this.getTextComponent().setSelectionEnd(index);
                    } else {
                        JTextComponentImplClass.this.getTextComponent().setSelectionStart(matchedText.getStr().length());
                        JTextComponentImplClass.this.getTextComponent().setSelectionEnd(JTextComponentImplClass.this.getText().length());
                    }
                    return null;
                }
            });
        } else {
            this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

                public Object run() {
                    JTextComponentImplClass.this.getTextComponent().setSelectionStart(index);
                    JTextComponentImplClass.this.getTextComponent().setSelectionEnd(index + matchedText.getStr().length());
                    return null;
                }
            });
        }
    }

    public void gdClick(int count) {
        this.gdClick(count, 1);
    }

    public void gdClick(int count, int button) {
        this.getRobot().click((Object)this.getTextComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button), 3, true, 50, false);
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }
}

