/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.uiadapter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IListAdapter;
import org.eclipse.jubula.rc.swing.swing.caps.CapUtil;
import org.eclipse.jubula.rc.swing.swing.uiadapter.WidgetAdapter;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JListAdapter
extends WidgetAdapter
implements IListAdapter {
    private JList m_list;

    public JListAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_list = (JList)objectToAdapt;
    }

    public String getText() {
        String[] selected = this.getSelectedValues();
        if (selected.length > 0) {
            return selected[0];
        }
        throw new StepExecutionException("No list item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
    }

    public int[] getSelectedIndices() {
        return (int[])this.getEventThreadQueuer().invokeAndWait("getSelectedIndices", new IRunnable(){

            public Object run() {
                return JListAdapter.this.m_list.getSelectedIndices();
            }
        });
    }

    public void clickOnIndex(Integer i, ClickOptions co, double maxWidth) {
        final int index = i;
        ListModel model = this.m_list.getModel();
        if (model == null || index >= model.getSize() || index < 0) {
            throw new StepExecutionException("List index '" + i + "' is out of range", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
        Rectangle r = (Rectangle)this.getRobotFactory().getEventThreadQueuer().invokeAndWait("getCellBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JListAdapter.this.m_list.getCellBounds(index, index);
            }
        });
        if (r == null) {
            throw new StepExecutionException("List index '" + i + "' is not visible", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
        }
        ListCellRenderer lcr = this.m_list.getCellRenderer();
        if (lcr != null) {
            Component listItem = lcr.getListCellRendererComponent(this.m_list, model.getElementAt(index), index, false, false);
            Dimension preferredSize = listItem.getPreferredSize();
            r.setSize(preferredSize);
        }
        if (maxWidth != -1.0 && r.getWidth() > maxWidth) {
            Dimension d = new Dimension();
            d.setSize(maxWidth, r.getHeight());
            r.setSize(d);
        }
        this.getRobot().click((Object)this.m_list, (Object)r, co.setClickType(ClickOptions.ClickType.RELEASED));
    }

    public String[] getSelectedValues() {
        final int[] indices = this.getSelectedIndices();
        return (String[])this.getEventThreadQueuer().invokeAndWait("getSelectedValues", new IRunnable(){

            public Object run() {
                Object[] values = JListAdapter.this.m_list.getSelectedValues();
                String[] selected = new String[values.length];
                ListCellRenderer<Object> renderer = JListAdapter.this.m_list.getCellRenderer();
                int i = 0;
                while (i < values.length) {
                    Object value = values[i];
                    Component c = renderer.getListCellRendererComponent(JListAdapter.this.m_list, value, indices[i], true, false);
                    selected[i] = CapUtil.getRenderedText(c);
                    ++i;
                }
                return selected;
            }
        });
    }

    public Integer[] findIndicesOfValues(final String[] values, final String operator, final String searchType) {
        final HashSet indexSet = new HashSet();
        this.getEventThreadQueuer().invokeAndWait("findIndices", new IRunnable(){

            public Object run() {
                ListCellRenderer renderer = JListAdapter.this.m_list.getCellRenderer();
                ListModel model = JListAdapter.this.m_list.getModel();
                int i = JListAdapter.this.getStartingIndex(searchType);
                while (i < model.getSize()) {
                    Object obj = model.getElementAt(i);
                    JListAdapter.this.m_list.ensureIndexIsVisible(i);
                    Component comp = renderer.getListCellRendererComponent(JListAdapter.this.m_list, obj, i, false, false);
                    String str = CapUtil.getRenderedText(comp);
                    if (MatchUtil.getInstance().match(str, values, operator)) {
                        indexSet.add(new Integer(i));
                    }
                    ++i;
                }
                return null;
            }
        });
        Integer[] indices = new Integer[indexSet.size()];
        indexSet.toArray(indices);
        return indices;
    }

    public Integer[] findIndicesOfValues(String[] values, String operator) {
        return this.findIndicesOfValues(values, operator, "absolute");
    }

    public boolean containsValue(String value, String operator) {
        Integer[] indices = null;
        if (operator.equals("not equals")) {
            indices = this.findIndicesOfValues(new String[]{value}, "equals");
            return indices.length == 0;
        }
        indices = this.findIndicesOfValues(new String[]{value}, operator);
        return indices.length > 0;
    }

    public void clickOnIndex(Integer i, ClickOptions co) {
        this.clickOnIndex(i, co, -1.0);
    }

    private int getStartingIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            int[] selectedIndices = this.getSelectedIndices();
            startingIndex = selectedIndices[selectedIndices.length - 1] + 1;
        }
        return startingIndex;
    }
}

