/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.caps;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.caps.AbstractMenuCAPs;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IBaseImplementationClass;
import org.eclipse.jubula.rc.common.implclasses.MenuUtilBase;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IComponentAdapter;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IMenuAdapter;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IMenuItemAdapter;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotSwtImpl;
import org.eclipse.jubula.rc.swt.uiadapter.MenuItemAdapter;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class MenuCAPs
extends AbstractMenuCAPs
implements IBaseImplementationClass {
    private boolean m_isCM = false;

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public IComponentAdapter getComponent() {
        if (this.m_isCM) {
            return super.getComponent();
        }
        final Shell shell = ((RobotSwtImpl)this.getRobot()).getActiveWindow();
        if (shell == null) {
            this.setComponent(null);
        } else {
            EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
            queuer.invokeAndWait("setMenuBarComponent", new IRunnable(){

                public Object run() {
                    Menu menu = shell.getMenuBar();
                    MenuCAPs.this.setComponent(menu);
                    return null;
                }
            });
        }
        return super.getComponent();
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    public void selectMenuItem(String namePath, String operator) {
        String[] pathItems = MenuUtilBase.splitPath((String)namePath);
        if (pathItems.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        try {
            Rectangle nullBounds;
            Rectangle bounds;
            MenuItemAdapter itemAdapter = (MenuItemAdapter)this.navigateToMenuItem(this.getAndCheckMenu(), pathItems, operator);
            if (itemAdapter.getRealComponent() == null) {
                this.throwMenuItemNotFound();
            }
            if ((bounds = itemAdapter.getMenuItemBounds()).equals((Object)(nullBounds = new Rectangle(0, 0, 0, 0)))) {
                itemAdapter.selectProgramatically();
            } else {
                itemAdapter.selectMenuItem();
            }
        }
        catch (StepExecutionException e) {
            block8: {
                try {
                    this.closeMenu(this.getAndCheckMenu(), pathItems, operator);
                }
                catch (StepExecutionException stepExecutionException) {
                    if (!MenuCAPs.getLog().isInfoEnabled()) break block8;
                    MenuCAPs.getLog().info((Object)"Tried to close a disabled or already closed menu.");
                }
            }
            throw e;
        }
    }

    public void selectMenuItemByIndexpath(String indexPath) {
        int[] indexItems = MenuUtilBase.splitIndexPath((String)indexPath);
        if (indexItems.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        try {
            Rectangle nullBounds;
            Rectangle bounds;
            MenuItemAdapter menuItemAdapter = (MenuItemAdapter)this.navigateToMenuItem(this.getAndCheckMenu(), indexItems);
            if (menuItemAdapter.getRealComponent() == null) {
                this.throwMenuItemNotFound();
            }
            if ((bounds = menuItemAdapter.getMenuItemBounds()).equals((Object)(nullBounds = new Rectangle(0, 0, 0, 0)))) {
                menuItemAdapter.selectProgramatically();
            } else {
                menuItemAdapter.selectMenuItem();
            }
        }
        catch (StepExecutionException stepExecutionException) {
            block8: {
                try {
                    this.closeMenu(this.getAndCheckMenu(), indexItems);
                }
                catch (StepExecutionException stepExecutionException2) {
                    if (!MenuCAPs.getLog().isInfoEnabled()) break block8;
                    MenuCAPs.getLog().info((Object)"Tried to close a disabled or already closed menu.");
                }
            }
            this.throwMenuItemNotFound();
        }
    }

    protected IMenuAdapter getAndCheckMenu() throws StepExecutionException {
        if (((RobotSwtImpl)this.getRobot()).getActiveWindow() == null) {
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoActiveWindow"), EventFactory.createActionError((String)"TestErrorEvent.NoActiveWindow"));
        }
        return super.getAndCheckMenu();
    }

    private void throwMenuItemNotFound() {
        throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
    }

    protected IMenuItemAdapter newMenuItemAdapter(Object component) {
        return new MenuItemAdapter(component);
    }

    protected void closeMenu(IMenuAdapter menuBar, int[] path) {
        Validate.notNull((Object)this.getMenu(menuBar));
        this.closeMenu(menuBar, path.length);
    }

    protected void closeMenu(IMenuAdapter menuBar, String[] textPath, String operator) {
        Validate.notNull((Object)this.getMenu(menuBar));
        this.closeMenu(menuBar, textPath.length);
    }

    private void closeMenu(final IMenuAdapter menuBar, int maxCascadeLength) {
        final MenuHiddenListener menuListener = new MenuHiddenListener();
        this.getMenu(menuBar).getDisplay().syncExec(new Runnable(){

            public void run() {
                MenuCAPs.this.getMenu(menuBar).addMenuListener((MenuListener)menuListener);
            }
        });
        int i = 0;
        while (i < maxCascadeLength && !menuListener.isMenuHidden()) {
            this.getRobot().keyType((Object)this.getMenu(menuBar), 27);
            ++i;
        }
    }

    private Menu getMenu(IMenuAdapter menu) {
        return (Menu)menu.getRealComponent();
    }

    public boolean isContextMenu() {
        return this.m_isCM;
    }

    public void setContextMenu(boolean isCM) {
        this.m_isCM = isCM;
    }

    private static final class MenuHiddenListener
    implements MenuListener {
        private boolean m_eventOccurred = false;

        private MenuHiddenListener() {
        }

        public void menuHidden(MenuEvent e) {
            this.m_eventOccurred = true;
            ((Menu)e.widget).removeMenuListener((MenuListener)this);
        }

        public void menuShown(MenuEvent e) {
        }

        public boolean isMenuHidden() {
            return this.m_eventOccurred;
        }
    }
}

