/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.caps;

import java.util.StringTokenizer;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.caps.AbstractTreeCAPs;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StandardDepthFirstTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.swt.caps.CAPUtil;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swt.implclasses.TableTreeOperationContext;
import org.eclipse.jubula.rc.swt.implclasses.TreeOperationContext;
import org.eclipse.jubula.rc.swt.implclasses.tree.ToggleCheckboxOperation;
import org.eclipse.jubula.rc.swt.implclasses.tree.VerifyCheckboxOperation;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeCAPs
extends AbstractTreeCAPs {
    protected IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    private Tree getTree() {
        return (Tree)this.getComponent().getRealComponent();
    }

    public void gdVerifyTextAtMousePosition(String pattern, String operator) {
        TreeItem itemAtMousePosition = (TreeItem)this.getNodeAtMousePosition();
        int column = this.getMouseColumn();
        TableTreeOperationContext context = column != -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), column) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        Verifier.match((String)context.getRenderedText(itemAtMousePosition), (String)pattern, (String)operator);
    }

    public void gdDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treePath, String operator) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
        this.gdSelect(pathType, preAscend, treePath, operator, 0, 1, "no");
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByTextPath(String pathType, int preAscend, String treePath, String operator, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("gdDropByTextPath - perform drag", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    return null;
                }
            });
            Event wakeEvent = new Event();
            wakeEvent.type = 5;
            this.getTree().getDisplay().post(wakeEvent);
            this.waitForDisplayUpdate();
            this.gdSelect(pathType, preAscend, treePath, operator, 0, 1, "no");
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
            TreeCAPs.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        robot.mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
    }

    public void gdDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String indexPath) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
        this.gdSelectByIndices(pathType, preAscend, indexPath, 0, 1, "no");
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByIndexPath(String pathType, int preAscend, String indexPath, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("gdDropByIndexPath - perform drag", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    return null;
                }
            });
            Event wakeEvent = new Event();
            wakeEvent.type = 5;
            this.getTree().getDisplay().post(wakeEvent);
            this.waitForDisplayUpdate();
            this.gdSelectByIndices(pathType, preAscend, indexPath, 0, 1, "no");
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
            TreeCAPs.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        robot.mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        SwtUtils.waitForDisplayIdle(this.getTree().getDisplay());
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return (TreeItem)this.getEventThreadQueuer().invokeAndWait("getItemAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                Point mousePos = SwtUtils.convertToSwtPoint(TreeCAPs.this.getRobot().getCurrentMousePosition());
                ItemAtPointTreeNodeOperation op = new ItemAtPointTreeNodeOperation(mousePos, SwtUtils.getWidgetBounds((Widget)TreeCAPs.this.getTree()));
                TreeItem topItem = TreeCAPs.this.getTree().getTopItem();
                if (topItem != null) {
                    StandardDepthFirstTraverser traverser = new StandardDepthFirstTraverser((AbstractTreeOperationContext)new TreeOperationContext(TreeCAPs.this.getEventThreadQueuer(), TreeCAPs.this.getRobot(), TreeCAPs.this.getTree()));
                    traverser.traversePath((TreeNodeOperation)op, (Object)topItem);
                    if (op.getItemAtPoint() != null) {
                        return op.getItemAtPoint();
                    }
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    private int getMouseColumn() {
        final Tree treeTable = this.getTree();
        int column = (Integer)this.getEventThreadQueuer().invokeAndWait("getMouseColumn", new IRunnable(){

            public Object run() throws StepExecutionException {
                Point cursorPosition;
                Rectangle treeTableBounds = SwtUtils.getWidgetBounds((Widget)TreeCAPs.this.getTree());
                boolean isCursorInBounds = treeTableBounds.contains(cursorPosition = treeTable.getDisplay().getCursorLocation());
                if (isCursorInBounds) {
                    int horizontalScrollOffset = 0;
                    ScrollBar horizontalBar = TreeCAPs.this.getTree().getHorizontalBar();
                    if (horizontalBar != null && !horizontalBar.isDisposed()) {
                        horizontalScrollOffset = horizontalBar.getSelection();
                    }
                    Rectangle columnBounds = new Rectangle(treeTableBounds.x - horizontalScrollOffset, treeTableBounds.y, 0, treeTableBounds.height);
                    int i = 0;
                    while (i < treeTable.getColumnCount()) {
                        columnBounds.x += columnBounds.width;
                        columnBounds.width = treeTable.getColumn(i).getWidth();
                        if (columnBounds.contains(cursorPosition)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                }
                return new Integer(-1);
            }
        });
        return column;
    }

    public void gdMove(String direction, int distance, int clickCount) throws StepExecutionException {
        if (this.getColumnCount() > 0) {
            int mouseColumn = this.getMouseColumn();
            TableTreeOperationContext context = mouseColumn == -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree()) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), mouseColumn);
            TreeItem selectedNode = (TreeItem)this.getSelectedNode(context);
            SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
            TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
            if ("up".equalsIgnoreCase(direction)) {
                ParentTraverser traverser = new ParentTraverser((AbstractTreeOperationContext)context, distance, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if ("down".equalsIgnoreCase(direction)) {
                ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
                ChildTraverser expandTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance - 1);
                expandTraverser.traversePath((TreeNodeOperation)expandOp, (Object)selectedNode);
                ChildTraverser selectTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance, constraint);
                selectTraverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if ("next".equalsIgnoreCase(direction)) {
                SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, true, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            } else if ("previous".equalsIgnoreCase(direction)) {
                SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, false, constraint);
                traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
            }
        } else {
            super.gdMove(direction, distance, clickCount);
        }
    }

    private int getColumnCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(TreeCAPs.this.getTree().getColumnCount());
            }
        });
    }

    public void gdSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void gdSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void gdVerifySelectedValue(String pattern, int column) throws StepExecutionException {
        this.gdVerifySelectedValue(pattern, "equals", column);
    }

    public void gdVerifySelectedValue(String pattern, String operator, int column) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        TableTreeOperationContext context = new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), implCol);
        String text = context.getNodeTextAtColumn(context.getSelectedNode());
        Verifier.match((String)text, (String)pattern, (String)operator);
    }

    private void checkColumnIndex(int index) throws StepExecutionException {
        int numColumns = (Integer)this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", new IRunnable(){

            public Object run() {
                return new Integer(TreeCAPs.this.getTree().getColumnCount());
            }
        });
        if ((index < 0 || index >= numColumns) && index != 0) {
            throw new StepExecutionException("Invalid column: " + IndexConverter.toUserIndex((int)index), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co, int column) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selectOp, column);
    }

    private void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation, int column) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TableTreeOperationContext context = new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), column);
        TreeItem startNode = (TreeItem)this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath, new TreeNodeOperationConstraint());
        traverser.traversePath(operation, (Object)startNode);
    }

    public String gdStoreValueAtMousePosition(String variable) {
        TreeItem itemAtMousePosition = (TreeItem)this.getNodeAtMousePosition();
        int column = this.getMouseColumn();
        TableTreeOperationContext context = column != -1 ? new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree(), column) : new TableTreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        return context.getRenderedText(itemAtMousePosition);
    }

    public void gdToggleCheckbox(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator));
    }

    public void gdToggleCheckboxByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)));
    }

    public void gdVerifyCheckbox(String pathType, int preAscend, String treePath, String operator, boolean checked) throws StepExecutionException {
        this.verifyCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), checked);
    }

    public void gdVerifyCheckboxByIndices(String pathType, int preAscend, String indexPath, boolean checked) throws StepExecutionException {
        this.verifyCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), checked);
    }

    public void gdVerifySelectedCheckbox(boolean checked) throws StepExecutionException {
        Boolean checkSelected = (Boolean)this.getEventThreadQueuer().invokeAndWait("gdVerifyTreeCheckbox", new IRunnable(){

            public Object run() {
                TreeItem node = TreeCAPs.this.getTree().getSelection()[0];
                return new Boolean(node.getChecked());
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkSelected);
    }

    private void verifyCheckBoxByPath(String pathType, int preAscend, INodePath objectPath, boolean checked) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        VerifyCheckboxOperation checkboxOp = new VerifyCheckboxOperation(checked, context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)checkboxOp);
    }

    private void toggleCheckBoxByPath(String pathType, int preAscend, INodePath objectPath) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.getTree());
        ToggleCheckboxOperation selCheckboxOp = new ToggleCheckboxOperation(context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selCheckboxOp);
    }

    public void gdClick(int count, int button) {
        super.gdClick(count, button);
    }

    protected void waitForDisplayUpdate() {
        ((Control)this.getComponent().getRealComponent()).getDisplay().syncExec(new Runnable(){

            public void run() {
                ((Control)TreeCAPs.this.getComponent().getRealComponent()).getDisplay().update();
            }
        });
    }

    public void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    private static final class ItemAtPointTreeNodeOperation
    extends AbstractTreeNodeOperation {
        private TreeItem m_itemAtPoint;
        private Point m_absPoint;
        private Rectangle m_absTreeBounds;

        public ItemAtPointTreeNodeOperation(Point absPoint, Rectangle absTreeBounds) {
            this.m_absPoint = absPoint;
            this.m_absTreeBounds = absTreeBounds;
        }

        public boolean operate(Object node) throws StepExecutionException {
            if (this.getContext().isVisible(node) && node instanceof TreeItem) {
                TreeItem currentItem = (TreeItem)node;
                Rectangle absItemBounds = SwtUtils.getBounds(currentItem);
                absItemBounds.x = this.m_absTreeBounds.x;
                absItemBounds.width = this.m_absTreeBounds.width;
                if (SwtUtils.containsInclusive(absItemBounds, this.m_absPoint)) {
                    this.m_itemAtPoint = currentItem;
                    return false;
                }
            }
            return true;
        }

        public TreeItem getItemAtPoint() {
            return this.m_itemAtPoint;
        }
    }
}

