/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.implclasses.AbstractComboBoxHelper;
import org.eclipse.jubula.rc.swt.implclasses.ComboImplClass;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class ComboBoxHelper
extends AbstractComboBoxHelper {
    public static final int CLICK_COUNT_FOR_SELECTING_ALL = 1;
    private static AutServerLogger log;
    private IRobot m_robot;
    private IEventThreadQueuer m_eventThreadQueuer;
    private ComboImplClass m_implClass;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public ComboBoxHelper(ComboImplClass implClass) {
        Validate.notNull((Object)implClass, (String)"The ComboBox implementation class must not be null");
        this.m_robot = implClass.getRobot();
        this.m_eventThreadQueuer = implClass.getEventThreadQueuer();
        this.m_implClass = implClass;
    }

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        Validate.notNull((Object)text, (String)"text must not be null");
        Control editor = this.m_implClass.getComponent();
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        if (replace) {
            this.selectAll();
        } else {
            this.selectNone();
        }
        this.m_robot.type((Object)editor, text);
        this.m_robot.keyType(null, 0x1000050);
    }

    protected Rectangle findArrowIconArea() {
        final Control editor = this.m_implClass.getComponent();
        Rectangle r = null;
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        r = (Rectangle)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "findArrowIconArea", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getRelativeWidgetBounds((Widget)editor, editor);
            }
        });
        r.x += r.width - r.height;
        r.width = r.height;
        return r;
    }

    protected void toggleDropdownList() {
        Combo comboBox = (Combo)this.m_implClass.getComponent();
        Rectangle r = this.findArrowIconArea();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Toggling dropdown by clicking on rectangle: " + r + "within component: " + comboBox));
        }
        this.m_robot.click((Object)comboBox, (Object)r, ClickOptions.create().setScrollToVisible(false).setConfirmClick(false));
    }

    public int getSelectedIndex() {
        final Combo combo = (Combo)this.m_implClass.getComponent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int selectedIndex = (Integer)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "getSelectedIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(combo.getSelectionIndex());
            }
        });
        return selectedIndex;
    }

    protected boolean isComboEnabled() {
        final Combo combo = (Combo)this.m_implClass.getComponent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean isEnabled = (Boolean)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isComboEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return combo.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    protected void selectImpl(int index) {
        Combo combo = (Combo)this.m_implClass.getComponent();
        this.m_robot.keyType((Object)combo, 27);
        this.selectComboIndex(index);
    }

    private void selectComboIndex(final int index) {
        final Combo combo = (Combo)this.m_implClass.getComponent();
        this.m_eventThreadQueuer.invokeAndWait("selectComboIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                combo.select(index);
                Event selectionEvent = new Event();
                selectionEvent.type = 13;
                selectionEvent.widget = combo;
                combo.notifyListeners(13, selectionEvent);
                return null;
            }
        });
    }

    public void selectAll() {
        this.click(new Integer(1));
        if (EnvironmentUtils.isMacOS()) {
            this.m_eventThreadQueuer.invokeAndWait("combo.selectAll", new IRunnable(){

                public Object run() {
                    Combo comboBox = (Combo)ComboBoxHelper.this.m_implClass.getComponent();
                    int textLength = StringUtils.length((String)comboBox.getText());
                    comboBox.setSelection(new Point(0, textLength));
                    return null;
                }
            });
        } else {
            this.m_robot.keyStroke(String.valueOf(this.m_robot.getSystemModifierSpec()) + " A");
        }
    }

    public void selectNone() {
        this.click(new Integer(3));
    }

    public void click(Integer count) {
        Control editor = this.m_implClass.getComponent();
        if (editor == null) {
            throw new StepExecutionException("no editor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        this.m_robot.click((Object)editor, null, ClickOptions.create().setClickCount(count.intValue()));
    }

    public boolean isEditable() {
        return this.isComboEditable();
    }

    public String getSelectedValue() {
        Object o = this.m_eventThreadQueuer.invokeAndWait("getSelectedItem", new IRunnable(){

            public Object run() {
                Combo comboBox = (Combo)ComboBoxHelper.this.m_implClass.getComponent();
                return comboBox.getText();
            }
        });
        return o != null ? o.toString() : null;
    }

    private boolean isComboEditable() {
        Integer comboStyle;
        final Combo combo = (Combo)this.m_implClass.getComponent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ((comboStyle = (Integer)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isComboEditable", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(combo.getStyle());
            }
        })) & 8) == 0;
    }

    protected int getItemCount() {
        final Combo combo = (Combo)this.m_implClass.getComponent();
        return (Integer)this.m_implClass.getEventThreadQueuer().invokeAndWait("getItemCount", new IRunnable(){

            public Object run() {
                return new Integer(combo.getItemCount());
            }
        });
    }

    protected String getItem(final int index) {
        final Combo combo = (Combo)this.m_implClass.getComponent();
        return (String)this.m_implClass.getEventThreadQueuer().invokeAndWait("getItem", new IRunnable(){

            public Object run() {
                return combo.getItem(index);
            }
        });
    }

    protected void openDropdownList() {
        this.toggleDropdownList();
    }
}

