/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.ListSelectionVerifier;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.jubula.rc.swt.implclasses.ListHelper;
import org.eclipse.jubula.rc.swt.interfaces.IList;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class ListImplClass
extends AbstractControlImplClass
implements IList {
    private List m_list;
    private ListHelper m_listHelper;

    public void setComponent(Object graphicsComponent) {
        this.m_list = (List)graphicsComponent;
        this.m_listHelper = new ListHelper(this);
    }

    public Control getComponent() {
        return this.m_list;
    }

    private String[] split(String values, String separator) {
        String[] list = StringParsing.splitToArray((String)values, (char)(separator == null || separator.length() == 0 ? (char)',' : separator.charAt(0)), (char)'\\');
        return StringUtils.stripAll((String[])list);
    }

    private int[] parseIndices(String indexList) {
        String[] list = StringParsing.splitToArray((String)indexList, (char)',', (char)'\\');
        int[] indices = new int[list.length];
        int i = 0;
        while (i < list.length) {
            indices[i] = IndexConverter.intValue((String)list[i]);
            ++i;
        }
        return indices;
    }

    private int[] getCheckedSelectedIndices() throws StepExecutionException {
        int[] selected = this.m_listHelper.getSelectedIndices(this.m_list);
        if (selected.length == 0) {
            throw new StepExecutionException("No list element selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return selected;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectIndices(int[] indices, ClickOptions co, boolean isExtendSelection) {
        block9: {
            if (indices.length > 0) {
                try {
                    if (isExtendSelection) {
                        this.getRobot().keyPress(null, SWT.MOD1);
                    }
                    this.m_listHelper.clickOnIndex(this.m_list, new Integer(indices[0]), co);
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    if (!isExtendSelection) throw throwable;
                    this.getRobot().keyRelease(null, SWT.MOD1);
                    throw throwable;
                }
                {
                    Object var4_8 = null;
                    if (!isExtendSelection) break block9;
                }
                this.getRobot().keyRelease(null, SWT.MOD1);
            }
        }
        if (indices.length <= 1) return;
        try {
            this.getRobot().keyPress(null, SWT.MOD1);
            int i = 1;
            while (i < indices.length) {
                this.m_listHelper.clickOnIndex(this.m_list, new Integer(indices[i]), co);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRobot().keyRelease(null, SWT.MOD1);
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        this.getRobot().keyRelease(null, SWT.MOD1);
    }

    public void gdVerifySelectedIndex(String index, boolean expectSelected) {
        int implIndex;
        int[] selected = this.getCheckedSelectedIndices();
        boolean isSelected = ArrayUtils.contains((int[])selected, (int)(implIndex = IndexConverter.toImplementationIndex((int)Integer.parseInt(index))));
        if (expectSelected != isSelected) {
            throw new StepExecutionException("Selection check failed for index: " + index, EventFactory.createVerifyFailed((String)String.valueOf(expectSelected), (String)String.valueOf(isSelected)));
        }
    }

    public void gdVerifySelectedValue(String valueList) {
        this.gdVerifySelectedValue(valueList, "equals", true);
    }

    public void gdVerifySelectedValue(String value, String operator, boolean isSelected) {
        String[] current = this.m_listHelper.getSelectedValues(this.m_list);
        ListSelectionVerifier listSelVerifier = new ListSelectionVerifier();
        int i = 0;
        while (i < current.length) {
            listSelVerifier.addItem(i, current[i], true);
            ++i;
        }
        listSelVerifier.verifySelection(value, operator, isSelected);
    }

    public void gdVerifyText(String text, String operator) {
        String[] selected = this.m_listHelper.getSelectedValues(this.m_list);
        int selCount = selected.length;
        if (selCount < 1) {
            throw new StepExecutionException("No selection", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        int i = 0;
        while (i < selCount) {
            Verifier.match((String)selected[i], (String)text, (String)operator);
            ++i;
        }
    }

    public void gdSelectIndex(String indexList, String extendSelection, int button) {
        boolean isExtendSelection = extendSelection.equals("yes");
        this.selectIndices(IndexConverter.toImplementationIndices((int[])this.parseIndices(indexList)), ClickOptions.create().setClickCount(1).setMouseButton(button), isExtendSelection);
    }

    public void gdSelectValue(String valueList, String operator, String searchType, String extendSelection, int button) {
        boolean isExtendSelection = extendSelection.equals("yes");
        this.selectValue(valueList, String.valueOf(','), operator, searchType, ClickOptions.create().setClickCount(1).setMouseButton(button), isExtendSelection);
    }

    public void gdSelectValue(String valueList, String separator, String operator, String searchType, int clickCount, boolean isExtendSelection) {
        this.selectValue(valueList, separator, operator, searchType, ClickOptions.create().setClickCount(clickCount), isExtendSelection);
    }

    private void selectValue(String valueList, String separator, String operator, String searchType, ClickOptions co, boolean isExtendSelection) {
        String[] values = this.parseValues(valueList, separator);
        this.selectValues(operator, searchType, co, values, isExtendSelection);
    }

    private void selectValues(String operator, String searchType, ClickOptions co, String[] values, boolean isExtendSelection) {
        Integer[] indices = this.m_listHelper.findIndicesOfValues(this.m_list, values, operator, searchType);
        if (!operator.equals("not equals") && indices.length < values.length) {
            throw new StepExecutionException("One or more values not found of set: " + Arrays.asList(values).toString(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), co, isExtendSelection);
    }

    private String[] parseValues(String valueList, String separator) {
        String[] values = null;
        values = "".equals(valueList) ? new String[]{""} : this.split(valueList, separator);
        return values;
    }

    public void gdVerifyContainsValue(String value) {
        Verifier.equals((boolean)true, (boolean)this.m_listHelper.containsValue(this.m_list, value));
    }

    public void gdVerifyContainsValue(String value, String operator, boolean exists) {
        Verifier.equals((boolean)exists, (boolean)this.m_listHelper.containsValue(this.m_list, value, operator));
    }

    public String gdReadValue(String variable) {
        String[] selected = this.m_listHelper.getSelectedValues(this.m_list);
        if (selected.length > 0) {
            return selected[0];
        }
        throw new StepExecutionException("No list item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
    }

    public void gdDragValue(int mouseButton, String modifier, String value, String operator, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        Integer[] indices = this.m_listHelper.findIndicesOfValues(this.m_list, new String[]{value}, operator, searchType);
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropValue(final String value, final String operator, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    ListImplClass.this.shakeMouse();
                    Integer[] indices = ListImplClass.this.m_listHelper.findIndicesOfValues(ListImplClass.this.m_list, new String[]{value}, operator, searchType);
                    ListImplClass.this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0), false);
                    return null;
                }
            });
            ListImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragIndex(int mouseButton, String modifier, int index) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.selectIndices(new int[]{IndexConverter.toImplementationIndex((int)index)}, ClickOptions.create().setClickCount(0), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropIndex(final int index, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropIndex", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    ListImplClass.this.shakeMouse();
                    int implIndex = IndexConverter.toImplementationIndex((int)index);
                    ListImplClass.this.selectIndices(new int[]{implIndex}, ClickOptions.create().setClickCount(0), false);
                    return null;
                }
            });
            ListImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }
}

