/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.jubula.rc.swt.interfaces.ITable;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableImplClass
extends AbstractControlImplClass
implements ITable {
    private static AutServerLogger log;
    private Table m_table;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.TableImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public void setComponent(Object graphicsComponent) {
        this.m_table = (Table)graphicsComponent;
    }

    public Control getComponent() {
        return this.m_table;
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    private void checkRowColBounds(int row, int column) throws StepExecutionException {
        this.checkBounds(row, this.m_table.getItemCount());
        int colCount = this.m_table.getColumnCount();
        if (colCount > 0 || column > 0) {
            this.checkBounds(column, colCount);
        }
    }

    private Rectangle getCellBounds(final int row, final int col) {
        Rectangle cellBounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("evaluateCellBounds", new IRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                TableImplClass.this.checkRowColBounds(row, col);
                TableItem ti = TableImplClass.this.m_table.getItem(row);
                int column = TableImplClass.this.m_table.getColumnCount() > 0 || col > 0 ? col : 0;
                Rectangle r = ti.getBounds(column);
                String text = ti.getText(column);
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)TableImplClass.this.m_table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        gc.dispose();
                        throw throwable;
                    }
                    {
                        Object var9_11 = null;
                    }
                    gc.dispose();
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TableColumn tc = TableImplClass.this.m_table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
        });
        return cellBounds;
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        Cell cell = null;
        java.awt.Point awtMousePos = this.getRobot().getCurrentMousePosition();
        Point mousePos = new Point(awtMousePos.x, awtMousePos.y);
        int itemCount = this.m_table.getItemCount();
        int rowCount = this.m_table.getTopIndex();
        while (rowCount < itemCount) {
            if (cell != null) break;
            int columnCount = this.m_table.getColumnCount();
            if (columnCount > 0) {
                int col = 0;
                while (col < columnCount) {
                    Rectangle itemBounds = this.getCellBounds(rowCount, col);
                    Point absItemBounds = this.m_table.toDisplay(itemBounds.x, itemBounds.y);
                    Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                    if (absRect.contains(mousePos)) {
                        cell = new Cell(rowCount, col);
                        break;
                    }
                    ++col;
                }
            } else {
                Rectangle itemBounds = this.getCellBounds(rowCount, 0);
                Point absItemBounds = this.m_table.toDisplay(itemBounds.x, itemBounds.y);
                Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                if (absRect.contains(mousePos)) {
                    cell = new Cell(rowCount, 0);
                }
            }
            ++rowCount;
        }
        if (cell == null) {
            throw new StepExecutionException("No cell under mouse position found!", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return cell;
    }

    private Cell getSelectedCell() throws StepExecutionException {
        return TableSelectionTracker.getInstance().getSelectedCell(this.m_table);
    }

    private boolean isMouseOverCell() {
        try {
            this.invokeGetCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            return false;
        }
        return true;
    }

    private boolean isMouseOnHeader() {
        Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", new IRunnable(){

            public Object run() {
                return new Boolean(TableImplClass.this.m_table.getHeaderVisible());
            }
        });
        if (!isVisible.booleanValue()) {
            return false;
        }
        Boolean isOnHeader = new Boolean(false);
        isOnHeader = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", new IRunnable(){

            public Object run() {
                java.awt.Point awtMousePos = TableImplClass.this.getRobot().getCurrentMousePosition();
                Point mousePos = new Point(awtMousePos.x, awtMousePos.y);
                int j = 0;
                while (j < TableImplClass.this.m_table.getColumnCount()) {
                    Rectangle constraints = TableImplClass.this.getHeaderBounds(j);
                    Rectangle bounds = SwtUtils.getWidgetBounds((Widget)TableImplClass.this.m_table);
                    if (constraints != null) {
                        Point convertedLocation = TableImplClass.this.getConvertedLocation(constraints);
                        bounds.x = convertedLocation.x;
                        bounds.y = convertedLocation.y;
                        bounds.height = constraints.height;
                        bounds.width = constraints.width;
                    }
                    if (bounds.contains(mousePos)) {
                        return new Boolean(true);
                    }
                    ++j;
                }
                return new Boolean(false);
            }
        });
        return isOnHeader;
    }

    private Point getConvertedLocation(final Rectangle constraints) {
        Point convertedLocation = (Point)this.getEventThreadQueuer().invokeAndWait("toDisplay", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableImplClass.this.m_table.toDisplay(constraints.x, constraints.y);
            }
        });
        return convertedLocation;
    }

    private boolean isCellSelection() {
        TableItem[] selItems = (TableItem[])this.getEventThreadQueuer().invokeAndWait("isCellSelection", new IRunnable(){

            public Object run() {
                return TableImplClass.this.m_table.getSelection();
            }
        });
        return selItems.length > 0;
    }

    private Cell invokeGetSelectedCell() throws StepExecutionException {
        return (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", new IRunnable(){

            public Object run() {
                return TableImplClass.this.getSelectedCell();
            }
        });
    }

    private Cell invokeGetCellAtMousePosition() throws StepExecutionException {
        return (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition()", new IRunnable(){

            public Object run() {
                return TableImplClass.this.getCellAtMousePosition();
            }
        });
    }

    private Rectangle getHeaderBounds(final int col) {
        Rectangle cellBounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                Rectangle rect = TableImplClass.this.m_table.getItem(0).getBounds(col);
                rect.y = ((TableImplClass)TableImplClass.this).m_table.getClientArea().y;
                return rect;
            }
        });
        return cellBounds;
    }

    private Rectangle invokeScrollCellToVisible(final int row, final int col) throws StepExecutionException {
        this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", new IRunnable(){

            public Object run() {
                if (TableImplClass.this.m_table.getColumnCount() > 0 || col > 0) {
                    TableImplClass.this.m_table.showColumn(TableImplClass.this.m_table.getColumn(col));
                }
                TableImplClass.this.m_table.showItem(TableImplClass.this.m_table.getItem(row));
                return null;
            }
        });
        final Rectangle cellBoundsRelativeToParent = this.getCellBounds(row, col);
        this.getEventThreadQueuer().invokeAndWait("getCellBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = TableImplClass.this.getComponent().getDisplay().map(TableImplClass.this.getComponent(), (Control)TableImplClass.this.getComponent().getParent(), new Point(cellBoundsRelativeToParent.x, cellBoundsRelativeToParent.y));
                cellBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                cellBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getEventThreadQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                TableImplClass.this.getComponent().getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)cellBoundsRelativeToParent);
        return this.getVisibleBounds(this.getCellBounds(row, col));
    }

    private Rectangle getVisibleBounds(Rectangle cellBounds) {
        Rectangle r = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getVisibleCellBounds: " + cellBounds, new IRunnable(){

            public Object run() {
                return TableImplClass.this.m_table.getClientArea();
            }
        });
        Rectangle visibleTableBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleCellBounds = visibleTableBounds.intersection(cellBounds);
        return visibleCellBounds;
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getSelectedCell().getCol() + 1;
        }
        return startingIndex;
    }

    private int getStartingRowIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getSelectedCell().getRow() + 1;
        }
        return startingIndex;
    }

    private void gdSelectCell(String row, String rowOperator, String col, String colOperator, ClickOptions co, String extendSelection) {
        this.gdSelectCell(row, rowOperator, col, colOperator, co.getClickCount(), 50, "Percent", 50, "Percent", extendSelection, co.getMouseButton());
    }

    private void gdSelectCell(int row, int col, int clickCount, String extendSelection) {
        this.gdSelectCell(row, col, clickCount, 50, "Percent", 50, "Percent", extendSelection);
    }

    /*
     * Exception decompiling
     */
    public void gdSelectCell(String row, String rowOperator, String col, String colOperator, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection, int button) throws StepExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 221->225)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void gdSelectCell(int row, int col, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 187->191)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void gdMove(String direction, int cellCount, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = null;
        try {
            cell = this.invokeGetCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            cell = this.invokeGetSelectedCell();
        }
        int newCol = cell.getCol();
        int newRow = cell.getRow();
        if ("up".equalsIgnoreCase(direction)) {
            newRow -= cellCount;
        } else if ("down".equalsIgnoreCase(direction)) {
            newRow += cellCount;
        } else if ("left".equalsIgnoreCase(direction)) {
            newCol -= cellCount;
        } else if ("right".equalsIgnoreCase(direction)) {
            newCol += cellCount;
        }
        newRow = IndexConverter.toUserIndex((int)newRow);
        newCol = IndexConverter.toUserIndex((int)newCol);
        this.gdSelectCell(newRow, newCol, clickCount, xPos, xUnits, yPos, yUnits, extendSelection);
    }

    public void gdSelectRow(int row, String extendSelection) throws StepExecutionException {
        this.gdSelectCell(row, IndexConverter.toUserIndex((int)0), 1, extendSelection);
    }

    public void gdVerifyText(String text, String operator, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        String current;
        final int implRow = this.getRowFromString(row, rowOperator);
        final int implCol = this.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            current = (String)this.getEventThreadQueuer().invokeAndWait("gdVerifyText", new IRunnable(){

                public Object run() {
                    return TableImplClass.this.m_table.getColumn(implCol).getText();
                }
            });
        } else {
            this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

                public Object run() {
                    TableImplClass.this.checkRowColBounds(implRow, implCol);
                    return null;
                }
            });
            this.invokeScrollCellToVisible(implRow, implCol);
            current = this.getCellText(implRow, implCol);
        }
        Verifier.match((String)current, (String)text, (String)operator);
    }

    public void gdVerifyText(String text, String operator, int row, int col) throws StepExecutionException {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

            public Object run() {
                TableImplClass.this.checkRowColBounds(implRow, implCol);
                return null;
            }
        });
        this.invokeScrollCellToVisible(implRow, implCol);
        String current = this.getCellText(implRow, implCol);
        Verifier.match((String)current, (String)text, (String)operator);
    }

    protected String getCellText(final int row, final int col) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getCellText", new IRunnable(){

            public Object run() {
                String value = TableImplClass.this.m_table.getItem(row).getText(col);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting cell text:");
                    log.debug((Object)("Row, col: " + row + ", " + col));
                    log.debug((Object)("Value: " + value));
                }
                return value;
            }
        });
        return current;
    }

    public void gdVerifyText(String text, String operator) throws StepExecutionException {
        Cell cell = this.invokeGetSelectedCell();
        this.gdVerifyText(text, operator, IndexConverter.toUserIndex((int)cell.getRow()), IndexConverter.toUserIndex((int)cell.getCol()));
    }

    public void gdVerifyTextAtMousePosition(String text, String operator) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = this.invokeGetCellAtMousePosition();
        this.gdVerifyText(text, operator, IndexConverter.toUserIndex((int)cell.getRow()), IndexConverter.toUserIndex((int)cell.getCol()));
    }

    public void gdVerifyText(String text) throws StepExecutionException {
        this.gdVerifyText(text, "equals");
    }

    public void gdVerifyValueInRow(String row, String rowOperator, final String value, final String operator, final String searchType, boolean exists) throws StepExecutionException {
        final int implRow = this.getRowFromString(row, rowOperator);
        Boolean valueExists = new Boolean(true);
        valueExists = implRow == -1 ? (Boolean)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int k = TableImplClass.this.getStartingColIndex(searchType);
                while (k < TableImplClass.this.m_table.getColumnCount()) {
                    if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getColumn(k).getText(), value, operator)) {
                        return new Boolean(true);
                    }
                    ++k;
                }
                return new Boolean(false);
            }
        }) : (Boolean)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int columnCount = TableImplClass.this.m_table.getColumnCount();
                if (columnCount > 0) {
                    int i = TableImplClass.this.getStartingColIndex(searchType);
                    while (i < columnCount) {
                        if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(implRow).getText(i), value, operator)) {
                            return new Boolean(true);
                        }
                        ++i;
                    }
                } else if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(implRow).getText(), value, operator)) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        });
        Verifier.equals((boolean)exists, (boolean)valueExists);
    }

    public void gdVerifyValueInColumn(String col, String colOperator, final String value, final String operator, final String searchType, boolean exists) throws StepExecutionException {
        final int implCol = this.getColumnFromString(col, colOperator);
        Boolean valueExists = new Boolean(true);
        valueExists = (Boolean)this.getEventThreadQueuer().invokeAndWait("verifyValueInColumn", new IRunnable(){

            public Object run() throws StepExecutionException {
                int itemCount = TableImplClass.this.m_table.getItemCount();
                int i = TableImplClass.this.getStartingRowIndex(searchType);
                while (i < itemCount) {
                    if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(i).getText(implCol), value, operator)) {
                        return new Boolean(true);
                    }
                    ++i;
                }
                if (TableImplClass.this.m_table.getHeaderVisible()) {
                    String header = TableImplClass.this.m_table.getColumn(implCol).getText();
                    if (MatchUtil.getInstance().match(header, value, operator)) {
                        return new Boolean(true);
                    }
                }
                return new Boolean(false);
            }
        });
        Verifier.equals((boolean)exists, (boolean)valueExists);
    }

    private boolean isEditable(Control cellEditor) {
        if (cellEditor == null || cellEditor instanceof TableCursor || cellEditor == this.m_table) {
            return false;
        }
        return (cellEditor.getStyle() & 8) == 0;
    }

    private Control activateEditor(Cell cell) {
        Control editor = this.getTableCellEditor(cell);
        if (!this.invokeIsEditable(editor)) {
            Rectangle cellBounds = this.invokeScrollCellToVisible(cell.getRow(), cell.getCol());
            ClickOptions co = ClickOptions.create().setClickCount(2).setScrollToVisible(false);
            Table clickTarget = editor == null || editor instanceof TableCursor ? this.m_table : editor;
            this.getRobot().click((Object)clickTarget, (Object)cellBounds, co);
            editor = this.getTableCellEditor(cell);
        }
        return editor;
    }

    private boolean invokeIsEditable(final Control cellEditor) {
        boolean isEditable = (Boolean)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", new IRunnable(){

            public Object run() {
                return TableImplClass.this.isEditable(cellEditor) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEditable;
    }

    public void gdVerifyEditable(boolean editable) {
        Cell cell = this.invokeGetSelectedCell();
        Control editor = this.activateEditor(cell);
        Verifier.equals((boolean)editable, (boolean)this.invokeIsEditable(editor));
    }

    private void verifyEditableMousePosition(boolean editable) {
        Cell cell = this.invokeGetCellAtMousePosition();
        Control editor = this.activateEditor(cell);
        Verifier.equals((boolean)editable, (boolean)this.invokeIsEditable(editor));
    }

    public void gdVerifyEditable(boolean editable, String row, String rowOperator, String col, String colOperator) {
        if (this.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), "no");
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditable(boolean editable, int row, int col) {
        this.gdSelectCell(row, col, 1, "no");
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditableSelected(boolean editable) {
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditableMousePosition(boolean editable) {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.verifyEditableMousePosition(editable);
    }

    private Control getTableCellEditor(Cell cell) {
        this.getRobot().click((Object)this.m_table, (Object)this.invokeScrollCellToVisible(cell.getRow(), cell.getCol()), ClickOptions.create().setClickCount(0));
        return SwtUtils.getCursorControl();
    }

    public void gdReplaceText(String text) throws StepExecutionException {
        this.inputText(text, true);
    }

    public void gdReplaceText(String text, String row, String rowOperator, String col, String colOperator) {
        if (this.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), "no");
        this.inputText(text, true);
    }

    public void gdReplaceText(String text, int row, int col) {
        this.gdSelectCell(row, col, 1, "no");
        this.inputText(text, true);
    }

    public void gdInputText(String text) throws StepExecutionException {
        this.inputText(text, false);
    }

    private void inputText(String text, boolean replace) throws StepExecutionException {
        Cell cell = this.invokeGetSelectedCell();
        this.invokeScrollCellToVisible(cell.getRow(), cell.getCol());
        Control editor = this.activateEditor(cell);
        if (!this.invokeIsEditable(editor)) {
            throw new StepExecutionException("Selected table cell " + cell + " is not editable", EventFactory.createActionError((String)"TestErrorEvent.NotEditable"));
        }
        if (replace) {
            this.getRobot().clickAtCurrentPosition((Object)editor, 3, 1);
        } else {
            this.getRobot().clickAtCurrentPosition((Object)editor, 2, 1);
        }
        this.getRobot().type((Object)editor, text);
    }

    public void gdInputText(String text, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        if (this.getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), "no");
        this.gdInputText(text);
    }

    public void gdInputText(String text, int row, int col) throws StepExecutionException {
        this.gdSelectCell(row, col, 1, "no");
        this.gdInputText(text);
    }

    public void gdClick(int count, int button) {
        Cell cell = null;
        if (this.isMouseOverCell()) {
            cell = this.invokeGetCellAtMousePosition();
        } else if (this.isCellSelection()) {
            cell = this.invokeGetSelectedCell();
        }
        if (cell != null) {
            Rectangle cellRect = this.invokeScrollCellToVisible(cell.getRow(), cell.getCol());
            this.getRobot().click((Object)this.m_table, (Object)cellRect, ClickOptions.create().setClickCount(count).setMouseButton(button));
        } else {
            super.gdClick(count, button);
        }
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        int correctedYPos = this.correctYPos(yPos, yUnits);
        super.gdClickDirect(count, button, xPos, xUnits, correctedYPos, yUnits);
    }

    private int correctYPos(int pos, String units) {
        int correctedPos = pos;
        int headerHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getHeaderHeight", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(((Table)TableImplClass.this.getComponent()).getHeaderHeight());
            }
        });
        if ("Pixel".equalsIgnoreCase(units)) {
            correctedPos += headerHeight;
        } else {
            int totalHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getWidgetBounds", new IRunnable(){

                public Object run() throws StepExecutionException {
                    return new Integer(SwtUtils.getWidgetBounds((Widget)TableImplClass.this.getComponent()).height);
                }
            });
            long targetHeight = totalHeight - headerHeight;
            long targetPos = Math.round((double)targetHeight * (double)pos / 100.0);
            double heightPercentage = (double)(targetPos += (long)headerHeight) / (double)totalHeight * 100.0;
            correctedPos = (int)Math.round(heightPercentage);
            if (correctedPos > 100) {
                correctedPos = 100;
            }
        }
        return correctedPos;
    }

    public void gdSelectRowByValue(String col, String colOperator, String value, String regexOp, int clickCount, String extendSelection, String searchType, int button) {
        this.gdSelectRowByValue(col, colOperator, value, regexOp, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    public void gdSelectRowByValue(int col, String value, int clickCount, String regexOp, String extendSelection, String searchType) {
        this.gdSelectRowByValue(col, value, regexOp, extendSelection, searchType, clickCount);
    }

    protected void gdSelectRowByValue(String col, String colOperator, final String value, final String regexOp, String extendSelection, final String searchType, ClickOptions co) {
        final int implCol = this.getColumnFromString(col, colOperator);
        Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("selectRowByValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int itemCount = TableImplClass.this.m_table.getItemCount();
                int i = TableImplClass.this.getStartingRowIndex(searchType);
                while (i < itemCount) {
                    if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(i).getText(implCol), value, regexOp)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                String header = TableImplClass.this.m_table.getColumn(implCol).getText();
                if (MatchUtil.getInstance().match(header, value, regexOp)) {
                    return new Integer(-1);
                }
                return null;
            }
        });
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String userIdxRow = new Integer(IndexConverter.toUserIndex((int)implRow)).toString();
        String userIdxCol = new Integer(IndexConverter.toUserIndex((int)implCol)).toString();
        this.gdSelectCell(userIdxRow, "equals", userIdxCol, colOperator, co, extendSelection);
    }

    protected void gdSelectRowByValue(int col, final String value, final String regexOp, String extendSelection, final String searchType, int clickCount) {
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("selectRowByValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int itemCount = TableImplClass.this.m_table.getItemCount();
                int i = TableImplClass.this.getStartingRowIndex(searchType);
                while (i < itemCount) {
                    if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(i).getText(implCol), value, regexOp)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return null;
            }
        });
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.gdSelectCell(IndexConverter.toUserIndex((int)implRow), IndexConverter.toUserIndex((int)implCol), clickCount, extendSelection);
    }

    public void gdSelectCellByColValue(String row, String rowOperator, String value, String regex, int clickCount, String extendSelection, String searchType, int button) {
        this.gdSelectCellByColValue(row, rowOperator, value, regex, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    public void gdSelectCellByColValue(int row, String value, String regex, int clickCount, String extendSelection, String searchType) {
        this.gdSelectCellByColValue(row, value, regex, extendSelection, searchType, clickCount);
    }

    protected void gdSelectCellByColValue(String row, String rowOperator, final String value, final String regex, String extendSelection, final String searchType, ClickOptions co) {
        final int implRow = this.getRowFromString(row, rowOperator);
        Integer implCol = implRow == -1 ? (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int k = TableImplClass.this.getStartingColIndex(searchType);
                while (k < TableImplClass.this.m_table.getColumnCount()) {
                    if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getColumn(k).getText(), value, regex)) {
                        return new Integer(k);
                    }
                    ++k;
                }
                return null;
            }
        }) : (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int columnCount = TableImplClass.this.m_table.getColumnCount();
                if (columnCount > 0) {
                    int i = TableImplClass.this.getStartingColIndex(searchType);
                    while (i < columnCount) {
                        if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(implRow).getText(i), value, regex)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                } else if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(implRow).getText(), value, regex)) {
                    return new Integer(0);
                }
                return null;
            }
        });
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String usrIdxRowStr = new Integer(IndexConverter.toUserIndex((int)implRow)).toString();
        String usrIdxColStr = new Integer(IndexConverter.toUserIndex((int)implCol)).toString();
        this.gdSelectCell(usrIdxRowStr, rowOperator, usrIdxColStr, "equals", co, extendSelection);
    }

    protected void gdSelectCellByColValue(int row, final String value, final String regex, String extendSelection, final String searchType, int clickCount) {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        Integer implCol = (Integer)this.getEventThreadQueuer().invokeAndWait("selectCellByColValue", new IRunnable(){

            public Object run() throws StepExecutionException {
                int columnCount = TableImplClass.this.m_table.getColumnCount();
                if (columnCount > 0) {
                    int i = TableImplClass.this.getStartingColIndex(searchType);
                    while (i < columnCount) {
                        if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(implRow).getText(i), value, regex)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                } else if (MatchUtil.getInstance().match(TableImplClass.this.m_table.getItem(implRow).getText(), value, regex)) {
                    return new Integer(0);
                }
                return null;
            }
        });
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.gdSelectCell(row, IndexConverter.toUserIndex((int)implCol), clickCount, extendSelection);
    }

    public String gdReadValue(String variable, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        final int implRow = this.getRowFromString(row, rowOperator);
        final int implCol = this.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            this.getEventThreadQueuer().invokeAndWait("gdReadValue", new IRunnable(){

                public Object run() {
                    return TableImplClass.this.m_table.getColumn(implCol).getText();
                }
            });
        }
        this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

            public Object run() {
                TableImplClass.this.checkRowColBounds(implRow, implCol);
                return null;
            }
        });
        this.invokeScrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public String gdReadValue(String variable, int row, int col) throws StepExecutionException {
        final int implRow = IndexConverter.toImplementationIndex((int)row);
        final int implCol = IndexConverter.toImplementationIndex((int)col);
        this.getEventThreadQueuer().invokeAndWait("checkRowColBounds", new IRunnable(){

            public Object run() {
                TableImplClass.this.checkRowColBounds(implRow, implCol);
                return null;
            }
        });
        this.invokeScrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public String gdReadValue(String variable) {
        Cell selectedCell = this.invokeGetSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public void gdDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
    }

    public void gdDragCell(int mouseButton, String modifier, int row, int col, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectCell(row, col, 0, xPos, xUnits, yPos, yUnits, "no");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCell(final String row, final String rowOperator, final String col, final String colOperator, final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) throws StepExecutionException {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropCell", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TableImplClass.this.shakeMouse();
                    TableImplClass.this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
                    return null;
                }
            });
            TableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCell(final int row, final int col, final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) throws StepExecutionException {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropCell", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TableImplClass.this.shakeMouse();
                    TableImplClass.this.gdSelectCell(row, col, 0, xPos, xUnits, yPos, yUnits, "no");
                    return null;
                }
            });
            TableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectRowByValue(col, colOperator, value, regexOp, 1, "no", searchType, 1);
    }

    public void gdDragRowByValue(int mouseButton, String modifier, int col, String value, String regexOp, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectRowByValue(col, value, 1, regexOp, "no", searchType);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropRowByValue(final String col, final String colOperator, final String value, final String regexOp, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropRowByValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TableImplClass.this.shakeMouse();
                    TableImplClass.this.gdSelectRowByValue(col, colOperator, value, regexOp, "no", searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropRowByValue(final int col, final String value, final String regexOp, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropRowByValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TableImplClass.this.shakeMouse();
                    TableImplClass.this.gdSelectRowByValue(col, value, regexOp, "no", searchType, 0);
                    return null;
                }
            });
            TableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
    }

    public void gdDragCellByColValue(int mouseButton, String modifier, int row, String value, String regex, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectCellByColValue(row, value, regex, "no", searchType, 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCellByColValue(final String row, final String rowOperator, final String value, final String regex, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropCellByColValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TableImplClass.this.shakeMouse();
                    TableImplClass.this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCellByColValue(final int row, final String value, final String regex, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropCellByColValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TableImplClass.this.shakeMouse();
                    TableImplClass.this.gdSelectCellByColValue(row, value, regex, "no", searchType, 0);
                    return null;
                }
            });
            TableImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    private int getColumnFromString(final String col, final String operator) {
        int column = -2;
        try {
            int usrIdxCol = Integer.parseInt(col);
            if (usrIdxCol == 0) {
                ++usrIdxCol;
            }
            column = IndexConverter.toImplementationIndex((int)usrIdxCol);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

                    public Object run() {
                        return new Boolean(TableImplClass.this.m_table.getHeaderVisible());
                    }
                });
                if (!isVisible.booleanValue()) {
                    throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                }
                Integer implCol = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

                    public Object run() throws StepExecutionException {
                        int i = 0;
                        while (i < TableImplClass.this.m_table.getColumnCount()) {
                            TableColumn tblCol = TableImplClass.this.m_table.getColumn(i);
                            if (MatchUtil.getInstance().match(tblCol.getText(), col, operator)) {
                                return new Integer(i);
                            }
                            ++i;
                        }
                        return new Integer(-2);
                    }
                });
                column = implCol;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return column;
    }

    private int getRowFromString(final String row, final String operator) {
        int rowInt = -2;
        try {
            Boolean isVisible;
            rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
            if (rowInt == -1 && !(isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

                public Object run() {
                    return new Boolean(TableImplClass.this.m_table.getHeaderVisible());
                }
            })).booleanValue()) {
                throw new StepExecutionException("Header not visible", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

                public Object run() throws StepExecutionException {
                    int i = 0;
                    while (i < TableImplClass.this.m_table.getItemCount()) {
                        String cellTxt = TableImplClass.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                    return new Integer(-2);
                }
            });
            rowInt = implRow;
        }
        return rowInt;
    }

    public String[] getTextArrayFromComponent() {
        TableColumn[] itemArray = this.m_table.getColumns();
        String[] componentTextArray = this.getTextArrayFromItemArray((Item[])itemArray);
        return componentTextArray;
    }

    public void gdPopupByIndexPathAtCell(int row, int column, String indexPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByIndexPathAtSelectedCell(String indexPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByTextPathAtCell(int row, int column, String textPath) {
        this.throwUnsupportedAction();
    }

    public void gdPopupByTextPathAtSelectedCell(String textPath) {
        this.throwUnsupportedAction();
    }

    public void gdSelectCellByRowValue(int column, String cellValue, boolean useRegularExpression) {
        this.throwUnsupportedAction();
    }

    public String gdReadValueAtMousePosition(String variable) {
        Cell cellAtMousePosition = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableImplClass.this.getCellAtMousePosition();
            }
        });
        return this.getCellText(cellAtMousePosition.getRow(), cellAtMousePosition.getCol());
    }
}

