/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.uiadapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.uiadapter.interfaces.IListAdapter;
import org.eclipse.jubula.rc.swt.uiadapter.WidgetAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public class ListAdapter
extends WidgetAdapter
implements IListAdapter {
    private org.eclipse.swt.widgets.List m_list;

    public ListAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_list = (org.eclipse.swt.widgets.List)objectToAdapt;
    }

    public String getText() {
        String[] selected = this.getSelectedValues();
        if (selected.length > 0) {
            return selected[0];
        }
        throw new StepExecutionException("No list item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
    }

    public int[] getSelectedIndices() {
        return (int[])this.getEventThreadQueuer().invokeAndWait("getSelectedIndices", new IRunnable(){

            public Object run() {
                return ListAdapter.this.m_list.getSelectionIndices();
            }
        });
    }

    public void clickOnIndex(Integer i, ClickOptions co) {
        final int iVal = i;
        this.scrollIndexToVisible(iVal);
        Rectangle clickConstraints = (Rectangle)this.getEventThreadQueuer().invokeAndWait("setClickConstraints", new IRunnable(){

            public Object run() throws StepExecutionException {
                Rectangle constraints = new Rectangle(0, 0, 0, 0);
                int displayedItemCount = ListAdapter.this.getDisplayedItemCount();
                int numberBelowTop = 0;
                numberBelowTop = displayedItemCount >= ListAdapter.this.m_list.getItemCount() ? iVal : Math.max(0, iVal - ListAdapter.this.m_list.getItemCount() + displayedItemCount);
                constraints.height = ListAdapter.this.m_list.getItemHeight();
                constraints.width = ((ListAdapter)ListAdapter.this).m_list.getBounds().width;
                constraints.y += numberBelowTop * constraints.height;
                Rectangle actualListBounds = new Rectangle(0, 0, ((ListAdapter)ListAdapter.this).m_list.getClientArea().width, ((ListAdapter)ListAdapter.this).m_list.getClientArea().height);
                return constraints.intersection(actualListBounds);
            }
        });
        this.getRobot().click((Object)this.m_list, (Object)clickConstraints, co.setScrollToVisible(false));
    }

    public String[] getSelectedValues() {
        return (String[])this.getEventThreadQueuer().invokeAndWait("getSelectedValues", new IRunnable(){

            public Object run() {
                return ListAdapter.this.m_list.getSelection();
            }
        });
    }

    public Integer[] findIndicesOfValues(final String[] values, final String operator, final String searchType) {
        List indexList = (List)this.getEventThreadQueuer().invokeAndWait("findIndices", new IRunnable(){

            public Object run() {
                int valuesLength = values.length;
                ArrayList<Integer> idxList = new ArrayList<Integer>(values.length);
                int listItemCount = ListAdapter.this.m_list.getItemCount();
                MatchUtil matchUtil = MatchUtil.getInstance();
                int i = 0;
                while (i < valuesLength) {
                    String value = values[i];
                    int j = ListAdapter.this.getStartingIndex(searchType);
                    while (j < listItemCount) {
                        String listItem = ListAdapter.this.m_list.getItem(j);
                        if (matchUtil.match(listItem, value, operator)) {
                            idxList.add(new Integer(j));
                        }
                        ++j;
                    }
                    ++i;
                }
                return idxList;
            }
        });
        Integer[] indices = new Integer[indexList.size()];
        indexList.toArray(indices);
        return indices;
    }

    private int getDisplayedItemCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getDisplayedItemCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                int listHeight = SwtUtils.getWidgetBounds((Widget)((ListAdapter)ListAdapter.this).m_list).height;
                int itemHeight = ListAdapter.this.m_list.getItemHeight();
                return new Integer(listHeight / itemHeight);
            }
        });
    }

    private void scrollIndexToVisible(final int index) {
        this.getEventThreadQueuer().invokeAndWait("scrollIndexToVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                ListAdapter.this.m_list.setTopIndex(index);
                return null;
            }
        });
    }

    private int getStartingIndex(String searchType) {
        int[] selectedIndices;
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative") && (selectedIndices = this.getSelectedIndices()).length > 0) {
            startingIndex = selectedIndices[selectedIndices.length - 1] + 1;
        }
        return startingIndex;
    }
}

