/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class ChartTitleFormatRecord
extends Record {
    public static final short sid = 4176;
    private int m_recs;
    private ArrayList m_formats;

    public ChartTitleFormatRecord() {
    }

    public ChartTitleFormatRecord(RecordInputStream in) {
        this.m_recs = in.readUShort();
        if (this.m_formats == null) {
            this.m_formats = new ArrayList(this.m_recs);
        }
        int idx = 0;
        while (idx < this.m_recs) {
            CTFormat ctf = new CTFormat(in.readShort(), in.readShort());
            this.m_formats.add(ctf);
            ++idx;
        }
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4176);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, (short)this.m_formats.size());
        int idx = 0;
        while (idx < this.m_formats.size()) {
            CTFormat ctf = (CTFormat)this.m_formats.get(idx);
            LittleEndian.putShort(data, 6 + idx * 4 + offset, ctf.getOffset());
            LittleEndian.putShort(data, 8 + idx * 4 + offset, ctf.getFontIndex());
            ++idx;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + 4 * this.m_formats.size();
    }

    public short getSid() {
        return 4176;
    }

    public int getFormatCount() {
        return this.m_formats.size();
    }

    public void modifyFormatRun(short oldPos, short newLen) {
        short shift = 0;
        int idx = 0;
        while (idx < this.m_formats.size()) {
            CTFormat ctf = (CTFormat)this.m_formats.get(idx);
            if (shift != 0) {
                ctf.setOffset((short)(ctf.getOffset() + shift));
            } else if (oldPos == ctf.getOffset() && idx < this.m_formats.size() - 1) {
                CTFormat nextCTF = (CTFormat)this.m_formats.get(idx + 1);
                shift = (short)(newLen - (nextCTF.getOffset() - ctf.getOffset()));
            }
            ++idx;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHARTTITLEFORMAT]\n");
        buffer.append("    .format_runs       = ").append(this.m_recs).append("\n");
        int idx = 0;
        while (idx < this.m_formats.size()) {
            CTFormat ctf = (CTFormat)this.m_formats.get(idx);
            buffer.append("       .char_offset= ").append(ctf.getOffset());
            buffer.append(",.fontidx= ").append(ctf.getFontIndex());
            buffer.append("\n");
            ++idx;
        }
        buffer.append("[/CHARTTITLEFORMAT]\n");
        return buffer.toString();
    }

    private class CTFormat {
        private short m_offset;
        private short m_fontIndex;

        protected CTFormat(short offset, short fontIdx) {
            this.m_offset = offset;
            this.m_fontIndex = fontIdx;
        }

        public short getOffset() {
            return this.m_offset;
        }

        public void setOffset(short newOff) {
            this.m_offset = newOff;
        }

        public short getFontIndex() {
            return this.m_fontIndex;
        }
    }
}

