/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReusedProjectSelectionDialog
extends TitleAreaDialog {
    private static final int HORIZONTAL_SPAN = 3;
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private static final int WIDTH_HINT = 300;
    private String[] m_projectNames;
    private Combo m_selectionWidget;
    private String m_selectedName;
    private String m_title;
    private String m_message;
    private boolean m_isWarning;
    private String m_titleImage;
    private String m_shellTitle;

    public ReusedProjectSelectionDialog(Shell parentShell, String[] projectNames, String title, String message, boolean isWarning, String titleImage, String shellTitle) {
        this(parentShell, projectNames, title, message, titleImage, shellTitle);
        this.m_isWarning = isWarning;
    }

    public ReusedProjectSelectionDialog(Shell parentShell, String[] projectNames, String title, String message, String titleImage, String shellTitle) {
        super(parentShell);
        this.m_projectNames = projectNames;
        Arrays.sort(this.m_projectNames);
        this.m_title = title;
        this.m_message = message;
        this.m_titleImage = titleImage;
        this.m_shellTitle = shellTitle;
    }

    public String getSelectedName() {
        return this.m_selectedName;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.m_title);
        if (this.m_isWarning) {
            this.setMessage(this.m_message, 2);
        } else {
            this.setMessage(this.m_message);
        }
        this.setTitleImage(Plugin.getImage(this.m_titleImage));
        this.getShell().setText(this.m_shellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 2;
        gridLayoutParent.marginHeight = 2;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        new Label(area, 0).setText(Messages.MoveTestCaseDialogLabel);
        GridData selectionGridData = new GridData();
        selectionGridData.grabExcessHorizontalSpace = true;
        selectionGridData.horizontalAlignment = 4;
        selectionGridData.horizontalSpan = 3;
        this.m_selectionWidget = new Combo(area, 8);
        this.m_selectionWidget.setLayoutData((Object)selectionGridData);
        String[] stringArray = this.m_projectNames;
        int n = this.m_projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.m_selectionWidget.add(name);
            ++n2;
        }
        this.m_selectionWidget.select(0);
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    protected void buttonPressed(int buttonId) {
        this.m_selectedName = this.m_selectionWidget.getItem(this.m_selectionWidget.getSelectionIndex());
        super.buttonPressed(buttonId);
    }
}

