/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.labelprovider.decorators;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.client.ui.provider.labelprovider.decorators.AbstractLightweightLabelDecorator;

public class TestResultParametersDecorator
extends AbstractLightweightLabelDecorator {
    private static final String SEPARATOR = ", ";
    private static final int SEPARATOR_LEN = ", ".length();

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof TestResultNode) {
            TestResultNode testResult = (TestResultNode)element;
            StringBuilder paramValueBuilder = new StringBuilder();
            List parameters = testResult.getParameters();
            int index = 0;
            while (index < parameters.size()) {
                TestResultParameter parameter = (TestResultParameter)parameters.get(index);
                paramValueBuilder.append(StringUtils.defaultString((String)parameter.getValue())).append(SEPARATOR);
                ++index;
            }
            if (paramValueBuilder.length() > 0) {
                int builderLength = paramValueBuilder.length();
                paramValueBuilder.delete(builderLength - SEPARATOR_LEN, builderLength);
                paramValueBuilder.insert(0, " [");
                paramValueBuilder.append("]");
                decoration.addSuffix(paramValueBuilder.toString());
            }
        }
    }
}

